/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrTypeClassRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrClassRefConverter
extends InstructionConverter {
    private static final int T_ZERO = 0;
    private static final int T_BOOLEAN = 10;
    private static final int T_BYTE = 11;
    private static final int T_SHORT = 12;
    private static final int T_INT = 13;
    private static final int T_REFERENCE = 14;

    public InstrClassRefConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    @Override
    public JcInstruction convert() throws Exception {
        int n = this.java_instr.getOpcode();
        String string = ((JInstrClassRef)this.java_instr).getClassName();
        JcConstantClassRef jcConstantClassRef = this.getClassRef(string);
        switch (n) {
            case 187: {
                this.jc_instr = new JcInstrClassRef(143, jcConstantClassRef);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 193: {
                int n2 = this.getAtype(string);
                this.checkIntType(n2);
                this.jc_instr = new JcInstrTypeClassRef(149, n2, jcConstantClassRef);
                this.operand_stack.pop();
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 192: {
                int n3 = this.getAtype(string);
                this.checkIntType(n3);
                this.jc_instr = new JcInstrTypeClassRef(148, n3, jcConstantClassRef);
                this.operand_stack.pop();
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private int getAtype(String string) {
        if (string.equals("[C") || string.equals("[L") || string.equals("[F") || string.equals("[D") || string.startsWith("[[")) {
            throw new ConverterInternalError();
        }
        if (string.equals("[Z")) {
            return 10;
        }
        if (string.equals("[B")) {
            return 11;
        }
        if (string.equals("[S")) {
            return 12;
        }
        if (string.equals("[I")) {
            return 13;
        }
        if (string.startsWith("[L")) {
            return 14;
        }
        return 0;
    }

    private JcConstantClassRef getClassRef(String string) throws Exception {
        int n = this.getAtype(string);
        JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
        switch (n) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
            case 0: {
                return jcConstantPool.addConstantClassRef(string);
            }
            case 14: {
                String string2 = string.substring(2, string.length() - 1);
                return jcConstantPool.addConstantClassRef(string2);
            }
        }
        throw new ConversionException();
    }

    private void checkIntType(int n) throws Exception {
        if (n == 13) {
            if (this.method_converter.isIntSupported()) {
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.6", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
            } else {
                Notifier.error(this.java_instr.getSourceLineNumber(), "int.6", this.method_converter.getClassName().replace('/', '.'));
                throw new ConversionException();
            }
        }
    }
}

