/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classparser;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

public class AccessFlags
implements Serializable {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SUPER = 32;
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_ARRAY = 4096;
    private int flags;

    public AccessFlags(DataInputStream dataInputStream) throws IOException {
        this.flags = dataInputStream.readUnsignedShort();
    }

    public String toString() {
        String string = new String("Class Access Flags:\t");
        if ((this.flags & 1) > 0) {
            string = string + "public ";
        }
        if ((this.flags & 0x10) > 0) {
            string = string + "final ";
        }
        if ((this.flags & 0x20) > 0) {
            string = string + "super ";
        }
        if ((this.flags & 0x200) > 0) {
            string = string + "interface ";
        }
        if ((this.flags & 0x400) > 0) {
            string = string + "abstract";
        }
        return string;
    }

    public byte getJDWPTypeTag() {
        if ((this.flags & 0x1000) > 0) {
            return 3;
        }
        if ((this.flags & 0x200) > 0) {
            return 2;
        }
        return 1;
    }

    public int getRawAccessFlags() {
        return this.flags;
    }
}

