/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExceptionTable {
    protected Vector<ExceptionTableEntry> entryVector;
    protected int relocAddr;
    protected boolean relocated;
    protected JCMethod parentMethod;

    ExceptionTable(JCMethod jCMethod) {
        this.parentMethod = jCMethod;
        this.entryVector = new Vector();
    }

    public void addExceptionEntry(ExceptionTableEntry exceptionTableEntry) {
        this.entryVector.addElement(exceptionTableEntry);
    }

    public Enumeration<ExceptionTableEntry> elements() {
        return this.entryVector.elements();
    }

    public int size() {
        return this.entryVector.size() * ExceptionTableEntry.size();
    }

    public int count() {
        return this.entryVector.size();
    }

    public void relocate(int n) {
        this.relocAddr = n;
        this.relocated = true;
    }

    public boolean isRelocated() {
        return this.relocated;
    }

    public int getRelocAddr() {
        assert (this.relocated) : "!relocated";
        return this.relocAddr;
    }

    protected void fixup(Hashtable<String, Integer> hashtable) {
        if (this.entryVector.size() == 0) {
            return;
        }
        for (ExceptionTableEntry exceptionTableEntry : this.entryVector) {
            exceptionTableEntry.fixup(hashtable);
        }
        for (int i = 0; i < this.entryVector.size(); ++i) {
            boolean bl = true;
            ExceptionTableEntry exceptionTableEntry = this.entryVector.get(i);
            for (int j = i + 1; j < this.entryVector.size(); ++j) {
                ExceptionTableEntry exceptionTableEntry2 = this.entryVector.get(j);
                if (exceptionTableEntry2.getStartOffset() > exceptionTableEntry.getStartOffset() || exceptionTableEntry2.getStartOffset() + exceptionTableEntry2.getActiveLength() < exceptionTableEntry.getStartOffset() + exceptionTableEntry.getActiveLength()) continue;
                bl = false;
            }
            exceptionTableEntry.isOuterMost = bl;
        }
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        int n = 0;
        for (ExceptionTableEntry exceptionTableEntry : this.entryVector) {
            byte[] byArray2 = exceptionTableEntry.toByteArray();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".exceptionTable {" + Msg.eol);
        for (ExceptionTableEntry exceptionTableEntry : this.entryVector) {
            stringBuffer.append(exceptionTableEntry.toString() + Msg.eol);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

