/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstant;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantSuperMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class ReferenceSIChecker {
    private JcPackage jc_package;
    private String package_name;
    private ExportFileManager ex_manager;
    private boolean check_export_only;
    private Hashtable<String, MethodDefinition[]> si_methods;

    public ReferenceSIChecker(JcPackage jcPackage, ExportFileManager exportFileManager, boolean bl) {
        this.jc_package = jcPackage;
        this.package_name = jcPackage.getPackageName();
        this.ex_manager = exportFileManager;
        this.check_export_only = bl;
        this.si_methods = new Hashtable();
    }

    public void check() throws Exception {
        JcClass[] jcClassArray;
        JcConstant[] jcConstantArray = this.jc_package.getConstantPool().getConstants();
        this.getFromConstantPool(jcConstantArray);
        for (JcClass jcClass : jcClassArray = this.jc_package.getClasses()) {
            this.checkClass(jcClass);
        }
    }

    public Vector<Hashtable<String, MethodDefinition[]>> getExactProxies() {
        JcClass[] jcClassArray;
        Vector<Hashtable<String, MethodDefinition[]>> vector = new Vector<Hashtable<String, MethodDefinition[]>>();
        for (JcClass jcClass : jcClassArray = this.jc_package.getClasses()) {
            Hashtable<String, MethodDefinition[]> hashtable = new Hashtable<String, MethodDefinition[]>();
            if (jcClass.isShareableType() && !jcClass.isInterfaceType()) {
                JcImplementedInterfaceInfo[] jcImplementedInterfaceInfoArray;
                for (JcImplementedInterfaceInfo jcImplementedInterfaceInfo : jcImplementedInterfaceInfoArray = jcClass.getImplementedInterfaceInfos()) {
                    String string = jcImplementedInterfaceInfo.getInterfaceName();
                    if (!this.isShareableInterface(string)) continue;
                    MethodDefinition[] methodDefinitionArray = jcImplementedInterfaceInfo.getInterfaceMethods();
                    hashtable.put(string, methodDefinitionArray);
                }
            }
            if (hashtable.size() <= 0) continue;
            vector.addElement(hashtable);
        }
        return vector;
    }

    private boolean isShareableInterface(String string) {
        JcClass[] jcClassArray;
        for (JcClass jcClass : jcClassArray = this.jc_package.getClasses()) {
            if (!string.equals(jcClass.getClassName())) continue;
            return jcClass.isShareableType();
        }
        return false;
    }

    public Hashtable<String, MethodDefinition[]> getSIMethodsTable() {
        return this.si_methods;
    }

    public String getPackageName() {
        return this.package_name;
    }

    private void getFromConstantPool(JcConstant[] jcConstantArray) throws Exception {
        if (jcConstantArray.length == 0) {
            return;
        }
        for (int i = 0; i < jcConstantArray.length; ++i) {
            String string;
            JcConstant jcConstant;
            JcConstant jcConstant2 = jcConstantArray[i];
            if (jcConstant2 instanceof JcConstantClassRef) {
                jcConstant = (JcConstantClassRef)jcConstant2;
                string = ((JcConstantClassRef)jcConstant).getClassName();
                this.getFromClassRef(string);
                continue;
            }
            if (jcConstant2 instanceof JcConstantMethodRef) {
                jcConstant = (JcConstantMethodRef)jcConstant2;
                string = ((JcConstantMethodRef)jcConstant).getDescriptor();
                this.getFromMethodRef(string);
                continue;
            }
            if (!(jcConstant2 instanceof JcConstantFieldRef)) continue;
            jcConstant = (JcConstantFieldRef)jcConstant2;
            string = ((JcConstantFieldRef)jcConstant).getDescriptor();
            String string2 = Names.getClassNameFromDescriptor(string);
            this.getFromClassRef(string2);
        }
    }

    private void getFromMethodRef(String string) throws Exception {
        String[] stringArray;
        for (String string2 : stringArray = MethodDescriptor.getParamDescriptors(string)) {
            String string3 = Names.getClassNameFromDescriptor(string2);
            this.getFromClassRef(string3);
        }
        String string4 = MethodDescriptor.getReturnDescriptor(string);
        String string5 = Names.getClassNameFromDescriptor(string4);
        this.getFromClassRef(string5);
    }

    private void getFromClassRef(String string) throws Exception {
        if (string == null) {
            return;
        }
        if (this.thisPackage(string)) {
            String[] stringArray;
            Vector<String> vector;
            JcClass jcClass = this.jc_package.getClass(string);
            if (jcClass.isPublic() && jcClass.isInterfaceType() && !this.si_methods.containsKey(string) && (vector = new Vector<String>(Arrays.asList(stringArray = this.check_export_only ? jcClass.getPublicSuperInterfaces() : jcClass.getSuperInterfaces()))).contains("javacard/framework/Shareable")) {
                this.si_methods.put(string, jcClass.getMethods());
            }
        } else {
            String[] stringArray;
            Vector<String> vector;
            EfClass efClass = this.ex_manager.getClass(string);
            if (efClass.isInterfaceType() && !this.si_methods.containsKey(string) && (vector = new Vector<String>(Arrays.asList(stringArray = efClass.getInterfaceNames()))).contains("javacard/framework/Shareable")) {
                this.si_methods.put(string, efClass.getMethods());
            }
        }
    }

    private boolean thisPackage(String string) {
        String string2 = Names.getPackageName(string);
        return this.package_name.equals(string2);
    }

    private void checkSuperInterfaces(JcClass jcClass) throws Exception {
        String[] stringArray = this.check_export_only ? jcClass.getPublicSuperInterfaces() : jcClass.getSuperInterfaces();
        for (String string : stringArray) {
            this.getFromClassRef(string);
        }
    }

    private void checkClass(JcClass jcClass) throws Exception {
        int n = jcClass.getAccessFlags();
        if (!this.check_export_only || Modifier.isPublic(n)) {
            int n2;
            String string = jcClass.getSuperClassName();
            this.getFromClassRef(string);
            this.checkSuperInterfaces(jcClass);
            JcField[] jcFieldArray = jcClass.getFields();
            Object[] objectArray = jcFieldArray;
            int n3 = objectArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                JcField jcField = objectArray[n2];
                int n4 = jcField.getAccessFlags();
                if (this.check_export_only && !Modifier.isPublic(n4) && !Modifier.isProtected(n4)) continue;
                String string2 = Names.getClassNameFromDescriptor(jcField.getFieldDescriptor());
                this.getFromClassRef(string2);
            }
            Object[] objectArray2 = objectArray = jcClass.getMethods();
            n2 = objectArray2.length;
            for (int i = 0; i < n2; ++i) {
                Object object = objectArray2[i];
                int n5 = ((MethodDefinition)object).getAccessFlags();
                if (!this.check_export_only || Modifier.isPublic(n5) || Modifier.isProtected(n5)) {
                    this.getFromMethodRef(((MethodDefinition)object).getMethodDescriptor());
                }
                if (this.check_export_only) continue;
                this.checkBytecode(jcClass, (JcMethod)object);
                this.checkExceptionTable(jcClass, (JcMethod)object);
            }
            for (Object object : objectArray2 = jcClass.getPublicMethodTable().getMethods()) {
                this.getFromMethodRef(((MethodDefinition)object).getMethodDescriptor());
            }
            for (Object object : objectArray2 = jcClass.getPackageMethodTable().getMethods()) {
                this.getFromMethodRef(((MethodDefinition)object).getMethodDescriptor());
            }
        }
    }

    private void checkExceptionTable(JcClass jcClass, JcMethod jcMethod) throws Exception {
        JcException[] jcExceptionArray;
        for (JcException jcException : jcExceptionArray = jcMethod.getExceptions()) {
            String string = jcException.getCatchTypeClassRef().getClassName();
            if (string.equals("finally")) continue;
            this.getFromClassRef(string);
        }
    }

    private void checkBytecode(JcClass jcClass, JcMethod jcMethod) throws Exception {
        for (JcInstruction jcInstruction = jcMethod.getCode(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
            String string;
            String string2;
            String string3;
            String string4;
            JcConstant jcConstant;
            int n = jcInstruction.getSourceLineNumber();
            if (jcInstruction instanceof JcInstrClassRef && (jcConstant = ((JcInstrClassRef)jcInstruction).getClassRef()) != null) {
                string4 = ((JcConstantClassRef)jcConstant).getClassName();
                this.getFromClassRef(string4);
            }
            if (jcInstruction instanceof JcInstrFieldRef) {
                jcConstant = ((JcInstrFieldRef)jcInstruction).getFieldRef();
                string4 = ((JcConstantFieldRef)jcConstant).getClassName();
                string = this.checkField(jcClass, string4, string3 = ((JcConstantFieldRef)jcConstant).getFieldName(), string2 = ((JcConstantFieldRef)jcConstant).getDescriptor(), n);
                if (string != null) {
                    string4 = string;
                    ((JcConstantFieldRef)jcConstant).setClassName(string4);
                }
                String string5 = Names.getClassNameFromDescriptor(string2);
                this.getFromClassRef(string5);
            }
            if (!(jcInstruction instanceof JcInstrMethodRef)) continue;
            jcConstant = ((JcInstrMethodRef)jcInstruction).getMethodRef();
            string4 = ((JcConstantMethodRef)jcConstant).getClassName();
            string3 = ((JcConstantMethodRef)jcConstant).getMethodName();
            string2 = ((JcConstantMethodRef)jcConstant).getDescriptor();
            if (jcConstant instanceof JcConstantSuperMethodRef) continue;
            string = this.checkMethod(jcClass, string4, string3, string2, n);
            if (string != null) {
                string4 = string;
                ((JcConstantMethodRef)jcConstant).setClassName(string);
            }
            this.getFromMethodRef(string2);
        }
    }

    private boolean checkMethodTable(JcClass jcClass, String string, String string2) {
        MethodDefinition[] methodDefinitionArray;
        MethodDefinition[] methodDefinitionArray2 = methodDefinitionArray = jcClass.getPublicMethodTable().getMethods();
        int n = methodDefinitionArray2.length;
        for (int i = 0; i < n; ++i) {
            MethodDefinition methodDefinition = methodDefinitionArray2[i];
            if (!methodDefinition.getMethodName().equals(string) || !methodDefinition.getMethodDescriptor().equals(string2)) continue;
            return true;
        }
        for (MethodDefinition methodDefinition : methodDefinitionArray2 = jcClass.getPackageMethodTable().getMethods()) {
            if (!methodDefinition.getMethodName().equals(string) || !methodDefinition.getMethodDescriptor().equals(string2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkMethod(JcClass jcClass, String string, String string2, String string3, int n) throws Exception {
        String string4 = null;
        if (this.thisPackage(string)) {
            JcClass jcClass2 = this.jc_package.getClass(string);
            if (jcClass2 == null) return string4;
            if (this.jc_package.getMethod(string, string2, string3) != null) return string4;
            if (!this.checkMethodTable(jcClass2, string2, string3)) {
                MethodDefinition methodDefinition;
                int n2 = jcClass2.getAccessFlags();
                if (Modifier.isInterface(n2)) return string4;
                String string5 = jcClass2.getClassName();
                while (true) {
                    ClassDefinition classDefinition;
                    if (this.thisPackage(string5)) {
                        classDefinition = this.jc_package.getClass(string5);
                        string5 = classDefinition.getSuperClassName();
                    } else {
                        classDefinition = this.ex_manager.getClass(string5);
                        string5 = ((EfClass)classDefinition).getSuperClassName(this.ex_manager);
                    }
                    if (string5 == null) return string4;
                    if (this.thisPackage(string5)) {
                        classDefinition = this.jc_package.getClass(string5);
                        methodDefinition = ((JcClass)classDefinition).getMethod(string2, string3);
                        if (methodDefinition == null) continue;
                        this.getFromMethodRef(methodDefinition.getMethodDescriptor());
                        return string5;
                    }
                    classDefinition = this.ex_manager.getClass(string5);
                    methodDefinition = ((EfClass)classDefinition).getMethod(string2, string3);
                    if (methodDefinition != null) break;
                }
                this.getFromMethodRef(methodDefinition.getMethodDescriptor());
                return string5;
            }
            String string6 = jcClass2.getClassName();
            ClassDefinition classDefinition = null;
            while ((string6 = (classDefinition = this.thisPackage(string6) ? this.jc_package.getClass(string6) : this.ex_manager.getClass(string6)).getSuperClassName()) != null) {
                MethodDefinition methodDefinition;
                ClassDefinition classDefinition2;
                if (this.thisPackage(string6)) {
                    classDefinition2 = this.jc_package.getClass(string6);
                    methodDefinition = ((JcClass)classDefinition2).getMethod(string2, string3);
                    if (methodDefinition == null) continue;
                    this.getFromMethodRef(methodDefinition.getMethodDescriptor());
                    return string6;
                }
                classDefinition2 = this.ex_manager.getClass(string6);
                methodDefinition = ((EfClass)classDefinition2).getMethod(string2, string3);
                if (methodDefinition == null) return string4;
                this.getFromMethodRef(methodDefinition.getMethodDescriptor());
                return string6;
            }
            return string4;
        } else {
            EfClass efClass = this.ex_manager.getClass(string);
            if (efClass == null) return string4;
            EfMethod efMethod = this.ex_manager.getMethod(string, string2, string3);
            if (efMethod == null) return string4;
            this.getFromMethodRef(efMethod.getMethodDescriptor());
        }
        return string4;
    }

    private String checkField(JcClass jcClass, String string, String string2, String string3, int n) throws Exception {
        if (this.thisPackage(string)) {
            JcClass jcClass2 = this.jc_package.getClass(string);
            if (jcClass2 != null && this.jc_package.getField(string, string2, string3) == null) {
                boolean bl = false;
                String string4 = jcClass2.getClassName();
                while (!bl) {
                    if (this.jc_package.getClass(string4) != null) {
                        Object object;
                        String string5 = this.jc_package.getClass(string4).getSuperClassName();
                        if (this.thisPackage(string5)) {
                            string4 = string5;
                            if (this.jc_package.getField(string4, string2, string3) == null) continue;
                            bl = true;
                            object = Names.getClassNameFromDescriptor(string3);
                            this.getFromClassRef((String)object);
                            return string4;
                        }
                        string4 = string5;
                        object = this.ex_manager.getClass(string4);
                        if (((EfClass)object).getField(string2, string3) != null) {
                            bl = true;
                            return string4;
                        }
                        String[] stringArray = ((EfClass)object).getSuperClassNames();
                        for (int i = 0; i < stringArray.length; ++i) {
                            object = this.ex_manager.getClass(stringArray[i]);
                            if (((EfClass)object).getField(string2, string3) == null) continue;
                            bl = true;
                            String string6 = Names.getClassNameFromDescriptor(string3);
                            this.getFromClassRef(string6);
                            return stringArray[i];
                        }
                        bl = true;
                        continue;
                    }
                    bl = true;
                }
            }
        } else {
            EfField efField;
            EfClass efClass = this.ex_manager.getClass(string);
            if (efClass != null && (efField = this.ex_manager.getField(string, string2, string3)) != null) {
                String string7 = Names.getClassNameFromDescriptor(string3);
                this.getFromClassRef(string7);
            }
        }
        return null;
    }
}

