/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class SizeOutputFormatter
extends OutputFormatter {
    private int nPackages;
    private int nClasses;
    private int nStaticFields;
    private int nFinalStaticFields;
    private int classSize;
    private int nMethods;
    private int nNativeMethods;
    private int methodSize;
    private int exTblCount;
    private int exportSize;
    private Vector<PackageStat> packageStats = new Vector();
    private Vector<ClassStat> classStats = new Vector();
    private Vector<MethodStat> methodStats = new Vector();

    public SizeOutputFormatter(BufferedReader bufferedReader) throws IOException {
        super(bufferedReader);
    }

    @Override
    public void format(RomMask romMask) {
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            JCPackage jCPackage = enumeration.nextElement();
            ExportComponent exportComponent = new ExportComponent(jCPackage);
            ++this.nPackages;
            this.packageStats.addElement(new PackageStat(jCPackage.getIdentifier()));
            Enumeration<JCClass> enumeration2 = jCPackage.classElements();
            while (enumeration2.hasMoreElements()) {
                int n;
                Member member;
                JCClass jCClass = enumeration2.nextElement();
                jCClass.relocate(0);
                ++this.nClasses;
                this.classSize += jCClass.size();
                this.classStats.addElement(new ClassStat(jCClass.getName(), jCClass.size()));
                Enumeration<Member> enumeration3 = jCClass.fieldElements();
                while (enumeration3.hasMoreElements()) {
                    member = enumeration3.nextElement();
                    member.relocate(0);
                    n = member.getAttributes();
                    if (!Modifier.isStatic(n)) continue;
                    ++this.nStaticFields;
                    if (!Modifier.isFinal(n)) continue;
                    ++this.nFinalStaticFields;
                }
                enumeration3 = jCClass.methodElements();
                while (enumeration3.hasMoreElements()) {
                    member = (JCMethod)enumeration3.nextElement();
                    member.relocate(0);
                    n = member.getAttributes();
                    if (Modifier.isNative(n)) {
                        ++this.nNativeMethods;
                        continue;
                    }
                    ++this.nMethods;
                    this.methodSize += ((JCMethod)member).size();
                    this.methodStats.addElement(new MethodStat(member.getName(), ((JCMethod)member).size()));
                    ExceptionTable exceptionTable = ((JCMethod)member).getExceptionTable();
                    if (exceptionTable == null) continue;
                    Enumeration<ExceptionTableEntry> enumeration4 = exceptionTable.elements();
                    while (enumeration4.hasMoreElements()) {
                        ExceptionTableEntry exceptionTableEntry = enumeration4.nextElement();
                        ++this.exTblCount;
                    }
                }
                exportComponent.add(jCClass);
            }
            this.exportSize += exportComponent.size();
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        Object[] objectArray = new Object[4];
        printWriter.println(Msg.getMessage("size.1"));
        objectArray[0] = new Integer(this.nPackages);
        printWriter.println(Msg.getMessage("size.2", objectArray));
        objectArray[0] = new Integer(this.nClasses);
        printWriter.println(Msg.getMessage("size.3", objectArray));
        objectArray[0] = new Integer(this.nMethods);
        printWriter.println(Msg.getMessage("size.4", objectArray));
        objectArray[0] = new Integer(this.nNativeMethods);
        printWriter.println(Msg.getMessage("size.5", objectArray));
        objectArray[0] = new Integer(this.nStaticFields);
        objectArray[1] = new Integer(this.nFinalStaticFields);
        printWriter.println(Msg.getMessage("size.6", objectArray));
        objectArray[0] = new Integer(this.classSize);
        printWriter.println(Msg.getMessage("size.7", objectArray));
        objectArray[0] = new Integer(this.methodSize);
        printWriter.println(Msg.getMessage("size.8", objectArray));
        objectArray[0] = new Integer(this.exTblCount * 8);
        objectArray[1] = new Integer(this.exTblCount);
        printWriter.println(Msg.getMessage("size.12", objectArray));
        objectArray[0] = new Integer(this.exportSize);
        printWriter.println(Msg.getMessage("size.13", objectArray));
        printWriter.println("");
        printWriter.println(Msg.getMessage("size.9", null));
        for (PackageStat object : this.packageStats) {
            objectArray[0] = object.pid.getAid().toString();
            objectArray[1] = new Integer(object.pid.getMajorVersion());
            objectArray[2] = new Integer(object.pid.getMinorVersion());
            printWriter.println(Msg.getMessage("size.91", objectArray));
        }
        printWriter.println("");
        printWriter.println(Msg.getMessage("size.10", null));
        for (ClassStat classStat : this.classStats) {
            printWriter.println(classStat.name + ": " + classStat.size);
        }
        printWriter.println("");
        printWriter.println(Msg.getMessage("size.11", null));
        for (MethodStat methodStat : this.methodStats) {
            printWriter.println(methodStat.name + ": " + methodStat.size);
        }
        printWriter.flush();
    }

    static class MethodStat {
        String name;
        int size;

        MethodStat(String string, int n) {
            this.name = string;
            this.size = n;
        }
    }

    static class ClassStat {
        String name;
        int size;

        ClassStat(String string, int n) {
            this.name = string;
            this.size = n;
        }
    }

    static class PackageStat {
        PackageIdentifier pid;

        PackageStat(PackageIdentifier packageIdentifier) {
            this.pid = packageIdentifier;
        }
    }
}

