/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.spi.project.support.rake.FilterPropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class PropertyUtils {
    private static Map<File, Reference<PropertyProvider>> globalPropertyProviders = new HashMap<File, Reference<PropertyProvider>>();
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
    private static final Pattern VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]");

    private PropertyUtils() {
    }

    static File userBuildProperties() {
        String nbuser = System.getProperty("netbeans.user");
        if (nbuser != null) {
            return FileUtil.normalizeFile((File)new File(nbuser, "build.properties"));
        }
        return null;
    }

    public static EditableProperties getGlobalProperties() {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public EditableProperties run() {
                File ubp = PropertyUtils.userBuildProperties();
                if (ubp != null && ubp.isFile() && ubp.canRead()) {
                    EditableProperties editableProperties;
                    FileInputStream is = new FileInputStream(ubp);
                    try {
                        EditableProperties properties = new EditableProperties(true);
                        properties.load((InputStream)is);
                        editableProperties = properties;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)is).close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            Logger.getLogger(PropertyUtils.class.getName()).log(Level.INFO, null, e);
                        }
                    }
                    ((InputStream)is).close();
                    return editableProperties;
                }
                return new EditableProperties(true);
            }
        });
    }

    public static void putGlobalProperties(final EditableProperties properties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    block15: {
                        File ubp = PropertyUtils.userBuildProperties();
                        if (ubp != null) {
                            FileObject bp = FileUtil.toFileObject((File)ubp);
                            if (bp == null) {
                                if (!ubp.exists()) {
                                    FileObject folder = FileUtil.createFolder((File)ubp.getParentFile());
                                    folder.createData(ubp.getName());
                                    assert (ubp.isFile()) : "Did not actually make " + ubp;
                                }
                                if ((bp = FileUtil.toFileObject((File)ubp)) == null) {
                                    ErrorManager.getDefault().log(16, "Warning - cannot properly write to " + ubp + "; might be because your user directory is on a Windows UNC path (issue #46813)? If so, try using mapped drive letters.");
                                    FileOutputStream os = new FileOutputStream(ubp);
                                    try {
                                        properties.store((OutputStream)os);
                                    }
                                    finally {
                                        ((OutputStream)os).close();
                                    }
                                    return null;
                                }
                            }
                            FileLock lock = bp.lock();
                            try {
                                OutputStream os = bp.getOutputStream(lock);
                                try {
                                    properties.store(os);
                                    break block15;
                                }
                                finally {
                                    os.close();
                                }
                            }
                            finally {
                                lock.releaseLock();
                            }
                        }
                        throw new IOException("Do not know where to store build.properties; must set netbeans.user!");
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static synchronized PropertyProvider globalPropertyProvider() {
        File ubp = PropertyUtils.userBuildProperties();
        if (ubp != null) {
            PropertyProvider pp;
            Reference<PropertyProvider> globalPropertyProvider = globalPropertyProviders.get(ubp);
            if (globalPropertyProvider != null && (pp = globalPropertyProvider.get()) != null) {
                return pp;
            }
            PropertyProvider gpp = PropertyUtils.propertiesFilePropertyProvider(ubp);
            globalPropertyProviders.put(ubp, new SoftReference<PropertyProvider>(gpp));
            return gpp;
        }
        return PropertyUtils.fixedPropertyProvider(Collections.<String, String>emptyMap());
    }

    public static PropertyProvider propertiesFilePropertyProvider(File propertiesFile) {
        assert (propertiesFile != null);
        return new FilePropertyProvider(propertiesFile);
    }

    private static Map<String, String> evaluateAll(Map<String, String> predefs, List<Map<String, String>> defs) {
        HashMap<String, String> m = new HashMap<String, String>(predefs);
        for (Map<String, String> curr : defs) {
            List sorted;
            HashMap<String, Object> dependOnSiblings = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : curr.entrySet()) {
                String prop = entry.getKey();
                if (m.containsKey(prop)) continue;
                String rawval = entry.getValue();
                Union2<String, Set<String>> o = PropertyUtils.substitute(rawval, m, curr.keySet());
                if (o.hasFirst()) {
                    m.put(prop, (String)o.first());
                    continue;
                }
                dependOnSiblings.put(prop, o.second());
            }
            HashSet toSort = new HashSet(dependOnSiblings.keySet());
            for (Set s : dependOnSiblings.values()) {
                toSort.addAll(s);
            }
            try {
                sorted = Utilities.topologicalSort(toSort, dependOnSiblings);
            }
            catch (TopologicalSortException e) {
                return null;
            }
            Collections.reverse(sorted);
            for (String prop : sorted) {
                if (m.containsKey(prop)) continue;
                String rawval = curr.get(prop);
                m.put(prop, (String)PropertyUtils.substitute(rawval, m, curr.keySet()).first());
            }
        }
        return m;
    }

    private static Union2<String, Set<String>> substitute(String rawval, Map<String, String> predefs, Set<String> siblingProperties) {
        assert (rawval != null) : "null rawval passed in";
        if (rawval.indexOf(36) == -1) {
            return Union2.createFirst((Object)rawval);
        }
        int idx = 0;
        StringBuffer val = new StringBuffer();
        HashSet<String> needed = new HashSet<String>();
        while (true) {
            int shell;
            if ((shell = rawval.indexOf(36, idx)) == -1 || shell == rawval.length() - 1) {
                if (needed.isEmpty()) {
                    val.append(rawval.substring(idx));
                    return Union2.createFirst((Object)val.toString());
                }
                return Union2.createSecond(needed);
            }
            char c = rawval.charAt(shell + 1);
            if (c == '$') {
                if (needed.isEmpty()) {
                    val.append('$');
                }
                idx += 2;
                continue;
            }
            if (c == '{') {
                int end = rawval.indexOf(125, shell + 2);
                if (end != -1) {
                    String otherprop = rawval.substring(shell + 2, end);
                    if (predefs.containsKey(otherprop)) {
                        if (needed.isEmpty()) {
                            val.append(rawval.substring(idx, shell));
                            val.append(predefs.get(otherprop));
                        }
                        idx = end + 1;
                        continue;
                    }
                    if (siblingProperties.contains(otherprop)) {
                        needed.add(otherprop);
                        idx = end + 1;
                        continue;
                    }
                    if (needed.isEmpty()) {
                        val.append(rawval.substring(idx, end + 1));
                    }
                    idx = end + 1;
                    continue;
                }
                if (needed.isEmpty()) {
                    val.append(rawval.substring(idx));
                    return Union2.createFirst((Object)val.toString());
                }
                return Union2.createSecond(needed);
            }
            if (needed.isEmpty()) {
                val.append(rawval.substring(idx, idx + 2));
            }
            idx += 2;
        }
    }

    public static File resolveFile(File basedir, String filename) throws IllegalArgumentException {
        File f;
        if (basedir == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!basedir.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + basedir);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            f = new File(basedir, filename.replace('/', File.separatorChar));
        } else {
            String machinePath = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            f = new File(machinePath);
            if (!f.isAbsolute()) {
                f = new File(basedir, machinePath);
            }
            assert (f.isAbsolute());
        }
        return FileUtil.normalizeFile((File)f);
    }

    public static String relativizeFile(File basedir, File file) {
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + basedir);
        }
        if (basedir.equals(file)) {
            return ".";
        }
        StringBuffer b = new StringBuffer();
        File base = basedir;
        String filepath = file.getAbsolutePath();
        while (!filepath.startsWith(PropertyUtils.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(file)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = base.toURI().relativize(file.toURI());
        assert (!u.isAbsolute()) : u + " from " + basedir + " and " + file + " with common root " + base;
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    static FileObject resolveFileObject(FileObject basedir, String filename) {
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            return basedir.getFileObject(filename);
        }
        return FileUtil.toFileObject((File)PropertyUtils.resolveFile(FileUtil.toFile((FileObject)basedir), filename));
    }

    static String resolvePath(File basedir, String path) {
        StringBuffer b = new StringBuffer();
        String[] toks = PropertyUtils.tokenizePath(path);
        for (int i = 0; i < toks.length; ++i) {
            if (i > 0) {
                b.append(File.pathSeparatorChar);
            }
            b.append(PropertyUtils.resolveFile(basedir, toks[i]).getAbsolutePath());
        }
        return b.toString();
    }

    public static String[] tokenizePath(String path) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, ":;", true);
        char dosHack = '\u0000';
        int lastDelim = 0;
        int delimCount = 0;
        while (tok.hasMoreTokens()) {
            char c;
            String s = tok.nextToken();
            if (s.length() == 0) continue;
            if (s.length() == 1 && ((c = s.charAt(0)) == ':' || c == ';')) {
                lastDelim = c;
                ++delimCount;
                continue;
            }
            if (dosHack != '\u0000') {
                if (lastDelim == 58 && delimCount == 1 && (s.charAt(0) == '\\' || s.charAt(0) == '/')) {
                    s = "" + dosHack + ':' + s;
                } else {
                    l.add(Character.toString(dosHack));
                }
                dosHack = '\u0000';
            }
            delimCount = 0;
            if (s.length() == 1 && ((c = s.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                dosHack = c;
                continue;
            }
            l.add(s);
        }
        if (dosHack != '\u0000') {
            l.add(Character.toString(dosHack));
        }
        return l.toArray(new String[l.size()]);
    }

    public static boolean isUsablePropertyName(String name) {
        return VALID_PROPERTY_NAME.matcher(name).matches();
    }

    public static String getUsablePropertyName(String name) {
        if (PropertyUtils.isUsablePropertyName(name)) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        for (int i = 0; i < sb.length(); ++i) {
            if (PropertyUtils.isUsablePropertyName(sb.substring(i, i + 1))) continue;
            sb.replace(i, i + 1, "_");
        }
        return sb.toString();
    }

    public static PropertyProvider fixedPropertyProvider(Map<String, String> defs) {
        return new FixedPropertyProvider(defs);
    }

    public static PropertyEvaluator sequentialPropertyEvaluator(PropertyProvider preprovider, PropertyProvider ... providers) {
        return new SequentialPropertyEvaluator(preprovider, providers);
    }

    public static PropertyProvider userPropertiesProvider(PropertyEvaluator findUserPropertiesFile, String propertyName, File basedir) {
        return new UserPropertiesProvider(findUserPropertiesFile, propertyName, basedir);
    }

    private static final class SequentialPropertyEvaluator
    implements PropertyEvaluator,
    ChangeListener {
        private final PropertyProvider preprovider;
        private final PropertyProvider[] providers;
        private Map<String, String> defs;
        private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

        public SequentialPropertyEvaluator(final PropertyProvider preprovider, final PropertyProvider[] providers) {
            this.preprovider = preprovider;
            this.providers = providers;
            this.defs = (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<String, String>>(){

                public Map<String, String> run() {
                    return SequentialPropertyEvaluator.compose(preprovider, providers);
                }
            });
            if (preprovider != null) {
                preprovider.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)preprovider));
            }
            for (PropertyProvider pp : providers) {
                pp.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)pp));
            }
        }

        @Override
        public String getProperty(final String prop) {
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    if (SequentialPropertyEvaluator.this.defs == null) {
                        return null;
                    }
                    return (String)SequentialPropertyEvaluator.this.defs.get(prop);
                }
            });
        }

        @Override
        public String evaluate(final String text) {
            if (text == null) {
                throw new NullPointerException("Attempted to pass null to PropertyEvaluator.evaluate");
            }
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    if (SequentialPropertyEvaluator.this.defs == null) {
                        return null;
                    }
                    Union2 result = PropertyUtils.substitute(text, SequentialPropertyEvaluator.this.defs, Collections.emptySet());
                    assert (result.hasFirst()) : "Unexpected result " + result + " from " + text + " on " + SequentialPropertyEvaluator.access$100(SequentialPropertyEvaluator.this);
                    return (String)result.first();
                }
            });
        }

        @Override
        public Map<String, String> getProperties() {
            return (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<String, String>>(){

                public Map<String, String> run() {
                    return SequentialPropertyEvaluator.this.defs;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            Map<String, String> _newdefs;
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            Map<String, String> newdefs = SequentialPropertyEvaluator.compose(this.preprovider, this.providers);
            Map<Object, Object> _defs = this.defs != null ? this.defs : Collections.emptyMap();
            Map<String, String> map = _newdefs = newdefs != null ? newdefs : Collections.emptyMap();
            if (!((Object)_defs).equals(_newdefs)) {
                PropertyChangeListener[] _listeners;
                Object prop2;
                HashSet<Object> props = new HashSet<Object>(_defs.keySet());
                props.addAll(_newdefs.keySet());
                LinkedList<PropertyChangeEvent> events = new LinkedList<PropertyChangeEvent>();
                for (Object prop2 : props) {
                    assert (prop2 != null);
                    String oldval = (String)_defs.get(prop2);
                    String newval = _newdefs.get(prop2);
                    if (newval != null) {
                        if (newval.equals(oldval)) {
                            continue;
                        }
                    } else assert (oldval != null) : "should not have had " + (String)prop2;
                    events.add(new PropertyChangeEvent(this, (String)prop2, oldval, newval));
                }
                assert (!events.isEmpty());
                this.defs = newdefs;
                prop2 = this.listeners;
                synchronized (prop2) {
                    _listeners = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
                }
                for (PropertyChangeListener l : _listeners) {
                    for (PropertyChangeEvent ev : events) {
                        l.propertyChange(ev);
                    }
                }
            }
        }

        private static Map<String, String> compose(PropertyProvider preprovider, PropertyProvider[] providers) {
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            Map<Object, Object> predefs = preprovider != null ? preprovider.getProperties() : Collections.emptyMap();
            ArrayList<Map<String, String>> defs = new ArrayList<Map<String, String>>(providers.length);
            for (PropertyProvider pp : providers) {
                defs.add(pp.getProperties());
            }
            return PropertyUtils.evaluateAll(predefs, defs);
        }
    }

    private static final class UserPropertiesProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator findUserPropertiesFile;
        private final String propertyName;
        private final File basedir;

        public UserPropertiesProvider(PropertyEvaluator findUserPropertiesFile, String propertyName, File basedir) {
            super(UserPropertiesProvider.computeDelegate(findUserPropertiesFile, propertyName, basedir));
            this.findUserPropertiesFile = findUserPropertiesFile;
            this.propertyName = propertyName;
            this.basedir = basedir;
            findUserPropertiesFile.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (this.propertyName.equals(ev.getPropertyName())) {
                this.setDelegate(UserPropertiesProvider.computeDelegate(this.findUserPropertiesFile, this.propertyName, this.basedir));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator findUserPropertiesFile, String propertyName, File basedir) {
            String userPropertiesFile = findUserPropertiesFile.getProperty(propertyName);
            if (userPropertiesFile != null) {
                File f = PropertyUtils.resolveFile(basedir, userPropertiesFile);
                if (f.equals(PropertyUtils.userBuildProperties())) {
                    return PropertyUtils.globalPropertyProvider();
                }
                return PropertyUtils.propertiesFilePropertyProvider(f);
            }
            return PropertyUtils.globalPropertyProvider();
        }
    }

    private static final class FixedPropertyProvider
    implements PropertyProvider {
        private final Map<String, String> defs;

        public FixedPropertyProvider(Map<String, String> defs) {
            this.defs = defs;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.defs;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class FilePropertyProvider
    implements PropertyProvider,
    FileChangeListener {
        private static final RequestProcessor RP = new RequestProcessor("PropertyUtils.FilePropertyProvider.RP");
        private final File properties;
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private Map<String, String> cached = null;
        private long cachedTime = 0L;

        public FilePropertyProvider(File properties) {
            this.properties = properties;
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)properties);
        }

        @Override
        public Map<String, String> getProperties() {
            long currTime = this.properties.lastModified();
            if (this.cached == null || this.cachedTime != currTime) {
                this.cachedTime = currTime;
                this.cached = this.loadProperties();
            }
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> loadProperties() {
            if (this.properties.isFile() && this.properties.canRead()) {
                Map map;
                FileInputStream is = new FileInputStream(this.properties);
                try {
                    Properties props = new Properties();
                    props.load(is);
                    map = NbCollections.checkedMapByFilter((Map)props, String.class, String.class, (boolean)true);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.getLogger(PropertyUtils.class.getName()).log(Level.INFO, null, e);
                    }
                }
                ((InputStream)is).close();
                return map;
            }
            return Collections.emptyMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] ls;
            this.cachedTime = -1L;
            FilePropertyProvider filePropertyProvider = this;
            synchronized (filePropertyProvider) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            final ChangeEvent ev = new ChangeEvent(this);
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    for (ChangeListener l : ls) {
                        l.stateChanged(ev);
                    }
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    @Override
                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }

        @Override
        public synchronized void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileChanged(FileEvent fe) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.fireChange();
        }

        public String toString() {
            return "FilePropertyProvider[" + this.properties + ":" + this.getProperties() + "]";
        }
    }
}

