/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.jira;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.jira.DownloadPlugin;
import org.netbeans.modules.bugtracking.jira.MissingJiraSupportPanel;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JiraUpdater {
    private static JiraUpdater instance;
    private JiraProxyConector connector;

    private JiraUpdater() {
    }

    public static synchronized JiraUpdater getInstance() {
        if (instance == null) {
            instance = new JiraUpdater();
        }
        return instance;
    }

    public BugtrackingConnector getConnector() {
        if (this.connector == null) {
            this.connector = new JiraProxyConector();
        }
        return this.connector;
    }

    public void downloadAndInstall() {
        DownloadPlugin dp = new DownloadPlugin();
        dp.startDownload();
    }

    public static boolean notifyJiraDownload(String url) {
        final JButton download = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Download"));
        JButton cancel = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Cancel"));
        URL openURL = null;
        if (url != null) {
            try {
                openURL = new URL(url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        JPanel panel = JiraUpdater.createNotificationPanel(openURL);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(JiraUpdater.class, (String)"CTL_MissingJiraPlugin"), true, new Object[]{download, cancel}, (Object)download, 0, new HelpCtx(JiraUpdater.class), null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                download.requestFocusInWindow();
            }
        });
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == download;
    }

    private static JPanel createNotificationPanel(final URL url) {
        JPanel panel = new JPanel();
        JLabel msgLabel = new JLabel("<html>" + NbBundle.getMessage(JiraUpdater.class, (String)"MSG_PROJECT_NEEDS_JIRA"));
        LinkButton linkButton = new LinkButton();
        Mnemonics.setLocalizedText((AbstractButton)linkButton, (String)NbBundle.getMessage(JiraUpdater.class, (String)"MSG_PROJECT_NEEDS_JIRA_LINK"));
        if (url != null) {
            linkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                    if (displayer != null) {
                        displayer.showURL(url);
                    } else {
                        BugtrackingManager.LOG.warning("No URLDisplayer found.");
                    }
                }
            });
        } else {
            linkButton.setVisible(false);
        }
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(msgLabel, -2, 470, Short.MAX_VALUE).addComponent(linkButton)).addContainerGap());
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addComponent(msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(linkButton).addContainerGap(25, Short.MAX_VALUE));
        return panel;
    }

    private class JiraProxyController
    extends BugtrackingController {
        private JPanel panel;

        private JiraProxyController() {
        }

        @Override
        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = this.createControllerPanel();
            }
            return this.panel;
        }

        @Override
        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void applyChanges() throws IOException {
        }

        private JPanel createControllerPanel() {
            JPanel panel = new JPanel();
            JLabel pane = new JLabel();
            pane.setText(NbBundle.getMessage(JiraUpdater.class, (String)"MSG_NOT_YET_INSTALLED"));
            JButton downloadButton = new JButton();
            downloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JiraUpdater.this.downloadAndInstall();
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)downloadButton, (String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MissingJiraSupportPanel.downloadButton.text"));
            GroupLayout layout = new GroupLayout(panel);
            panel.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(pane, -2, 100, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(downloadButton)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(pane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(downloadButton)).addContainerGap()));
            return panel;
        }
    }

    private class JiraProxyRepository
    extends Repository {
        private JiraProxyRepository() {
        }

        @Override
        public Image getIcon() {
            return null;
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getTooltip() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Issue getIssue(String id) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void remove() {
        }

        @Override
        public BugtrackingController getController() {
            return new JiraProxyController();
        }

        @Override
        public Query createQuery() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Issue createIssue() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Query[] getQueries() {
            return new Query[0];
        }

        @Override
        public Collection<RepositoryUser> getUsers() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Issue[] simpleSearch(String criteria) {
            return new Issue[0];
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }

    private class JiraProxyConector
    extends BugtrackingConnector {
        private JiraProxyConector() {
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(JiraUpdater.class, (String)"LBL_FakeJiraName");
        }

        @Override
        public String getTooltip() {
            return NbBundle.getMessage(JiraUpdater.class, (String)"LBL_FakeJiraNameTooltip");
        }

        @Override
        public Repository createRepository() {
            return new JiraProxyRepository();
        }

        @Override
        public Repository[] getRepositories() {
            return new Repository[0];
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Image getIcon() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

