/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embeddable;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.openide.filesystems.FileObject;

public class ModelUtils {
    public static Entity getEntity(EntityMappingsMetadata entityMappingsMetadata, TypeElement typeElement) {
        assert (entityMappingsMetadata != null) : "Metadata is null";
        assert (typeElement != null) : "TypeElement is null";
        Name name = typeElement.getQualifiedName();
        for (Entity entity : entityMappingsMetadata.getRoot().getEntity()) {
            if (!name.contentEquals(entity.getClass2())) continue;
            return entity;
        }
        return null;
    }

    public static Entity getEntity(EntityMappingsMetadata entityMappingsMetadata, String string) {
        for (Entity entity : entityMappingsMetadata.getRoot().getEntity()) {
            if (!string.equals(entity.getClass2())) continue;
            return entity;
        }
        return null;
    }

    public static Embeddable getEmbeddable(EntityMappingsMetadata entityMappingsMetadata, TypeElement typeElement) {
        for (Embeddable embeddable : entityMappingsMetadata.getRoot().getEmbeddable()) {
            if (!typeElement.getQualifiedName().contentEquals(embeddable.getClass2())) continue;
            return embeddable;
        }
        return null;
    }

    public static MappedSuperclass getMappedSuperclass(EntityMappingsMetadata entityMappingsMetadata, TypeElement typeElement) {
        for (MappedSuperclass mappedSuperclass : entityMappingsMetadata.getRoot().getMappedSuperclass()) {
            if (!typeElement.getQualifiedName().contentEquals(mappedSuperclass.getClass2())) continue;
            return mappedSuperclass;
        }
        return null;
    }

    public static TypeElement getTypeElementFromModel(CompilationInfo compilationInfo, Object object) {
        String string = null;
        if (object instanceof Entity) {
            string = ((Entity)object).getClass2();
        }
        if (string != null) {
            return compilationInfo.getElements().getTypeElement(string);
        }
        return null;
    }

    public static void resolveJavaElementFromModel(JPAProblemContext jPAProblemContext, AttributeWrapper attributeWrapper) {
        String string = attributeWrapper.getName();
        attributeWrapper.setInstanceVariable(ModelUtils.getField(jPAProblemContext.getJavaClass(), string));
        attributeWrapper.setAccesor(ModelUtils.getAccesor(jPAProblemContext.getJavaClass(), string));
        if (attributeWrapper.getInstanceVariable() != null) {
            attributeWrapper.setMutator(ModelUtils.getMutator(jPAProblemContext.getCompilationInfo(), jPAProblemContext.getJavaClass(), attributeWrapper.getInstanceVariable()));
        }
        if (jPAProblemContext.getAccessType() == AccessType.FIELD) {
            attributeWrapper.setJavaElement(attributeWrapper.getInstanceVariable());
        } else if (jPAProblemContext.getAccessType() == AccessType.PROPERTY) {
            attributeWrapper.setJavaElement(attributeWrapper.getAccesor());
        }
    }

    public static ExecutableElement getAccesor(TypeElement typeElement, String string) {
        for (ExecutableElement executableElement : ModelUtils.getMethod(typeElement, ModelUtils.getAccesorName(string))) {
            if (executableElement.getParameters().size() != 0) continue;
            return executableElement;
        }
        for (ExecutableElement executableElement : ModelUtils.getMethod(typeElement, ModelUtils.getBooleanAccesorName(string))) {
            if (executableElement.getParameters().size() != 0) continue;
            return executableElement;
        }
        return null;
    }

    public static ExecutableElement getMutator(CompilationInfo compilationInfo, TypeElement typeElement, VariableElement variableElement) {
        ExecutableElement[] executableElementArray;
        for (ExecutableElement executableElement : executableElementArray = ModelUtils.getMethod(typeElement, ModelUtils.getMutatorName(variableElement.getSimpleName().toString()))) {
            if (executableElement.getParameters().size() != 1) continue;
            TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
            if (!compilationInfo.getTypes().isSameType(typeMirror, variableElement.asType())) continue;
            return executableElement;
        }
        return null;
    }

    public static ExecutableElement[] getMethod(TypeElement typeElement, String string) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!executableElement.getSimpleName().contentEquals(string)) continue;
            arrayList.add(executableElement);
        }
        return arrayList.toArray(new ExecutableElement[arrayList.size()]);
    }

    public static String getAccesorName(String string) {
        return "get" + Character.toString(string.charAt(0)).toUpperCase() + string.substring(1);
    }

    public static String getBooleanAccesorName(String string) {
        return "is" + Character.toString(string.charAt(0)).toUpperCase() + string.substring(1);
    }

    public static String getMutatorName(String string) {
        return "set" + Character.toString(string.charAt(0)).toUpperCase() + string.substring(1);
    }

    public static String getFieldNameFromAccessor(String string) {
        if (!string.startsWith("get")) {
            throw new IllegalArgumentException("accessor name must start with 'get'");
        }
        return String.valueOf(string.charAt(3)).toLowerCase() + string.substring(4);
    }

    public static VariableElement getField(TypeElement typeElement, String string) {
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!variableElement.getSimpleName().contentEquals(string)) continue;
            return variableElement;
        }
        return null;
    }

    public static MetadataModel<EntityMappingsMetadata> getModel(FileObject fileObject) {
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)fileObject);
        if (entityClassScope != null) {
            return entityClassScope.getEntityMappingsModel(false);
        }
        return null;
    }

    public static Collection<String> extractAnnotationNames(Element element) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            Element element2 = declaredType.asElement();
            String string = ((TypeElement)element2).getQualifiedName().toString();
            linkedList.add(string);
        }
        return linkedList;
    }

    public static String shortAnnotationName(String string) {
        return "@" + string.substring(string.lastIndexOf(".") + 1);
    }
}

