/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.debugger.jpda.heapwalk.JavaClassImpl;

public class HeapImpl
implements Heap {
    private JPDADebugger debugger;

    public HeapImpl(JPDADebugger jPDADebugger) {
        this.debugger = jPDADebugger;
    }

    public JPDADebugger getDebugger() {
        return this.debugger;
    }

    public HeapSummary getSummary() {
        return new DebuggerHeapSummary(this.debugger);
    }

    public List<JavaClass> getAllClasses() {
        List list = this.debugger.getAllClasses();
        long[] lArray = this.debugger.getInstanceCounts(list);
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>(list.size());
        int n = 0;
        for (JPDAClassType jPDAClassType : list) {
            arrayList.add(new JavaClassImpl(this, jPDAClassType, lArray[n++]));
        }
        return arrayList;
    }

    public List getBiggestObjectsByRetainedSize(int n) {
        return null;
    }

    public Instance getInstanceByID(long l) {
        return null;
    }

    public JavaClass getJavaClassByID(long l) {
        return null;
    }

    public JavaClass getJavaClassByName(String string) {
        List list = this.debugger.getClassesByName(string);
        if (list.size() == 0) {
            return null;
        }
        return new JavaClassImpl(this, (JPDAClassType)list.get(0), ((JPDAClassType)list.get(0)).getInstanceCount());
    }

    public Collection getJavaClassesByRegExp(String string) {
        List list = this.debugger.getAllClasses();
        ArrayList<JavaClassImpl> arrayList = new ArrayList<JavaClassImpl>(256);
        Pattern pattern = Pattern.compile(string);
        for (JPDAClassType jPDAClassType : list) {
            if (!pattern.matcher(jPDAClassType.getName()).matches()) continue;
            arrayList.add(new JavaClassImpl(this, jPDAClassType, jPDAClassType.getInstanceCount()));
        }
        return arrayList;
    }

    public Collection getGCRoots() {
        return Collections.emptyList();
    }

    public GCRoot getGCRoot(Instance instance) {
        return null;
    }

    public Properties getSystemProperties() {
        return null;
    }

    private static final class DebuggerHeapSummary
    implements HeapSummary {
        private JPDADebugger debugger;

        public DebuggerHeapSummary(JPDADebugger jPDADebugger) {
            this.debugger = jPDADebugger;
        }

        public long getTotalLiveBytes() {
            return -1L;
        }

        public long getTotalLiveInstances() {
            long[] lArray = this.debugger.getInstanceCounts(this.debugger.getAllClasses());
            long l = 0L;
            for (long l2 : lArray) {
                l += l2;
            }
            return l;
        }

        public long getTotalAllocatedBytes() {
            return -1L;
        }

        public long getTotalAllocatedInstances() {
            return -1L;
        }

        public long getTime() {
            return System.currentTimeMillis();
        }
    }
}

