/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.DbURLClassLoader;
import org.netbeans.modules.derby.DerbyActivator;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.DerbyServerNode;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbPreferences;

public final class DerbyDatabasesImpl {
    private static final DerbyDatabasesImpl INSTANCE = new DerbyDatabasesImpl();
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();
    private static final String PATH_TO_DATABASE_PREFERENCES = "/org/netbeans/modules/derby/databases/";
    private static final String USER_KEY = "user";
    private static final String SCHEMA_KEY = "schema";
    private static final String PASSWORD_KEY = "password";

    private DerbyDatabasesImpl() {
    }

    public static DerbyDatabasesImpl getDefault() {
        DerbyActivator.activate();
        return INSTANCE;
    }

    public boolean isDerbyRegistered() {
        return DerbySupport.getLocation().length() > 0 && DerbySupport.getSystemHome().length() > 0;
    }

    public File getSystemHome() {
        String systemHome = DerbyOptions.getDefault().getSystemHome();
        if (systemHome.length() >= 0) {
            return new File(systemHome);
        }
        return null;
    }

    public boolean databaseExists(String databaseName) {
        if (databaseName == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        if ("".equals(databaseName)) {
            return false;
        }
        String systemHome = DerbySupport.getSystemHome();
        if (systemHome.length() <= 0) {
            return false;
        }
        File databaseFile = new File(systemHome, databaseName);
        return databaseFile.exists();
    }

    public String getFirstFreeDatabaseName(String baseDatabaseName) {
        if (baseDatabaseName == null) {
            throw new NullPointerException("The baseDatabaseName parameter cannot be null");
        }
        String systemHome = DerbySupport.getSystemHome();
        if (systemHome.length() <= 0) {
            return baseDatabaseName;
        }
        File databaseFile = new File(systemHome, baseDatabaseName);
        if (!databaseFile.exists()) {
            return baseDatabaseName;
        }
        for (int i = 1; i <= Integer.MAX_VALUE; ++i) {
            String databaseName = baseDatabaseName + String.valueOf(i);
            databaseFile = new File(systemHome, databaseName);
            if (databaseFile.exists()) continue;
            return databaseName;
        }
        return null;
    }

    public int getFirstIllegalCharacter(String databaseName) {
        if (databaseName == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        for (int i = 0; i < databaseName.length(); ++i) {
            char ch = databaseName.charAt(i);
            if (ch == '/') {
                return ch;
            }
            if (ch != File.separatorChar) continue;
            return ch;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection createDatabase(String databaseName, String user, String password) throws DatabaseException, IOException, IllegalStateException {
        if (databaseName == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        this.ensureSystemHome();
        if (!RegisterDerby.getDefault().ensureStarted(true)) {
            throw new DatabaseException("The Derby server did not start");
        }
        Driver driver = this.loadDerbyNetDriver();
        Properties props = new Properties();
        boolean setupAuthentication = user != null && user.length() >= 0;
        try {
            String url = "jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/" + databaseName;
            String urlForCreation = url + ";create=true";
            Connection connection = driver.connect(urlForCreation, props);
            try {
                if (setupAuthentication) {
                    this.setupDatabaseAuthentication(connection, user, password);
                }
            }
            finally {
                connection.close();
            }
            if (setupAuthentication) {
                try {
                    connection = driver.connect(url + ";shutdown=true", props);
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException sqle) {
            throw new DatabaseException((Throwable)sqle);
        }
        return this.registerDatabase(databaseName, user, setupAuthentication ? user.toUpperCase() : "APP", setupAuthentication ? password : null, setupAuthentication);
    }

    public DatabaseConnection createSampleDatabase() throws DatabaseException, IOException, IllegalStateException {
        this.extractSampleDatabase("sample");
        return this.registerDatabase("sample", "app", "APP", "app", true);
    }

    public DatabaseConnection createSampleDatabase(String databaseName) throws DatabaseException, IOException {
        if (databaseName == null) {
            throw new NullPointerException("The databaseName parameter cannot be null");
        }
        this.extractSampleDatabase(databaseName);
        return this.registerDatabase(databaseName, "app", "APP", "app", true);
    }

    public List<String> getDatabases() {
        String databaseHome = DerbyOptions.getDefault().getSystemHome();
        if (databaseHome == null || databaseHome.length() == 0) {
            Logger.getLogger(DerbyServerNode.class.getName()).fine("No JavaDB location set.");
            return Collections.emptyList();
        }
        File databaseHomeFile = new File(databaseHome);
        if (!databaseHomeFile.exists()) {
            Logger.getLogger(DerbyServerNode.class.getName()).log(Level.WARNING, "No JavaDB location found on " + databaseHomeFile);
            return Collections.emptyList();
        }
        FileObject databaseHomeFO = FileUtil.toFileObject((File)databaseHomeFile);
        Enumeration children = databaseHomeFO.getChildren(false);
        ArrayList<String> res = new ArrayList<String>();
        while (children.hasMoreElements()) {
            FileObject candidate = (FileObject)children.nextElement();
            if (!this.checkDatabase(candidate)) continue;
            Logger.getLogger(DerbyServerNode.class.getName()).fine(candidate.getName() + " added into Databases in " + databaseHome);
            res.add(candidate.getName());
        }
        return res;
    }

    private boolean checkDatabase(FileObject candidate) {
        if (candidate.isFolder()) {
            FileObject sp = candidate.getFileObject("service.properties");
            return sp != null && FileUtil.toFile((FileObject)sp) != null;
        }
        return false;
    }

    public boolean dropDatabase(String dbname) {
        if (dbname == null) {
            throw new IllegalArgumentException("The databaseName parameter cannot be null");
        }
        if (dbname.length() == 0) {
            throw new IllegalArgumentException("The databaseName parameter cannot be empty");
        }
        String systemHome = DerbyOptions.getDefault().getSystemHome();
        assert (systemHome.length() > 0) : "JavaDB SystemHome must be valid, but was " + systemHome;
        if (systemHome.length() <= 0) {
            return false;
        }
        for (DatabaseConnection conn : this.findDatabaseConnections(dbname)) {
            try {
                ConnectionManager.getDefault().removeConnection(conn);
            }
            catch (DatabaseException ex) {
                Logger.getLogger(DerbyServerNode.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        File databaseFile = new File(systemHome, dbname);
        FileObject fo = FileUtil.toFileObject((File)databaseFile);
        try {
            fo.delete();
        }
        catch (IOException ex) {
            Logger.getLogger(DerbyServerNode.class.getName()).log(Level.WARNING, ex.getLocalizedMessage());
            return false;
        }
        this.notifyChange();
        return true;
    }

    public synchronized void extractSampleDatabase(String databaseName) throws IOException {
        File systemHomeFile = this.ensureSystemHome();
        File sourceFO = InstalledFileLocator.getDefault().locate("modules/ext/derbysampledb.zip", null, false);
        FileObject systemHomeFO = FileUtil.toFileObject((File)systemHomeFile);
        FileObject sampleFO = systemHomeFO.getFileObject(databaseName);
        if (sampleFO == null) {
            sampleFO = systemHomeFO.createFolder(databaseName);
            Util.extractZip(sourceFO, sampleFO);
        }
    }

    private File ensureSystemHome() throws IOException {
        File systemHomeFile;
        String systemHome = DerbySupport.getSystemHome();
        boolean noSystemHome = false;
        if (systemHome.length() <= 0) {
            noSystemHome = true;
            systemHome = DerbySupport.getDefaultSystemHome();
        }
        if (!((systemHomeFile = new File(systemHome)).exists() || systemHomeFile.mkdirs() || systemHomeFile.exists())) {
            throw new IOException("Could not create the derby.system.home directory " + systemHomeFile);
        }
        if (noSystemHome) {
            DerbySupport.setSystemHome(systemHome);
        }
        return systemHomeFile;
    }

    private synchronized DatabaseConnection registerDatabase(String databaseName, String user, String schema, String password, boolean rememberPassword) throws DatabaseException {
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers("org.apache.derby.jdbc.ClientDriver");
        if (drivers.length == 0) {
            throw new IllegalStateException("The Java DB (Network) driver was not found");
        }
        Preferences pref = NbPreferences.root().node(PATH_TO_DATABASE_PREFERENCES + databaseName);
        pref.put(USER_KEY, user);
        pref.put(SCHEMA_KEY, schema);
        pref.put(PASSWORD_KEY, password);
        DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)drivers[0], (String)("jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/" + databaseName), (String)user, (String)schema, (String)password, (boolean)rememberPassword);
        if (ConnectionManager.getDefault().getConnection(dbconn.getName()) == null) {
            ConnectionManager.getDefault().addConnection(dbconn);
        }
        this.notifyChange();
        return dbconn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDatabaseAuthentication(Connection conn, String user, String password) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("{call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)}");
        try {
            stmt.setString(1, "derby.connection.requireAuthentication");
            stmt.setString(2, "true");
            stmt.execute();
            stmt.clearParameters();
            stmt.setString(1, "derby.authentication.provider");
            stmt.setString(2, "BUILTIN");
            stmt.execute();
            stmt.clearParameters();
            stmt.setString(1, "derby.user." + user);
            stmt.setString(2, password);
            stmt.execute();
        }
        finally {
            stmt.close();
        }
    }

    private Driver loadDerbyNetDriver() throws DatabaseException, IllegalStateException {
        Exception exception = null;
        try {
            File derbyClient = Util.getDerbyFile("lib/derbyclient.jar");
            if (derbyClient == null || !derbyClient.exists()) {
                throw new IllegalStateException("The Java DB (Network) driver was not found");
            }
            URL[] driverURLs = new URL[]{derbyClient.toURI().toURL()};
            DbURLClassLoader l = new DbURLClassLoader(driverURLs);
            Class<?> c = Class.forName("org.apache.derby.jdbc.ClientDriver", true, l);
            return (Driver)c.newInstance();
        }
        catch (MalformedURLException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (InstantiationException e) {
            exception = e;
        }
        if (exception != null) {
            throw new DatabaseException((Throwable)exception);
        }
        return null;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    void notifyChange() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(evt);
        }
    }

    List<DatabaseConnection> findDatabaseConnections(String databaseName) {
        DatabaseConnection[] connections;
        String url = "jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/" + databaseName;
        ArrayList<DatabaseConnection> result = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection conn : connections = ConnectionManager.getDefault().getConnections()) {
            if (!conn.getDriverClass().equals("org.apache.derby.jdbc.ClientDriver") || !conn.getDatabaseURL().equals(url)) continue;
            result.add(conn);
        }
        return result;
    }

    String getUser(String databaseName) {
        Preferences pref = NbPreferences.root().node(PATH_TO_DATABASE_PREFERENCES + databaseName);
        return pref.get(USER_KEY, "");
    }

    String getSchema(String databaseName) {
        Preferences pref = NbPreferences.root().node(PATH_TO_DATABASE_PREFERENCES + databaseName);
        return pref.get(SCHEMA_KEY, "");
    }

    String getPassword(String databaseName) {
        Preferences pref = NbPreferences.root().node(PATH_TO_DATABASE_PREFERENCES + databaseName);
        return pref.get(PASSWORD_KEY, "");
    }
}

