/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.ui.DerbyPropertiesPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class Util {
    private static final String DERBY_CLIENT = "derbyclient.jar";

    private Util() {
    }

    public static boolean hasInstallLocation() {
        return Util.getCheckedLocation() != null;
    }

    public static boolean checkInstallLocation() {
        if (!Util.hasInstallLocation()) {
            Util.showInformation(NbBundle.getMessage(Util.class, (String)"MSG_DerbyLocationIncorrect"));
            return false;
        }
        return true;
    }

    private static File getCheckedLocation() {
        File location = new File(DerbyOptions.getDefault().getLocation());
        if (location.isAbsolute() && location.isDirectory() && location.exists()) {
            return location;
        }
        return null;
    }

    public static File getDerbyFile(String relPath) {
        File location = Util.getCheckedLocation();
        if (location != null) {
            return new File(location, relPath);
        }
        return null;
    }

    public static boolean ensureSystemHome() {
        if (DerbyOptions.getDefault().getSystemHome().length() <= 0) {
            return (Boolean)Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    return DerbyPropertiesPanel.showDerbyProperties();
                }
            });
        }
        return true;
    }

    public static void showInformation(final String msg) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public static boolean isDerbyInstallLocation(File location) {
        if (location == null || !location.exists()) {
            return false;
        }
        File libDir = new File(location, "lib");
        if (!libDir.exists()) {
            return false;
        }
        File[] libs = libDir.listFiles();
        if (libs == null || libs.length <= 0) {
            return false;
        }
        for (File lib : libs) {
            if (!lib.getName().equals(DERBY_CLIENT)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(File source, FileObject target) throws IOException {
        FileInputStream is = new FileInputStream(source);
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(is);
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (ze.isDirectory()) {
                    FileUtil.createFolder((FileObject)target, (String)name);
                    continue;
                }
                FileObject fd = FileUtil.createData((FileObject)target, (String)name);
                FileLock lock = fd.lock();
                try {
                    OutputStream os = fd.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)zis, (OutputStream)os);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            is.close();
        }
    }
}

