/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PersistenceLocationProviderImpl
implements PersistenceLocationProvider,
PropertyChangeListener {
    static final String DEF_LOCATION = "src/main/resources/META-INF";
    static final String DEF_PERSISTENCE = "src/main/resources/META-INF/persistence.xml";
    static final String ALT_PERSISTENCE = "src/main/java/META-INF/persistence.xml";
    private Project project = null;
    private FileObject location = null;
    private File projectDir = null;
    private File persistenceXml = null;

    public PersistenceLocationProviderImpl(Project project) {
        this.project = project;
        this.projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        this.persistenceXml = this.findPersistenceXml();
        this.location = FileUtil.toFileObject((File)this.persistenceXml.getParentFile());
    }

    public FileObject getLocation() {
        return this.location;
    }

    public FileObject createLocation() throws IOException {
        FileObject fileObject = null;
        File file = FileUtilities.resolveFilePath((File)this.projectDir, (String)DEF_LOCATION);
        if (!file.exists()) {
            fileObject = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)DEF_LOCATION);
        }
        this.location = fileObject = FileUtil.toFileObject((File)file);
        return fileObject;
    }

    protected File getPersistenceXml() {
        return this.persistenceXml;
    }

    private File findPersistenceXml() {
        File file;
        File file2 = null;
        File file3 = FileUtilities.resolveFilePath((File)this.projectDir, (String)DEF_PERSISTENCE);
        file2 = file3.exists() ? file3 : ((file = FileUtilities.resolveFilePath((File)this.projectDir, (String)ALT_PERSISTENCE)).exists() ? file : file3);
        return file2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MavenPersistence".equals(propertyChangeEvent.getPropertyName())) {
            this.persistenceXml = this.findPersistenceXml();
            this.location = FileUtil.toFileObject((File)this.persistenceXml.getParentFile());
        }
    }
}

