/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;

public class AuthorizationRequiredException
extends RuntimeException {
    private String _params;
    private String _scheme;
    private Properties _properties;

    AuthorizationRequiredException(String wwwAuthenticateHeader) {
        int index = wwwAuthenticateHeader.indexOf(32);
        if (index < 0) {
            this._scheme = "Basic";
            this._params = wwwAuthenticateHeader;
        } else {
            this._scheme = wwwAuthenticateHeader.substring(0, index);
            this._params = wwwAuthenticateHeader.substring(index + 1);
        }
        this.loadProperties();
    }

    private void loadProperties() {
        try {
            this._properties = new Properties();
            this._properties.load(new ByteArrayInputStream(this._params.getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected AuthorizationRequiredException(String scheme, String params) {
        this._scheme = scheme;
        this._params = params;
        this.loadProperties();
    }

    public String getMessage() {
        return this._scheme + " authentication required: " + this._params;
    }

    public String getAuthenticationScheme() {
        return this._scheme;
    }

    public String getAuthenticationParameter(String parameterName) {
        return this._properties.getProperty(parameterName);
    }
}

