/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.Box;

public class Tile {
    public int x;
    public int maxX;
    public int y;
    public int maxY;

    public Tile() {
    }

    public Tile(Tile t) {
        this();
        this.setTile(t);
    }

    public Tile(int x, int y, int width, int height) {
        this.setTile(x, y, width, height);
    }

    public void setTile(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.maxX = x + width - 1;
        this.maxY = y + height - 1;
    }

    public void setTile(Tile t) {
        this.x = t.x;
        this.y = t.y;
        this.maxX = t.maxX;
        this.maxY = t.maxY;
    }

    public void setEmptyTile() {
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
    }

    public void addTile(Tile t) {
        this.addTile(t.x, t.y, t.maxX, t.maxY);
    }

    public void addTile(int tx, int ty, int tmaxX, int tmaxY) {
        if (tx < this.x) {
            this.x = tx;
        }
        if (ty < this.y) {
            this.y = ty;
        }
        if (tmaxX > this.maxX) {
            this.maxX = tmaxX;
        }
        if (tmaxY > this.maxY) {
            this.maxY = tmaxY;
        }
    }

    public void addSnapBox(Box b) {
        b.snap();
        this.addTile((int)b.x, (int)b.y, (int)(b.x + b.width - 1.0f), (int)(b.y + b.height - 1.0f));
    }

    public void snapBox(Box b) {
        if (b == null) {
            this.x = Integer.MIN_VALUE;
            this.y = Integer.MIN_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.maxY = Integer.MIN_VALUE;
        } else {
            b.snap();
            this.x = (int)b.x;
            this.y = (int)b.y;
            this.maxX = (int)(b.x + b.width - 1.0f);
            this.maxY = (int)(b.y + b.height - 1.0f);
        }
    }

    public boolean isHit(Tile t) {
        return t.maxX >= this.x && t.maxY >= this.y && t.x <= this.maxX && t.y <= this.maxY;
    }

    public String toString() {
        return "minX = " + this.x + " minY = " + this.y + " maxX = " + this.maxX + " maxY = " + this.maxY;
    }
}

