/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.PathSupport;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractRenderingNode;
import com.sun.perseus.model.AbstractRenderingNodeProxy;
import com.sun.perseus.model.AbstractShapeNodeProxy;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNodeProxy;

public abstract class AbstractShapeNode
extends AbstractRenderingNode {
    public AbstractShapeNode(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    ElementNodeProxy buildProxy() {
        return new AbstractShapeNodeProxy(this);
    }

    public abstract void fillShape(RenderGraphics var1);

    public abstract void drawShape(RenderGraphics var1);

    public abstract boolean contains(float var1, float var2, int var3);

    public final boolean strokedContains(float x, float y, GraphicsProperties gp) {
        Object strokedPath = this.getStrokedPath(this);
        return PathSupport.isStrokedPathHit(strokedPath, gp.getFillRule(), x, y);
    }

    abstract Object getStrokedPath(GraphicsProperties var1);

    protected void paintRendered(RenderGraphics rg, GraphicsProperties gp, PaintTarget pt, Transform tx) {
        if (!gp.getVisibility()) {
            return;
        }
        rg.setPaintTarget(pt);
        rg.setPaintTransform(tx);
        rg.setTransform(tx);
        if (gp.getFill() != null) {
            rg.setFillRule(gp.getFillRule());
            rg.setFill(gp.getFill());
            rg.setFillOpacity(gp.getFillOpacity());
            this.fillShape(rg);
        }
        if (gp.getStroke() != null) {
            rg.setStroke(gp.getStroke());
            rg.setStrokeOpacity(gp.getStrokeOpacity());
            rg.setStrokeWidth(gp.getStrokeWidth());
            rg.setStrokeLineCap(gp.getStrokeLineCap());
            rg.setStrokeLineJoin(gp.getStrokeLineJoin());
            rg.setStrokeDashArray(gp.getStrokeDashArray());
            rg.setStrokeMiterLimit(gp.getStrokeMiterLimit());
            rg.setStrokeDashOffset(gp.getStrokeDashOffset());
            this.drawShape(rg);
        }
    }

    protected boolean isHitVP(float[] pt) {
        if (!this.getVisibility() || this.fill == null && this.stroke == null) {
            return false;
        }
        this.getInverseTransformState().transformPoint(pt, this.ownerDocument.upt);
        pt = this.ownerDocument.upt;
        if (this.fill != null && this.contains(pt[0], pt[1], this.getFillRule())) {
            return true;
        }
        return this.stroke != null && this.strokedContains(pt[0], pt[1], this);
    }

    protected boolean isProxyHitVP(float[] pt, AbstractRenderingNodeProxy proxy) {
        if (!proxy.getVisibility() || proxy.fill == null && proxy.stroke == null) {
            return false;
        }
        proxy.getInverseTransformState().transformPoint(pt, this.ownerDocument.upt);
        pt = this.ownerDocument.upt;
        if (proxy.fill != null && this.contains(pt[0], pt[1], proxy.getFillRule())) {
            return true;
        }
        return ((AbstractShapeNodeProxy)proxy).stroke != null && this.strokedContains(pt[0], pt[1], proxy);
    }

    void setComputedFill(PaintServer newFill) {
        this.fill = newFill;
    }

    void setComputedStroke(PaintServer newStroke) {
        this.stroke = newStroke;
    }

    void setComputedStrokeWidth(float newStrokeWidth) {
        this.strokeWidth = newStrokeWidth;
    }

    void setComputedStrokeLineJoin(int newStrokeLineJoin) {
        super.setComputedStrokeLineJoin(newStrokeLineJoin);
    }

    void setComputedStrokeLineCap(int newStrokeLineCap) {
        super.setComputedStrokeLineCap(newStrokeLineCap);
    }

    void setComputedStrokeMiterLimit(float newStrokeMiterLimit) {
        this.strokeMiterLimit = newStrokeMiterLimit;
    }

    void setComputedStrokeDashArray(float[] newStrokeDashArray) {
        this.strokeDashArray = newStrokeDashArray;
    }

    void setComputedStrokeDashOffset(float newStrokeDashOffset) {
        this.strokeDashOffset = newStrokeDashOffset;
    }

    void setComputedFillOpacity(float newFillOpacity) {
        super.setComputedFillOpacity(newFillOpacity);
    }

    void setComputedStrokeOpacity(float newStrokeOpacity) {
        super.setComputedStrokeOpacity(newStrokeOpacity);
    }
}

