/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Anchor;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.ModelNode;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.events.EventListener;

class EventSupport {
    public static final int CAPTURE_PHASE = 0;
    public static final int BUBBLE_PHASE = 1;
    protected Hashtable allListeners = new Hashtable();
    protected EventListener[] freezeList;

    EventSupport() {
    }

    EventListener[] getFreezeList(int n) {
        if (this.freezeList == null || this.freezeList.length < n) {
            this.freezeList = new EventListener[n];
        }
        return this.freezeList;
    }

    void removeEventListener(ModelNode handler, String type, int phase, EventListener listener) {
        Hashtable nodeListeners;
        if (handler == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (phase != 1 && phase != 0) {
            throw new IllegalArgumentException();
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        if (handler instanceof ElementNodeProxy) {
            handler = ((ElementNodeProxy)handler).proxied;
        }
        if ((nodeListeners = (Hashtable)this.allListeners.get(handler)) == null) {
            return;
        }
        Vector[] evtTypeListeners = (Vector[])nodeListeners.get(type);
        if (evtTypeListeners == null) {
            return;
        }
        Vector phaseListeners = evtTypeListeners[phase];
        if (phaseListeners != null) {
            phaseListeners.removeElement(listener);
        }
    }

    void addEventListener(ModelNode handler, String type, int phase, EventListener listener) {
        Vector<EventListener> phaseListeners;
        Vector[] evtTypeListeners;
        Hashtable<String, Vector[]> nodeListeners;
        if (handler == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (phase != 0 && phase != 1) {
            throw new IllegalArgumentException();
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        if (handler instanceof ElementNodeProxy) {
            handler = ((ElementNodeProxy)handler).proxied;
        }
        if ((nodeListeners = (Hashtable<String, Vector[]>)this.allListeners.get(handler)) == null) {
            nodeListeners = new Hashtable<String, Vector[]>();
            this.allListeners.put(handler, nodeListeners);
        }
        if ((evtTypeListeners = (Vector[])nodeListeners.get(type)) == null) {
            evtTypeListeners = new Vector[2];
            nodeListeners.put(type, evtTypeListeners);
        }
        if ((phaseListeners = evtTypeListeners[phase]) == null) {
            evtTypeListeners[phase] = phaseListeners = new Vector<EventListener>(1);
        }
        if (!phaseListeners.contains(listener)) {
            phaseListeners.addElement(listener);
        }
    }

    public void dispatchEvent(ModelEvent evt) {
        if (evt == null) {
            return;
        }
        String type = evt.getType();
        ModelNode target = (ModelNode)evt.getTarget();
        if (target.parent != null) {
            this.fireCapture(target.parent, evt);
        }
        if (!evt.getStopPropagation()) {
            this.fireEventListeners(target, evt, 0);
            this.fireEventListeners(target, evt, 1);
        }
        if (target.parent != null) {
            this.fireBubble(target.parent, evt);
        }
    }

    protected void fireBubble(ModelNode currentTarget, ModelEvent evt) {
        if (evt.getStopPropagation()) {
            return;
        }
        this.fireEventListeners(currentTarget, evt, 1);
        if (currentTarget.parent != null) {
            this.fireBubble(currentTarget.parent, evt);
        }
    }

    protected void fireCapture(ModelNode currentTarget, ModelEvent evt) {
        if (currentTarget.parent != null) {
            this.fireCapture(currentTarget.parent, evt);
        }
        if (!evt.getStopPropagation()) {
            this.fireEventListeners(currentTarget, evt, 0);
        }
    }

    protected void fireEventListeners(ModelNode currentTarget, ModelEvent evt, int phase) {
        Vector listeners;
        if (evt.getAnchor() == null && currentTarget instanceof Anchor) {
            evt.setAnchor((Anchor)currentTarget);
        }
        if ((listeners = this.getEventListeners(currentTarget, phase, evt)) == null) {
            return;
        }
        int n = listeners.size();
        Object[] freezeList = this.getFreezeList(n);
        listeners.copyInto(freezeList);
        evt.currentTarget = currentTarget;
        for (int i = 0; i < n; ++i) {
            if (!listeners.contains(freezeList[i])) continue;
            freezeList[i].handleEvent(evt);
        }
    }

    protected Vector getEventListeners(ModelNode node, int phase, ModelEvent evt) {
        Hashtable nodeListeners;
        if (node instanceof ElementNodeProxy) {
            node = ((ElementNodeProxy)node).proxied;
        }
        if ((nodeListeners = (Hashtable)this.allListeners.get(node)) == null) {
            return null;
        }
        Vector[] evtTypeListeners = (Vector[])nodeListeners.get(evt.getType());
        if (evtTypeListeners == null) {
            return null;
        }
        return evtTypeListeners[phase];
    }
}

