/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.IDRef;
import com.sun.perseus.model.IntervalTimeInstance;
import com.sun.perseus.model.TimeCondition;
import com.sun.perseus.model.TimeDependent;
import com.sun.perseus.model.TimedElementNode;
import com.sun.perseus.model.TimedElementSupport;
import java.util.Vector;

public final class SyncBaseCondition
extends TimeCondition
implements TimeDependent,
IDRef {
    String syncBaseId;
    TimedElementSupport syncBase;
    boolean isBeginSync;
    long offset;

    public SyncBaseCondition(TimedElementNode timedElementNode, boolean isBegin, String syncBaseId, boolean isBeginSync, long offset) {
        super(timedElementNode.timedElementSupport, isBegin);
        if (syncBaseId == null) {
            throw new NullPointerException();
        }
        this.syncBaseId = syncBaseId;
        this.isBeginSync = isBeginSync;
        this.offset = offset;
        timedElementNode.ownerDocument.resolveIDRef(this, syncBaseId);
    }

    public void resolveTo(ElementNode ref) {
        if (!(ref instanceof TimedElementNode)) {
            return;
        }
        this.syncBase = ((TimedElementNode)ref).timedElementSupport;
        if (this.isBeginSync) {
            if (this.syncBase.beginDependents == null) {
                this.syncBase.beginDependents = new Vector(1);
            }
            this.syncBase.beginDependents.addElement(this);
        } else {
            if (this.syncBase.endDependents == null) {
                this.syncBase.endDependents = new Vector(1);
            }
            this.syncBase.endDependents.addElement(this);
        }
    }

    public String getIdRef() {
        return this.syncBaseId;
    }

    public void onNewInterval(TimedElementSupport syncBase) {
        new IntervalTimeInstance(this.timedElement, syncBase, this.offset, false, this.isBegin, this.isBeginSync);
    }

    protected String toStringTrait() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.syncBaseId);
        sb.append('.');
        if (this.isBeginSync) {
            sb.append("begin");
        } else {
            sb.append("end");
        }
        if (this.offset != 0L) {
            if (this.offset > 0L) {
                sb.append('+');
            }
            sb.append((float)this.offset / 1000.0f);
            sb.append('s');
        }
        return sb.toString();
    }
}

