/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.TraitAnimationNode;
import com.sun.perseus.model.TransformRefValues;
import com.sun.perseus.model.TransformSegment;
import com.sun.perseus.platform.MathSupport;
import org.w3c.dom.DOMException;

class TransformTraitAnim
extends FloatTraitAnim {
    public TransformTraitAnim(ElementNode targetElement, String traitName) {
        super(targetElement, traitName, "SVGMatrix");
    }

    RefValues toRefValues(TraitAnimationNode anim, String[] values, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (anim.type == 1) {
            return super.toRefValues(anim, values, reqTraitNamespace, reqTraitName);
        }
        TransformRefValues refValues = new TransformRefValues();
        if (values.length < 1) {
            throw new IllegalArgumentException();
        }
        if (values.length == 1) {
            String[] tmpValues = new String[]{values[0], values[0]};
            values = tmpValues;
        }
        int nSegments = values.length - 1;
        TransformSegment[] segments = new TransformSegment[nSegments];
        segments[0] = new TransformSegment();
        segments[0].start = this.validateValue(anim, reqTraitNamespace, reqTraitName, values[0]);
        segments[0].end = this.validateValue(anim, reqTraitNamespace, reqTraitName, values[1]);
        segments[0].type = anim.type;
        TransformSegment prevSegment = segments[0];
        for (int i = 1; i < nSegments; ++i) {
            segments[i] = new TransformSegment();
            segments[i].start = prevSegment.end;
            segments[i].end = this.validateValue(anim, reqTraitNamespace, reqTraitName, values[i + 1]);
            segments[i].type = anim.type;
            prevSegment = segments[i];
        }
        refValues.segments = segments;
        return refValues;
    }

    public float[] validateValue(TraitAnimationNode anim, String traitNamespace, String traitName, String value) {
        float[] v = null;
        switch (anim.type) {
            case 2: {
                v = anim.parseFloatArrayTrait(traitName, value);
                if (v.length < 1 || v.length > 2) {
                    throw anim.illegalTraitValue(traitName, value);
                }
                if (v.length == 1) {
                    float[] tv = new float[]{v[0], 0.0f};
                    v = tv;
                }
                return v;
            }
            case 3: {
                v = anim.parseFloatArrayTrait(traitName, value);
                if (v.length < 1 || v.length > 2) {
                    throw anim.illegalTraitValue(traitName, value);
                }
                if (v.length == 1) {
                    float[] tv = new float[]{v[0], v[0]};
                    v = tv;
                }
                return v;
            }
            case 4: {
                v = anim.parseFloatArrayTrait(traitName, value);
                if (v.length != 1 && v.length != 3) {
                    throw anim.illegalTraitValue(traitName, value);
                }
                if (v.length != 3) {
                    float[] tv = new float[]{v[0], 0.0f, 0.0f};
                    v = tv;
                }
                v[0] = MathSupport.toRadians(v[0]);
                return v;
            }
        }
        v = new float[]{anim.parseFloatTrait(traitName, value)};
        v[0] = MathSupport.toRadians(v[0]);
        return v;
    }

    public Object[] sum(Object[] valueA, Object[] valueB) {
        if (valueA == null) {
            return valueB;
        }
        float[][] fva = (float[][])valueA;
        float[][] fvb = (float[][])valueB;
        float[][] fv = new float[6][1];
        fv[0][0] = fvb[0][0] * fva[0][0] + fvb[1][0] * fva[2][0];
        fv[1][0] = fvb[0][0] * fva[1][0] + fvb[1][0] * fva[3][0];
        fv[2][0] = fvb[2][0] * fva[0][0] + fvb[3][0] * fva[2][0];
        fv[3][0] = fvb[2][0] * fva[1][0] + fvb[3][0] * fva[3][0];
        fv[4][0] = fvb[4][0] * fva[0][0] + fvb[5][0] * fva[2][0] + fva[4][0];
        fv[5][0] = fvb[4][0] * fva[1][0] + fvb[5][0] * fva[3][0] + fva[5][0];
        return fv;
    }

    public Object[] multiply(Object[] value, int iter) {
        for (int i = 1; i < iter; ++i) {
            value = this.sum(value, value);
        }
        return value;
    }
}

