/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.parser;

import com.sun.perseus.parser.AbstractParser;

public class NumberParser
extends AbstractParser {
    private static final float[] POW_10 = new float[128];

    public float parseNumber(String numberString) {
        this.setString(numberString);
        return this.parseNumber(true);
    }

    public float parseNumber() {
        return this.parseNumber(false);
    }

    public float parseNumber(boolean eos) {
        int mant = 0;
        int mantDig = 0;
        boolean mantPos = true;
        boolean mantRead = false;
        int exp = 0;
        int expDig = 0;
        int expAdj = 0;
        boolean expPos = true;
        if (this.current == -1) {
            this.current = this.read();
        }
        switch (this.current) {
            case 45: {
                mantPos = false;
            }
            case 43: {
                this.current = this.read();
            }
        }
        block4 : switch (this.current) {
            default: {
                throw new IllegalArgumentException("" + (char)this.current);
            }
            case 46: {
                break;
            }
            case 48: {
                mantRead = true;
                block51: while (true) {
                    this.current = this.read();
                    switch (this.current) {
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            break block51;
                        }
                        case 46: 
                        case 69: 
                        case 101: {
                            break block4;
                        }
                        case -1: {
                            break block4;
                        }
                        default: {
                            if (eos) {
                                throw new IllegalArgumentException(">" + (char)this.current + "<");
                            }
                            return 0.0f;
                        }
                        case 48: {
                            continue block51;
                        }
                    }
                    break;
                }
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                mantRead = true;
                while (true) {
                    if (mantDig < 9) {
                        ++mantDig;
                        mant = mant * 10 + (this.current - 48);
                    } else {
                        ++expAdj;
                    }
                    this.current = this.read();
                    switch (this.current) {
                        default: {
                            break block4;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                    }
                }
            }
        }
        if (this.current == 46) {
            this.current = this.read();
            block18 : switch (this.current) {
                default: {
                    if (mantRead) break;
                    throw new IllegalArgumentException();
                }
                case 48: {
                    if (mantDig == 0) {
                        block53: while (true) {
                            this.current = this.read();
                            --expAdj;
                            switch (this.current) {
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break block53;
                                }
                                default: {
                                    break block18;
                                }
                                case 48: {
                                    continue block53;
                                }
                            }
                            break;
                        }
                    }
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (true) {
                        if (mantDig < 9) {
                            ++mantDig;
                            mant = mant * 10 + (this.current - 48);
                            --expAdj;
                        }
                        this.current = this.read();
                        switch (this.current) {
                            default: {
                                break block18;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                    }
                }
            }
        }
        block29 : switch (this.current) {
            case 69: 
            case 101: {
                this.current = this.read();
                switch (this.current) {
                    default: {
                        throw new IllegalArgumentException();
                    }
                    case 45: {
                        expPos = false;
                    }
                    case 43: {
                        this.current = this.read();
                        switch (this.current) {
                            default: {
                                throw new IllegalArgumentException();
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                }
                switch (this.current) {
                    case 48: {
                        block55: while (true) {
                            this.current = this.read();
                            switch (this.current) {
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break block55;
                                }
                                default: {
                                    break block29;
                                }
                                case 48: {
                                    continue block55;
                                }
                            }
                            break;
                        }
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        while (true) {
                            if (expDig < 3) {
                                ++expDig;
                                exp = exp * 10 + (this.current - 48);
                            }
                            this.current = this.read();
                            switch (this.current) {
                                default: {
                                    break block29;
                                }
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                            }
                        }
                    }
                }
            }
        }
        if (eos && this.current != -1) {
            throw new IllegalArgumentException();
        }
        if (!expPos) {
            exp = -exp;
        }
        exp += expAdj;
        if (!mantPos) {
            mant = -mant;
        }
        return NumberParser.buildFloat(mant, exp);
    }

    public static float buildFloat(int mant, int exp) {
        if (exp < -125 || mant == 0) {
            return 0.0f;
        }
        if (exp > 128) {
            if (mant > 0) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        if (exp == 0) {
            return mant;
        }
        if (mant >= 0x4000000) {
            ++mant;
        }
        if (exp > 0) {
            return (float)mant * POW_10[exp];
        }
        return (float)mant / POW_10[-exp];
    }

    static {
        float cur = 0.1f;
        for (int i = 0; i < POW_10.length; ++i) {
            NumberParser.POW_10[i] = cur * 10.0f;
            cur = POW_10[i];
        }
    }
}

