/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.util;

import com.sun.perseus.util.RunnableQueue;

final class Scheduler {
    RunnableQueue rq;
    Entry[] entries = new Entry[0];

    Scheduler(RunnableQueue rq) {
        if (rq == null) {
            throw new NullPointerException();
        }
        this.rq = rq;
    }

    public synchronized void add(Runnable r, long interval, RunnableQueue.RunnableHandler handler) {
        if (r == null || interval <= 0L) {
            throw new IllegalArgumentException();
        }
        Entry[] tmpEntries = new Entry[this.entries.length + 1];
        System.arraycopy(this.entries, 0, tmpEntries, 0, this.entries.length);
        Entry newEntry = new Entry();
        newEntry.runnable = r;
        newEntry.interval = interval;
        newEntry.handler = handler;
        tmpEntries[this.entries.length] = newEntry;
        this.entries = tmpEntries;
    }

    public synchronized void remove(Runnable r) {
        while (this.removeImpl(r)) {
        }
    }

    private boolean removeImpl(Runnable r) {
        int i = this.entries.length + 1;
        for (i = 0; i < this.entries.length && this.entries[i].runnable != r; ++i) {
        }
        if (i < this.entries.length) {
            Entry[] tmpEntries = new Entry[this.entries.length - 1];
            System.arraycopy(this.entries, 0, tmpEntries, 0, i);
            System.arraycopy(this.entries, i + 1, tmpEntries, i, this.entries.length - 1 - i);
            this.entries[i].live = false;
            this.entries = tmpEntries;
            return true;
        }
        return false;
    }

    public synchronized long nextRun(long currentTime) {
        if (this.entries.length > 0) {
            long nextRun = this.entries[0].nextRun;
            for (int i = 1; i < this.entries.length; ++i) {
                if (this.entries[i].nextRun >= nextRun) continue;
                nextRun = this.entries[i].nextRun;
            }
            if ((nextRun -= currentTime) < 0L) {
                nextRun = 0L;
            }
            return nextRun;
        }
        return -1L;
    }

    public synchronized void run(long currentTime) {
        Entry[] lEntries = this.entries;
        for (int i = 0; i < lEntries.length; ++i) {
            if (lEntries[i].nextRun > currentTime || !lEntries[i].live) continue;
            lEntries[i].runnable.run();
            lEntries[i].handler.runnableInvoked(this.rq, lEntries[i].runnable);
            lEntries[i].nextRun = currentTime + lEntries[i].interval;
        }
    }

    static final class Entry {
        Runnable runnable;
        long interval;
        long nextRun;
        boolean live = true;
        RunnableQueue.RunnableHandler handler;

        Entry() {
        }
    }
}

