/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MultiLabel
extends JLabel {
    private String text;
    private String pattern;
    private int numLines = 0;
    private List<String[]> textInLines = null;
    private int realNumLines;
    private int componentWidth = 0;
    private static final int TEXT_GAP = 15;
    private static final Font FONT = UIManager.getDefaults().getFont("Label.font");
    private static final FontMetrics FM = new BufferedImage(1, 1, 1).getGraphics().getFontMetrics(FONT);

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public void setHighlightPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setNumLines(int numLines) {
        this.numLines = numLines;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.componentWidth == 0 && this.textInLines == null) {
            this.componentWidth = this.getViewportWidth();
            this.textInLines = this.text2Lines(this.componentWidth);
            this.realNumLines = this.textInLines.size();
        }
        Iterator<String[]> iter = this.textInLines.iterator();
        int lineNum = 0;
        while (iter.hasNext()) {
            ++lineNum;
            String[] w = iter.next();
            StringBuffer sb = new StringBuffer();
            for (String s : w) {
                sb.append(s);
                sb.append(" ");
            }
            g2d.drawString(sb.toString(), 0, lineNum * FM.getHeight());
        }
    }

    private List<String[]> text2Lines(int width) {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        ArrayList<String> line = new ArrayList<String>();
        int currWidth = 0;
        for (String word : this.text.split("\\s")) {
            int wordWidth = SwingUtilities.computeStringWidth(FM, word + " ");
            if (currWidth + wordWidth < width - 15) {
                line.add(word);
                currWidth += wordWidth;
                continue;
            }
            lines.add(line.toArray(new String[line.size()]));
            currWidth = wordWidth;
            line = new ArrayList();
            line.add(word);
        }
        if (!line.isEmpty()) {
            lines.add(line.toArray(new String[line.size()]));
        }
        return lines;
    }

    private int getViewportWidth() {
        int width = 0;
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JViewport)) continue;
            width = parent.getWidth();
            break;
        }
        return width;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.componentWidth == 0 && this.textInLines == null) {
            this.componentWidth = this.getViewportWidth();
            this.textInLines = this.text2Lines(this.componentWidth);
            this.realNumLines = this.textInLines.size();
        }
        return new Dimension(this.componentWidth, this.realNumLines * FM.getHeight() + FM.getMaxDescent());
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.componentWidth = preferredSize.width;
    }

    @Override
    public Dimension getSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private String stripHTML(String htmlSnippet) {
        String res = htmlSnippet.replaceAll("<[^>]*>", "");
        res = res.replaceAll("&nbsp;", " ");
        return res.trim();
    }

    private String getSubstrWithElipsis(String text, FontMetrics fm, int reqWidth, float charWidth, Graphics2D context) {
        int textCharLen = text.length();
        int mIndex = textCharLen;
        int textPixWidth = (int)fm.getStringBounds(text, 0, mIndex, (Graphics)context).getWidth();
        if (reqWidth > textPixWidth) {
            return text;
        }
        while ((float)Math.abs(reqWidth - textPixWidth) > charWidth) {
            int n = textCharLen = textCharLen == 1 ? 1 : textCharLen / 2;
            mIndex = reqWidth - textPixWidth < 0 ? (mIndex -= textCharLen) : (mIndex += textCharLen);
            textPixWidth = (int)fm.getStringBounds(text, 0, mIndex, (Graphics)context).getWidth();
        }
        return text.substring(0, mIndex) + "...";
    }
}

