/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.ui.NbProjectHandleImpl;
import org.netbeans.modules.kenai.ui.RecentProjectsCache;
import org.netbeans.modules.kenai.ui.spi.NbProjectHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.SourceHandle;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SourceHandleImpl
extends SourceHandle
implements PropertyChangeListener {
    private KenaiFeature feature;
    private Preferences prefs;
    private ProjectHandle projectHandle;
    private static final int MAX_PROJECTS = 5;
    private static final String RECENTPROJECTS_PREFIX = "recent.projects.";
    private String externalScmType = "unknown";
    public static final String SCM_TYPE_UNKNOWN = "unknown";
    public static final String SCM_TYPE_CVS = "cvs";
    private RequestProcessor rp = new RequestProcessor(SourceHandleImpl.class);
    List<NbProjectHandle> recent = new ArrayList<NbProjectHandle>();

    public String getExternalScmType() {
        return this.externalScmType;
    }

    public SourceHandleImpl(ProjectHandle projectHandle, KenaiFeature ftr) {
        this.feature = ftr;
        if ("mercurial".equals(this.feature.getService())) {
            this.prefs = NbPreferences.forModule(Mercurial.class);
        } else if ("subversion".equals(this.feature.getService())) {
            this.prefs = NbPreferences.forModule(Subversion.class);
        } else if ("external_repository".equals(this.feature.getService())) {
            this.externalScmType = this.feature.getExtendedType();
            if ("mercurial".equals(this.externalScmType)) {
                this.prefs = NbPreferences.forModule(Mercurial.class);
            } else if ("subversion".equals(this.externalScmType)) {
                this.prefs = NbPreferences.forModule(Subversion.class);
            }
        }
        this.projectHandle = projectHandle;
        OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjects.getDefault()));
        this.initRecent();
    }

    @Override
    public String getDisplayName() {
        return this.feature.getDisplayName();
    }

    @Override
    public boolean isSupported() {
        return "subversion".equals(this.feature.getService()) || "mercurial".equals(this.feature.getService()) || "external_repository".equals(this.feature.getService());
    }

    @Override
    public String getScmFeatureName() {
        return this.feature.getService();
    }

    @Override
    public List<NbProjectHandle> getRecentProjects() {
        return this.recent;
    }

    @Override
    public File getWorkingDirectory() {
        if (this.prefs == null) {
            return this.guessWorkdir();
        }
        try {
            String uriString = this.prefs.get("working.dir." + this.feature.getLocation(), null);
            if (uriString != null) {
                URI uri = new URI(uriString);
                File file = new File(uri);
                FileObject f = FileUtil.toFileObject((File)file);
                if (f == null || !f.isValid()) {
                    return null;
                }
                return file;
            }
            return this.guessWorkdir();
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return this.guessWorkdir();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        final List<Project> newProjects = this.getNewProjects((Project[])evt.getOldValue(), (Project[])evt.getNewValue());
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                SourceHandleImpl.this.addToRecentProjects(newProjects, true);
            }
        });
    }

    void remove(NbProjectHandleImpl aThis) {
        this.recent.remove(aThis);
        this.storeRecent();
        this.projectHandle.firePropertyChange("sourceList", null, null);
    }

    void refresh() {
        if (this.projectHandle != null) {
            this.projectHandle.firePropertyChange("sourceList", null, null);
        }
    }

    private synchronized void addToRecentProjects(List<Project> newProjects, boolean fireChanges) {
        for (Project prj : newProjects) {
            try {
                if (!this.isUnder(prj.getProjectDirectory())) continue;
                NbProjectHandleImpl nbHandle = RecentProjectsCache.getDefault().getProjectHandle(prj, this);
                this.recent.remove(nbHandle);
                this.recent.add(0, nbHandle);
                if (this.recent.size() > 5) {
                    this.recent.remove(5);
                }
                this.storeRecent();
                if (!fireChanges) continue;
                this.projectHandle.firePropertyChange("sourceList", null, null);
            }
            catch (IOException ex) {
                Logger.getLogger(SourceHandleImpl.class.getName()).fine("Project not found for " + prj);
            }
        }
    }

    private List<Project> getNewProjects(Project[] old, Project[] newp) {
        if (newp == null) {
            return Collections.emptyList();
        }
        if (old == null) {
            return Arrays.asList(newp);
        }
        ArrayList<Project> result = new ArrayList<Project>();
        result.addAll(Arrays.asList(newp));
        result.removeAll(Arrays.asList(old));
        return result;
    }

    private File guessWorkdir() {
        if (this.recent.isEmpty()) {
            return null;
        }
        try {
            FileObject parent = ((NbProjectHandleImpl)this.recent.iterator().next()).getProject().getProjectDirectory().getParent();
            if (parent.isValid()) {
                return FileUtil.toFile((FileObject)parent);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void initRecent() {
        if (this.prefs == null) {
            return;
        }
        List<String> roots = SourceHandleImpl.getStringList(this.prefs, RECENTPROJECTS_PREFIX + this.feature.getLocation());
        for (String root : roots) {
            try {
                NbProjectHandleImpl nbH = RecentProjectsCache.getDefault().getProjectHandle(new URL(root), this);
                if (nbH == null) continue;
                this.recent.add(nbH);
            }
            catch (IOException ex) {
                Logger.getLogger(SourceHandleImpl.class.getName()).fine("Project not found for " + root);
            }
        }
        int count = this.recent.size();
        LinkedList<Project> list = new LinkedList<Project>();
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; count < 5 && i < openProjects.length; ++i) {
            if (!this.isUnder(openProjects[i].getProjectDirectory())) continue;
            list.add(openProjects[i]);
            ++count;
        }
        this.addToRecentProjects(list, false);
    }

    private boolean isUnder(FileObject projectDirectory) {
        String remoteLocation = (String)projectDirectory.getAttribute("ProvidedExtensions.RemoteLocation");
        String location = this.feature.getLocation();
        if (!location.endsWith("/")) {
            location = location + "/";
        }
        if (remoteLocation != null && !remoteLocation.endsWith("/")) {
            remoteLocation = remoteLocation + "/";
        }
        if (location.equals(remoteLocation)) {
            return true;
        }
        try {
            URI uri1 = new URI(location);
            URI uri2 = new URI(remoteLocation);
            if (location.substring(uri1.getScheme().length()).equals(remoteLocation.substring(uri2.getScheme().length()))) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private void storeRecent() {
        ArrayList<String> value = new ArrayList<String>();
        for (NbProjectHandle nbp : this.recent) {
            value.add(((NbProjectHandleImpl)nbp).url.toString());
        }
        if (this.prefs != null) {
            SourceHandleImpl.putStringList(this.prefs, RECENTPROJECTS_PREFIX + this.feature.getLocation(), value);
        }
    }

    public static List<String> getStringList(Preferences prefs, String key) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key)) continue;
                int idx = Integer.parseInt(k.substring(k.lastIndexOf(46) + 1));
                retval.add(idx + "." + prefs.get(k, null));
            }
            ArrayList<String> rv = new ArrayList<String>(retval.size());
            rv.addAll(retval);
            for (String s : retval) {
                int pos = s.indexOf(46);
                int index = Integer.parseInt(s.substring(0, pos));
                rv.set(index, s.substring(pos + 1));
            }
            return rv;
        }
        catch (Exception ex) {
            Logger.getLogger(SourceHandleImpl.class.getName()).log(Level.INFO, null, ex);
            return new ArrayList<String>(0);
        }
    }

    public static void putStringList(Preferences prefs, String key, List<String> value) {
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key + ".")) continue;
                prefs.remove(k);
            }
            int idx = 0;
            for (String s : value) {
                prefs.put(key + "." + idx++, s);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(SourceHandleImpl.class.getName()).log(Level.INFO, null, ex);
        }
    }
}

