/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PainterIcon;
import org.netbeans.modules.kenai.ui.treelist.RendererPanel;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListListener;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public abstract class TreeListNode {
    public static final long TIMEOUT_INTERVAL_MILLIS = NbPreferences.forModule(TreeListNode.class).getInt("node.expand.timeoutmillis", 300000);
    private final boolean expandable;
    private final TreeListNode parent;
    private TreeListListener listener;
    private boolean expanded = false;
    private ArrayList<TreeListNode> children = null;
    private final Object LOCK = new Object();
    private RendererPanel renderer;
    private ChildrenLoader loader;
    private static RequestProcessor rp = new RequestProcessor("Asynchronous Tree List Node", 5);

    protected static void post(Runnable run) {
        rp.post(run);
    }

    public TreeListNode(boolean expandable, TreeListNode parent) {
        this.expandable = expandable;
        this.parent = parent;
    }

    public final boolean isExpandable() {
        return this.expandable;
    }

    public final TreeListNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TreeListNode> getChildren() {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.children) {
                return Collections.emptyList();
            }
            return new ArrayList<TreeListNode>(this.children);
        }
    }

    public Action[] getPopupActions() {
        return null;
    }

    protected abstract List<TreeListNode> createChildren();

    protected final void refreshChildren() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TreeListNode.this.LOCK;
                synchronized (object) {
                    if (null != TreeListNode.this.children) {
                        for (TreeListNode node : TreeListNode.this.children) {
                            node.dispose();
                        }
                        TreeListNode.this.children = null;
                        if (null != TreeListNode.this.listener) {
                            TreeListNode.this.listener.childrenRemoved(TreeListNode.this);
                        }
                    }
                    if (TreeListNode.this.expanded) {
                        TreeListNode.this.startLoadingChildren();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JComponent getRenderer(Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowHeight) {
        RendererPanel res = null;
        TreeListNode treeListNode = this;
        synchronized (treeListNode) {
            if (null == this.renderer) {
                this.renderer = new RendererPanel(this);
            }
            res = this.renderer;
        }
        res.configure(foreground, background, isSelected, hasFocus, this.getNestingDepth(), rowHeight);
        return res;
    }

    protected abstract JComponent getComponent(Color var1, Color var2, boolean var3, boolean var4);

    protected Action getDefaultAction() {
        return null;
    }

    protected void childrenLoadingStarted() {
    }

    protected void childrenLoadingFinished() {
    }

    protected void childrenLoadingTimedout() {
    }

    final void setListener(TreeListListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.listener = null;
            if (null != this.children) {
                for (TreeListNode node : this.children) {
                    node.dispose();
                }
            }
        }
    }

    final boolean isDescendantOf(TreeListNode grandParent) {
        if (null == this.parent) {
            return false;
        }
        if (this.parent.equals(grandParent)) {
            return true;
        }
        return this.parent.isDescendantOf(grandParent);
    }

    final boolean isExpanded() {
        return this.expanded && this.isExpandable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExpanded(boolean expanded) {
        if (!this.isExpandable()) {
            throw new IllegalStateException();
        }
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        if (null != this.listener) {
            if (this.expanded) {
                boolean childrenLoaded = true;
                Object object = this.LOCK;
                synchronized (object) {
                    if (null == this.children) {
                        childrenLoaded = false;
                        this.startLoadingChildren();
                    }
                }
                if (childrenLoaded) {
                    this.listener.childrenAdded(this);
                }
            } else {
                Object object = this.LOCK;
                synchronized (object) {
                    if (null != this.loader) {
                        this.loader.cancel();
                        this.childrenLoadingFinished();
                    }
                }
                this.listener.childrenRemoved(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireContentChanged() {
        TreeListNode treeListNode = this;
        synchronized (treeListNode) {
            this.renderer = null;
        }
        if (null != this.listener) {
            this.listener.contentChanged(this);
        }
    }

    protected final ProgressLabel createProgressLabel() {
        return this.createProgressLabel(NbBundle.getMessage(TreeListNode.class, (String)"LBL_LoadingInProgress"));
    }

    protected final ProgressLabel createProgressLabel(String text) {
        return new ProgressLabel(text, this);
    }

    final int getNestingDepth() {
        if (null == this.getParent()) {
            return 0;
        }
        return this.getParent().getNestingDepth() + 1;
    }

    private void startLoadingChildren() {
        this.childrenLoadingStarted();
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = new ChildrenLoader();
        TreeListNode.post(this.loader);
    }

    public static final class ProgressLabel
    extends TreeLabel {
        private int frame = 0;
        private Timer t;
        final BusyPainter painter;
        private final Reference<TreeListNode> ref;

        public ProgressLabel(String text, TreeListNode nd) {
            super(text);
            this.ref = new WeakReference<TreeListNode>(nd);
            this.painter = new BusyPainter(16);
            PainterIcon icon = new PainterIcon(new Dimension(16, 16));
            icon.setPainter((Painter)this.painter);
            this.setIcon((Icon)icon);
            this.t = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeListNode nd = (TreeListNode)ProgressLabel.this.ref.get();
                    if (nd == null) {
                        ProgressLabel.this.t.stop();
                        Container p = ProgressLabel.this.getParent();
                        if (p != null) {
                            p.remove(ProgressLabel.this);
                        }
                        return;
                    }
                    ProgressLabel.this.frame = (ProgressLabel.this.frame + 1) % ProgressLabel.this.painter.getPoints();
                    ProgressLabel.this.painter.setFrame(ProgressLabel.this.frame);
                    ProgressLabel.this.repaint();
                    nd.fireContentChanged();
                }
            });
            this.t.setRepeats(true);
            super.setVisible(false);
        }

        @Override
        public void setVisible(boolean visible) {
            boolean old = this.isVisible();
            super.setVisible(visible);
            if (old != visible) {
                if (visible) {
                    this.t.start();
                } else {
                    this.t.stop();
                }
            }
        }

        public void stop() {
            this.t.stop();
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void validate() {
        }

        @Override
        public void invalidate() {
        }
    }

    private class ChildrenLoader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;

        private ChildrenLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final List[] res = new ArrayList[1];
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    res[0] = TreeListNode.this.createChildren();
                }
            };
            this.t = new Thread(r);
            this.t.start();
            try {
                this.t.join(TIMEOUT_INTERVAL_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.cancelled) {
                return;
            }
            if (null == res[0]) {
                TreeListNode.this.childrenLoadingTimedout();
                return;
            }
            Object object = TreeListNode.this.LOCK;
            synchronized (object) {
                TreeListNode.this.children = new ArrayList(res[0]);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != TreeListNode.this.listener) {
                        TreeListNode.this.listener.childrenAdded(TreeListNode.this);
                    }
                }
            });
            TreeListNode.this.childrenLoadingFinished();
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }
}

