/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.editor.CssEditorSupport;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.visual.ui.preview.CssTCController;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public final class CssCaretAwareSourceTask
extends ParserResultTask<CssParserResult> {
    private static CssTCController windowController;
    private static final String CSS_MIMETYPE = "text/x-css";

    private static synchronized void initializeWindowController() {
        if (windowController == null) {
            windowController = CssTCController.getDefault();
        }
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public void run(CssParserResult result, SchedulerEvent event) {
        SimpleNode leaf;
        if (event == null) {
            return;
        }
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        int caretOffset = ((CursorMovedSchedulerEvent)event).getCaretOffset();
        SimpleNode root = result.root();
        if (root != null && (leaf = SimpleNodeUtil.findDescendant((SimpleNode)root, (int)caretOffset)) != null) {
            SimpleNode ruleNode;
            SimpleNode simpleNode = ruleNode = leaf.kind() == 19 ? leaf : SimpleNodeUtil.getAncestorByType((SimpleNode)leaf, (int)19);
            if (ruleNode != null) {
                List errors = result.getDiagnostics();
                for (Error e : errors) {
                    if (e.getSeverity() != Severity.ERROR || ruleNode.startOffset() > e.getStartPosition() || ruleNode.endOffset() < e.getEndPosition()) continue;
                    CssEditorSupport.getDefault().parsedWithError(result);
                    return;
                }
                CssEditorSupport.getDefault().parsed(result, ((CursorMovedSchedulerEvent)event).getCaretOffset());
                return;
            }
        }
        CssEditorSupport.getDefault().parsedWithError(result);
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            CssCaretAwareSourceTask.initializeWindowController();
            String mimeType = snapshot.getMimeType();
            String sourceMimeType = snapshot.getSource().getMimeType();
            if (sourceMimeType.equals(CssCaretAwareSourceTask.CSS_MIMETYPE) && mimeType.equals(CssCaretAwareSourceTask.CSS_MIMETYPE)) {
                return Collections.singletonList(new CssCaretAwareSourceTask());
            }
            return Collections.EMPTY_LIST;
        }
    }
}

