/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.dialogs.AddManagedBeanDialog;
import org.netbeans.modules.web.jsf.dialogs.BrowseFolders;
import org.netbeans.modules.web.jsf.dialogs.ValidatingPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AddNavigationCaseDialog
extends JPanel
implements ValidatingPanel {
    private JSFConfigDataObject config;
    private JButton jButtonFromView;
    private JButton jButtonToView;
    private JCheckBox jCheckBoxRedirect;
    private JComboBox jComboBoxFromView;
    private JComboBox jComboBoxToView;
    private JLabel jLabelDesc;
    private JLabel jLabelFromAction;
    private JLabel jLabelFromOutcome;
    private JLabel jLabelFromView;
    private JLabel jLabelToView;
    private JScrollPane jScrollPaneDesc;
    private JSeparator jSeparator1;
    private JTextArea jTextAreaDesc;
    private JTextField jTextFieldFromAction;
    private JTextField jTextFieldFromOutcome;

    public AddNavigationCaseDialog(JSFConfigDataObject jSFConfigDataObject, String string) {
        this.initComponents();
        this.config = jSFConfigDataObject;
        FacesConfig facesConfig = ConfigurationUtils.getConfigModel(jSFConfigDataObject.getPrimaryFile(), true).getRootComponent();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.jComboBoxFromView.getModel();
        DefaultComboBoxModel defaultComboBoxModel2 = (DefaultComboBoxModel)this.jComboBoxToView.getModel();
        defaultComboBoxModel.addElement("");
        defaultComboBoxModel2.addElement("");
        Iterator<NavigationRule> iterator = facesConfig.getNavigationRules().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().getFromViewId();
            if (string2 == null || string2.trim().length() <= 0) continue;
            defaultComboBoxModel.addElement(string2);
            defaultComboBoxModel2.addElement(string2);
        }
        if (string != null) {
            this.jComboBoxFromView.setSelectedItem(string);
        }
    }

    @Override
    public JTextComponent[] getDocumentChangeComponents() {
        return new JTextComponent[]{(JTextComponent)this.jComboBoxFromView.getEditor().getEditorComponent(), (JTextComponent)this.jComboBoxToView.getEditor().getEditorComponent(), this.jTextFieldFromAction, this.jTextFieldFromOutcome};
    }

    @Override
    public AbstractButton[] getStateChangeComponents() {
        return new AbstractButton[0];
    }

    @Override
    public String validatePanel() {
        if (this.getToView().length() == 0) {
            return NbBundle.getMessage(AddManagedBeanDialog.class, (String)"MSG_AddNavigationCase_EmptyToView");
        }
        if (this.getFromAction().length() == 0 && this.getFromOutcome().length() == 0) {
            return NbBundle.getMessage(AddManagedBeanDialog.class, (String)"MSG_AddNavigationCase_EmptyFromActionOutcome");
        }
        NavigationRule navigationRule = JSFConfigUtilities.findNavigationRule(this.config, this.getRule());
        if (navigationRule != null) {
            List<NavigationCase> list = navigationRule.getNavigationCases();
            for (NavigationCase navigationCase : list) {
                String string = navigationCase.getFromAction();
                if (string != null && string.equals(this.getFromAction())) {
                    return NbBundle.getMessage(AddManagedBeanDialog.class, (String)"MSG_AddNavigationCase_FromActionExist");
                }
                string = navigationCase.getFromOutcome();
                if (string == null || !string.equals(this.getFromOutcome())) continue;
                return NbBundle.getMessage(AddManagedBeanDialog.class, (String)"MSG_AddNavigationCase_FromOutcomeExist");
            }
        }
        return null;
    }

    private void initComponents() {
        this.jLabelFromView = new JLabel();
        this.jComboBoxFromView = new JComboBox();
        this.jButtonFromView = new JButton();
        this.jLabelFromAction = new JLabel();
        this.jTextFieldFromAction = new JTextField();
        this.jLabelFromOutcome = new JLabel();
        this.jTextFieldFromOutcome = new JTextField();
        this.jLabelToView = new JLabel();
        this.jButtonToView = new JButton();
        this.jCheckBoxRedirect = new JCheckBox();
        this.jLabelDesc = new JLabel();
        this.jScrollPaneDesc = new JScrollPane();
        this.jTextAreaDesc = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.jComboBoxToView = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_AddNavigationCaseDialog"));
        this.jLabelFromView.setDisplayedMnemonic(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"MNE_FromView").charAt(0));
        this.jLabelFromView.setLabelFor(this.jComboBoxFromView);
        this.jLabelFromView.setText(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"LBL_CaseFromView"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 5, 12);
        this.add((Component)this.jLabelFromView, gridBagConstraints);
        this.jComboBoxFromView.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 5, 0);
        this.add((Component)this.jComboBoxFromView, gridBagConstraints);
        this.jComboBoxFromView.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_FromView"));
        this.jButtonFromView.setMnemonic(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"MNE_Browse").charAt(0));
        this.jButtonFromView.setText(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"LBL_Browse"));
        this.jButtonFromView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddNavigationCaseDialog.this.jButtonFromViewActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 5, 11);
        this.add((Component)this.jButtonFromView, gridBagConstraints);
        this.jButtonFromView.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_BrowseFromView"));
        this.jLabelFromAction.setDisplayedMnemonic(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"MNE_FromAction").charAt(0));
        this.jLabelFromAction.setLabelFor(this.jTextFieldFromAction);
        this.jLabelFromAction.setText(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"LBL_FromAction"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.jLabelFromAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextFieldFromAction, gridBagConstraints);
        this.jTextFieldFromAction.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_FromAction"));
        this.jLabelFromOutcome.setDisplayedMnemonic(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"MNE_FromOutcome").charAt(0));
        this.jLabelFromOutcome.setLabelFor(this.jTextFieldFromOutcome);
        this.jLabelFromOutcome.setText(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"LBL_FromOutcome"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.jLabelFromOutcome, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextFieldFromOutcome, gridBagConstraints);
        this.jTextFieldFromOutcome.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_FromOutcome"));
        this.jLabelToView.setDisplayedMnemonic(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"MNE_ToView").charAt(0));
        this.jLabelToView.setLabelFor(this.jComboBoxToView);
        this.jLabelToView.setText(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"LBL_ToView"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.jLabelToView, gridBagConstraints);
        this.jButtonToView.setMnemonic(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"MNE_BrowseToView").charAt(0));
        this.jButtonToView.setText(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"LBL_Browse"));
        this.jButtonToView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddNavigationCaseDialog.this.jButtonToViewActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 11);
        this.add((Component)this.jButtonToView, gridBagConstraints);
        this.jButtonToView.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_BrowseToView"));
        this.jCheckBoxRedirect.setMnemonic(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"MNE_Redirect").charAt(0));
        this.jCheckBoxRedirect.setText(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"LBL_Redirect"));
        this.jCheckBoxRedirect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxRedirect.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jCheckBoxRedirect, gridBagConstraints);
        this.jCheckBoxRedirect.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_Redirect"));
        this.jLabelDesc.setDisplayedMnemonic(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"MNE_BeanDescription").charAt(0));
        this.jLabelDesc.setLabelFor(this.jTextAreaDesc);
        this.jLabelDesc.setText(NbBundle.getMessage(AddNavigationCaseDialog.class, (String)"LBL_RuleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 11, 12);
        this.add((Component)this.jLabelDesc, gridBagConstraints);
        this.jTextAreaDesc.setColumns(20);
        this.jTextAreaDesc.setRows(5);
        this.jScrollPaneDesc.setViewportView(this.jTextAreaDesc);
        this.jTextAreaDesc.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_CaseDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jScrollPaneDesc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 6, 11);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jComboBoxToView.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jComboBoxToView, gridBagConstraints);
        this.jComboBoxToView.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_ToViewSelect"));
    }

    private void jButtonToViewActionPerformed(ActionEvent actionEvent) {
        try {
            SourceGroup[] sourceGroupArray = JSFConfigUtilities.getDocBaseGroups(this.config.getPrimaryFile());
            FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
            if (fileObject != null) {
                String string = "/" + JSFConfigUtilities.getResourcePath(sourceGroupArray, fileObject, '/', true);
                this.jComboBoxToView.setSelectedItem(string);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void jButtonFromViewActionPerformed(ActionEvent actionEvent) {
        try {
            SourceGroup[] sourceGroupArray = JSFConfigUtilities.getDocBaseGroups(this.config.getPrimaryFile());
            FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
            if (fileObject != null) {
                String string = "/" + JSFConfigUtilities.getResourcePath(sourceGroupArray, fileObject, '/', true);
                this.jComboBoxFromView.setSelectedItem(string);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public String getRule() {
        return (String)this.jComboBoxFromView.getSelectedItem();
    }

    public String getFromAction() {
        return this.jTextFieldFromAction.getText();
    }

    public String getFromOutcome() {
        return this.jTextFieldFromOutcome.getText();
    }

    public String getToView() {
        return (String)this.jComboBoxToView.getEditor().getItem();
    }

    public boolean isRedirect() {
        return this.jCheckBoxRedirect.isSelected();
    }

    public String getDescription() {
        return this.jTextAreaDesc.getText();
    }
}

