/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.SelectActionFactory;

public final class SelectAction
extends AbstractComposerAction {
    private static final Color SELECTION_BODY_COLOR = new Color(64, 64, 255, 64);
    private static final Color SELECTION_OUTLINE_COLOR = new Color(64, 64, 255, 128);
    private final SVGObject m_selected;

    public SelectAction(SelectActionFactory factory, SVGObject selected) {
        super(factory);
        this.m_selected = selected;
        assert (this.m_selected != null) : "The selected object cannot be null";
        this.m_selected.repaint(5);
    }

    @Override
    public boolean consumeEvent(AWTEvent evt, boolean isOutsideEvent) {
        SceneManager sceneMgr = this.m_factory.getSceneManager();
        assert (sceneMgr.containsAction(SelectAction.class));
        MouseEvent me = SelectActionFactory.getSelectionEvent(evt);
        if (me != null) {
            SVGObject[] objects = null;
            if (!isOutsideEvent) {
                objects = sceneMgr.getPerseusController().getObjectsAt(me.getX(), me.getY());
            }
            if (objects == null || objects.length == 0 || objects[0] != this.m_selected) {
                this.actionCompleted();
            }
        }
        return false;
    }

    @Override
    public void paint(Graphics g, int x, int y, boolean isReadOnly) {
        if (!this.m_isCompleted && !this.m_selected.isDeleted()) {
            if (isReadOnly) {
                if (this.getScreenManager().getHighlightObject()) {
                    SVGObjectOutline outline = this.m_selected.getOutline();
                    outline.highlight(g, x, y, SELECTION_BODY_COLOR);
                    outline.draw(g, x, y, SELECTION_OUTLINE_COLOR, false);
                }
            } else {
                this.m_selected.getOutline().draw(g, x, y, SVGObjectOutline.SELECTOR_BODY, true);
            }
        }
    }

    public SVGObject getSelected() {
        if (this.m_isCompleted) {
            return null;
        }
        if (this.m_selected.isDeleted()) {
            this.actionCompleted();
            return null;
        }
        return this.m_selected;
    }

    @Override
    public void actionCompleted() {
        this.m_selected.repaint(5);
        super.actionCompleted();
    }
}

