/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.microedition.m2g.SVGImage;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.export.AbstractSaveAction;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.SVGImageRasterizerPanel;
import org.netbeans.modules.mobility.svgcore.export.SaveAnimationAsImageAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SaveElementAsImage
extends AbstractSaveAction {
    protected void performAction(Node[] activatedNodes) {
        Lookup l = activatedNodes[0].getLookup();
        SVGDataObject doj = (SVGDataObject)((Object)l.lookup(SVGDataObject.class));
        SVGObject svgObj = (SVGObject)l.lookup(SVGObject.class);
        SVGImage image = (SVGImage)l.lookup(SVGImage.class);
        if (svgObj != null && image != null) {
            int state = this.getAnimatorState(doj);
            float time = this.stopAnimator(doj);
            try {
                final SVGImageRasterizerPanel panel = new SVGImageRasterizerPanel(doj, svgObj.getElementId());
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SaveElementAsImage.class, (String)"TITLE_ImageExport"));
                panel.addPropertyChangeListener("valid", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        dd.setValid(panel.isDialogValid());
                    }
                });
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                SaveAnimationAsImageAction.setDialogMinimumSize(dlg);
                dd.setValid(panel.isDialogValid());
                dlg.setVisible(true);
                if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                    AnimationRasterizer.export(doj, panel);
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            this.resumeAnimatorState(doj, state, time);
        }
    }

    protected int mode() {
        return 7;
    }

    public String getName() {
        return NbBundle.getMessage(SaveElementAsImage.class, (String)"CTL_SVGExportAction");
    }

    protected Class[] cookieClasses() {
        return new Class[]{SVGDataObject.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

