/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.items;

import java.io.IOException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.items.form.SVGComponentDrop;

public abstract class SVGBasicShape
extends SVGComponentDrop {
    private String mySnippetPath;

    protected SVGBasicShape(String snippetPath) {
        assert (snippetPath != null) : "snippet path == null";
        this.mySnippetPath = snippetPath;
    }

    @Override
    protected boolean doTransfer(SVGDataObject svgDataObject) {
        try {
            String snippet = this.getSnippet();
            String id = svgDataObject.getModel().mergeImage(snippet, false);
            this.setSelection(id);
            return true;
        }
        catch (Exception ex) {
            SceneManager.error("Error during image merge", ex);
            return false;
        }
    }

    @Override
    protected boolean doTransfer(JTextComponent target) {
        try {
            String snippet = this.getSnippet();
            SVGBasicShape.insertToTextComponent(snippet, target);
            return true;
        }
        catch (Exception ex) {
            SceneManager.error("Error during image merge", ex);
            return false;
        }
    }

    protected String getSnippet() throws IOException {
        String text = this.loadSnippetString();
        return this.replaceCoordinates(text);
    }

    protected String loadSnippetString() throws IOException {
        return SVGBasicShape.loadSnippetString(this.getClass(), this.mySnippetPath);
    }
}

