/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.navigator;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorNode;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorTreeCellRenderer;

public final class SVGNavigatorTree
extends JTree {
    public static byte VISIBILITY_DIRECT = 1;
    public static byte VISIBILITY_UNDIRECT = (byte)2;
    public static byte VISIBILITY_NO = (byte)3;
    static boolean showAttributes = true;
    static boolean showIdOnly = false;
    static boolean showAnimationsOnly = false;
    private final SVGDataObject m_dObj;
    private final DefaultTreeModel m_treeModel;
    private boolean m_firstPaint;
    private String m_selectedId = null;

    public SVGNavigatorTree(SVGDataObject dObj) throws Exception {
        this.m_dObj = dObj;
        this.m_firstPaint = true;
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.putClientProperty("JTree.lineStyle", "Angled");
        DocumentElement rootElement = dObj.getModel().getModel().getRootElement();
        SVGNavigatorNode rootTna = new SVGNavigatorNode(rootElement, this, null, VISIBILITY_DIRECT);
        this.m_treeModel = new DefaultTreeModel(rootTna);
        this.setModel(this.m_treeModel);
        this.setCellRenderer(new SVGNavigatorTreeCellRenderer());
    }

    public DefaultTreeModel getTreeModel() {
        return this.m_treeModel;
    }

    public SVGDataObject getDataObject() {
        return this.m_dObj;
    }

    String getSelectedId() {
        return this.m_selectedId;
    }

    public void filterChanged() {
        TreePath path;
        SVGNavigatorNode root = (SVGNavigatorNode)this.treeModel.getRoot();
        root.refresh();
        if (root.getChildCount() > 0 && this.isCollapsed(path = new TreePath(root))) {
            this.expandPath(path);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.m_firstPaint) {
            int height = g.getFontMetrics(this.getFont()).getHeight();
            this.setRowHeight(height + 2);
            this.m_firstPaint = false;
        }
        super.paint(g);
    }

    public static boolean isTreeElement(DocumentElement de) {
        return SVGFileModel.isTagElement(de);
    }

    public void selectNode(String elemId, DocumentElement de) {
        this.m_selectedId = elemId;
        if (elemId == null) {
            this.getSelectionModel().clearSelection();
            this.repaint();
        } else {
            if (de == null) {
                de = this.m_dObj.getModel().getElementById(elemId);
            }
            if (de != null) {
                SVGNavigatorNode rootNode = (SVGNavigatorNode)this.treeModel.getRoot();
                SVGNavigatorNode node = rootNode.findNode(de);
                if (node == null) {
                    SVGNavigatorNode childNode;
                    List<DocumentElement> parents = SVGFileModel.getParents(de);
                    int parentIndex = parents.size() - 1;
                    assert (parentIndex >= 0) : "The element must have at least one parent";
                    node = rootNode.findNode(parents.get(parentIndex));
                    assert (node != null) : "Tree node not found";
                    while (parentIndex > 0 && (childNode = node.getChildByElemenent(parents.get(--parentIndex))) != null) {
                        node = childNode;
                    }
                }
                TreePath treePath = node.getNodePath();
                this.makeVisible(treePath);
                this.setSelectionPath(treePath);
                Rectangle rect = this.getPathBounds(treePath);
                this.scrollRectToVisible(rect);
                this.repaint();
            }
        }
    }

    byte checkVisibility(DocumentElement docElem, boolean deepCheck) {
        boolean isVisible = SVGNavigatorTree.isVisible(docElem);
        if (!isVisible && deepCheck) {
            for (DocumentElement chde : docElem.getChildren()) {
                if (!SVGNavigatorTree.isTreeElement(docElem) || this.checkVisibility(chde, true) == VISIBILITY_NO) continue;
                return VISIBILITY_UNDIRECT;
            }
        }
        return isVisible ? VISIBILITY_DIRECT : VISIBILITY_NO;
    }

    private static boolean isVisible(DocumentElement docElem) {
        String id;
        if (showIdOnly && ((id = SVGFileModel.getIdAttribute(docElem)) == null || id.length() == 0)) {
            return false;
        }
        return !showAnimationsOnly || SVGFileModel.isAnimation(docElem);
    }
}

