/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.queries.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.common.queries.spi.InjectionTargetQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class InjectionTargetQuery {
    private static Lookup.Result<InjectionTargetQueryImplementation> implementations;
    private static List<InjectionTargetQueryImplementation> cache;

    private InjectionTargetQuery() {
    }

    public static boolean isInjectionTarget(CompilationController compilationController, TypeElement typeElement) {
        if (typeElement == null || compilationController == null) {
            throw new NullPointerException("Passed null to InjectionTargetQuery.isInjectionTarget(CompilationController, TypeElement)");
        }
        for (InjectionTargetQueryImplementation injectionTargetQueryImplementation : InjectionTargetQuery.getInstances()) {
            if (!injectionTargetQueryImplementation.isInjectionTarget(compilationController, typeElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInjectionTarget(FileObject fileObject, final String string) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final boolean[] blArray = new boolean[]{false};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                if (typeElement != null) {
                    blArray[0] = InjectionTargetQuery.isInjectionTarget(compilationController, typeElement);
                }
            }
        }, true);
        return blArray[0];
    }

    public static boolean isStaticReferenceRequired(CompilationController compilationController, TypeElement typeElement) {
        if (typeElement == null || compilationController == null) {
            throw new NullPointerException("Passed null to InjectionTargetQuery.isStaticReferenceRequired(CompilationController, TypeElement)");
        }
        for (InjectionTargetQueryImplementation injectionTargetQueryImplementation : InjectionTargetQuery.getInstances()) {
            if (!injectionTargetQueryImplementation.isStaticReferenceRequired(compilationController, typeElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStaticReferenceRequired(FileObject fileObject, final String string) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final boolean[] blArray = new boolean[]{false};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                if (typeElement != null) {
                    blArray[0] = InjectionTargetQuery.isStaticReferenceRequired(compilationController, typeElement);
                }
            }
        }, true);
        return blArray[0];
    }

    private static synchronized List<InjectionTargetQueryImplementation> getInstances() {
        if (implementations == null) {
            implementations = Lookup.getDefault().lookup(new Lookup.Template(InjectionTargetQueryImplementation.class));
            implementations.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    Class<InjectionTargetQuery> clazz = InjectionTargetQuery.class;
                    synchronized (InjectionTargetQuery.class) {
                        cache = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        if (cache == null) {
            cache = new ArrayList<InjectionTargetQueryImplementation>(implementations.allInstances());
        }
        return cache;
    }
}

