/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlHelper
extends BaseHelper {
    protected static Document parseXmlDocument(final FileObject fileObject) {
        return (Document)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Document>(){

            public Document run() {
                if (fileObject == null || !fileObject.isData()) {
                    return null;
                }
                try {
                    return XmlHelper.doParseXmlDocument(fileObject);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                catch (SAXException sAXException) {
                    ErrorManager.getDefault().notify((Throwable)sAXException);
                }
                return null;
            }
        });
    }

    protected static void saveXmlDocument(final Document document, final FileObject fileObject) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                try {
                    XmlHelper.doSaveXmlDocument(document, fileObject);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSaveXmlDocument(Document document, FileObject fileObject) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document doParseXmlDocument(FileObject fileObject) throws FileNotFoundException, IOException, SAXException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = fileObject.getInputStream();
        try {
            FileUtil.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        }
        finally {
            inputStream.close();
        }
        return XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), (boolean)false, (boolean)false, null, null);
    }
}

