/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentVisualPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.EditableListModel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewLibraryDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JavaMELibsVisualPanel
extends JPanel {
    private static final String CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String DLD_DELETE_TITLE = "MSG_LibraryDeleteTitle";
    private static final String DLD_DELETE_MSG = "MSG_LibraryDeleteMsg";
    private static final String ACSN_LIB_PANEL = "ACSN_LibPanel";
    private static final String ACSD_LIB_PANEL = "ACSD_LibPanel";
    private JScrollPane jScrollPane1;
    private JButton myAddButton;
    private JLabel myDescLabel;
    private JList myLibDescList;
    private JButton myRemoveButton;
    private WizardDescriptor myWizardDescriptor;
    private WizardDescriptor myInnerDescriptor;

    public JavaMELibsVisualPanel() {
        this.initComponents();
        this.initAccessibility();
        this.myLibDescList.setModel(new LibraryListModel());
        this.myLibDescList.getSelectionModel().setSelectionMode(0);
        this.myLibDescList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JavaMELibsVisualPanel.this.updateRemoveButton();
            }
        });
        this.updateRemoveButton();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(JavaMELibsVisualPanel.class);
    }

    private void updateRemoveButton() {
        if (this.myLibDescList.isSelectionEmpty()) {
            this.myRemoveButton.setEnabled(false);
        } else {
            this.myRemoveButton.setEnabled(true);
        }
    }

    void readData(WizardDescriptor wizardDescriptor) {
        this.myWizardDescriptor = wizardDescriptor;
        List list = (List)this.myWizardDescriptor.getProperty("libNames");
        List list2 = (List)this.myWizardDescriptor.getProperty("libDisplayNames");
        LibraryListModel libraryListModel = (LibraryListModel)this.myLibDescList.getModel();
        libraryListModel.updateModel(list, list2);
    }

    void storeData(WizardDescriptor wizardDescriptor) {
    }

    private void initComponents() {
        this.myDescLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.myLibDescList = new JList();
        this.myAddButton = new JButton();
        this.myRemoveButton = new JButton();
        this.myDescLabel.setLabelFor(this.myLibDescList);
        Mnemonics.setLocalizedText((JLabel)this.myDescLabel, (String)NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"LBL_AddedLibDescriptors"));
        this.jScrollPane1.setViewportView(this.myLibDescList);
        this.myLibDescList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_DescriptorsList"));
        this.myLibDescList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSD_DescriptorsList"));
        Mnemonics.setLocalizedText((AbstractButton)this.myAddButton, (String)NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"BTN_AddLibDesc"));
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaMELibsVisualPanel.this.addPressed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.myRemoveButton, (String)NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"BTN_LibRemove"));
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaMELibsVisualPanel.this.removePressed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myDescLabel).add((Component)this.jScrollPane1, -1, 330, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.myAddButton, -1, -1, Short.MAX_VALUE).add((Component)this.myRemoveButton, -1, -1, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myDescLabel).add(6, 6, 6).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myAddButton).addPreferredGap(0).add((Component)this.myRemoveButton).addContainerGap(230, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 282, Short.MAX_VALUE))));
        this.myDescLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_DescLabel"));
        this.myDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ASCD_DescLabel"));
        this.myAddButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_LibAdd"));
        this.myAddButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_LibAdd"));
        this.myRemoveButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_LibRemove"));
        this.myRemoveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_LibRemove"));
    }

    private void addPressed(ActionEvent actionEvent) {
        NewLibraryDescriptor newLibraryDescriptor = new NewLibraryDescriptor(this.myWizardDescriptor);
        this.myInnerDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)newLibraryDescriptor);
        this.myInnerDescriptor.putProperty(AUTO_WIZARD_STYLE, (Object)true);
        this.myInnerDescriptor.putProperty(CONTENT_DISPLAYED, (Object)true);
        this.myInnerDescriptor.putProperty(CONTENT_NUMBERED, (Object)true);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.myInnerDescriptor);
        dialog.setVisible(true);
        this.readData(this.myWizardDescriptor);
    }

    private void removePressed(ActionEvent actionEvent) {
        int n = this.myLibDescList.getSelectedIndex();
        List list = (List)this.myWizardDescriptor.getProperty("libNames");
        List list2 = (List)this.myWizardDescriptor.getProperty("libDisplayNames");
        String string = (String)list.get(n);
        String string2 = JavaMELibsVisualPanel.getMessage(DLD_DELETE_TITLE, new Object[0]);
        String string3 = JavaMELibsVisualPanel.getMessage(DLD_DELETE_MSG, string);
        if (!UIUtils.userConfirmOkCancel(string2, string3)) {
            return;
        }
        ((LibraryListModel)this.myLibDescList.getModel()).remove(n);
        list.remove(n);
        list2.remove(n);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSN_LIB_PANEL));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSD_LIB_PANEL));
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)string, (Object[])objectArray);
    }

    private class LibraryListModel
    extends EditableListModel {
        private LibraryListModel() {
        }

        public void updateModel(List<String> list, List<String> list2) {
            this.removeAllElements();
            if (list == null || list2 == null) {
                return;
            }
            assert (list.size() == list2.size()) : "libraries data is not consistent";
            Iterator<String> iterator = list.iterator();
            Iterator<String> iterator2 = list2.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = iterator2.next();
                this.addElement(string2 + " [ " + string + " ]");
            }
        }
    }
}

