/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding.core;

import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.microedition.databinding.DataBinder;
import org.netbeans.microedition.databinding.DataBindingProvider;
import org.netbeans.microedition.databinding.DataSet;
import org.netbeans.microedition.databinding.core.BindingPair;
import org.netbeans.microedition.databinding.core.DataBindingELContext;
import org.netbeans.microedition.databinding.el.StringReader;
import org.netbeans.microedition.databinding.el.parser.ELParser;
import org.netbeans.microedition.databinding.el.parser.ParseException;

public class BindDescriptor {
    private String elPointer;
    private DataBindingProvider binder;
    private Object consumer;
    private Object feature;
    private Vector pointersCache;

    public BindDescriptor(String elPointer, DataBindingProvider binder, Object consumer, Object feature) {
        this.elPointer = elPointer;
        this.binder = binder;
        this.consumer = consumer;
        this.feature = feature;
    }

    public void updateFromDataSourceToCustomer() {
        Object value;
        ELParser parser = new ELParser(new StringReader(this.elPointer), DataBindingELContext.CONTEXT, true);
        this.pointersCache = parser.getStoredPointers();
        try {
            value = parser.Expression();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return;
        }
        this.binder.pushDataToConsumer(this.elPointer, this.consumer, this.feature, value);
    }

    public boolean equalsBindTarget(BindDescriptor desc) {
        return this.consumer == desc.consumer && (this.feature == null ? desc.feature == null : this.feature.equals(desc.feature));
    }

    public void updateFromCustomerToDataSource() {
        Object value = this.binder.pullDataFromConsumer(this.elPointer, this.consumer, this.feature);
        DataBinder.writeValue(this.elPointer, value);
    }

    public boolean containsDataSetItem(DataSet dataSet, Object dataItemName) {
        if (this.pointersCache == null) {
            return false;
        }
        Enumeration e = this.pointersCache.elements();
        while (e.hasMoreElements()) {
            BindingPair pair = (BindingPair)e.nextElement();
            if (pair.getDataSet() != dataSet || dataItemName != null && !dataItemName.equals(pair.getDataItemName())) continue;
            return true;
        }
        return false;
    }

    public void notifyBind() {
        this.binder.notifyBind(this.elPointer, this.consumer, this.feature);
    }

    public void notifyUnbind() {
        this.binder.notifyUnbind(this.elPointer, this.consumer, this.feature);
    }
}

