/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.editor.java.BraceCompletion;
import org.netbeans.modules.editor.java.DeleteToNextCamelCasePosition;
import org.netbeans.modules.editor.java.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.NextCamelCasePosition;
import org.netbeans.modules.editor.java.PreviousCamelCasePosition;
import org.netbeans.modules.editor.java.SelectCodeElementAction;
import org.netbeans.modules.editor.java.SelectNextCamelCasePosition;
import org.netbeans.modules.editor.java.SelectPreviousCamelCasePosition;
import org.netbeans.modules.java.editor.codegen.InsertSemicolonAction;
import org.netbeans.modules.java.editor.imports.FastImportAction;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.editor.overridden.GoToSuperTypeAction;
import org.netbeans.modules.java.editor.rename.InstantRenameAction;
import org.netbeans.modules.java.editor.semantic.GoToMarkOccurrencesAction;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaKit
extends NbEditorKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    static final long serialVersionUID = -5445829962533684922L;
    private static final Logger LOGGER = Logger.getLogger(JavaKit.class.getName());
    private static final Object sourceLevelKey = new Object();
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fixImportsAction = "fix-imports";
    public static final String fastImportAction = "fast-import";
    public static final String tryCatchAction = "try-catch";
    public static final String javaDocShowAction = "javadoc-show-action";
    public static final String expandAllJavadocFolds = "expand-all-javadoc-folds";
    public static final String collapseAllJavadocFolds = "collapse-all-javadoc-folds";
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    public static final String selectNextElementAction = "select-element-next";
    public static final String selectPreviousElementAction = "select-element-previous";
    static final String previousCamelCasePosition = "previous-camel-case-position";
    static final String nextCamelCasePosition = "next-camel-case-position";
    static final String selectPreviousCamelCasePosition = "select-previous-camel-case-position";
    static final String selectNextCamelCasePosition = "select-next-camel-case-position";
    static final String deletePreviousCamelCasePosition = "delete-previous-camel-case-position";
    static final String deleteNextCamelCasePosition = "delete-next-camel-case-position";

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public Syntax createSyntax(Document document) {
        String string = (String)document.getProperty(sourceLevelKey);
        if (string == null) {
            string = this.getSourceLevel((BaseDocument)document);
            document.putProperty(sourceLevelKey, string);
        }
        return new JavaSyntax(string);
    }

    public String getSourceLevel(BaseDocument baseDocument) {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
        return dataObject != null ? SourceLevelQuery.getSourceLevel((FileObject)dataObject.getPrimaryFile()) : null;
    }

    public Formatter createFormatter() {
        return new JavaFormatter(((Object)((Object)this)).getClass());
    }

    protected void initDocument(BaseDocument baseDocument) {
        baseDocument.putProperty(SyntaxUpdateTokens.class, (Object)new SyntaxUpdateTokens(){
            private List tokenList = new ArrayList();

            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            public void syntaxUpdateToken(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
                if (JavaTokenContext.LINE_COMMENT == tokenID) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo((SyntaxUpdateTokens)this, tokenID, tokenContextPath, n, n2));
                }
            }
        });
        CodeTemplateManager.get((Document)baseDocument);
    }

    protected Action[] createActions() {
        Action[] actionArray = super.createActions();
        BaseAction[] baseActionArray = new BaseAction[]{new JavaDefaultKeyTypedAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new ExtKit.ToggleCommentAction("//"), new JavaInsertBreakAction(), new JavaDeleteCharAction("delete-previous", false), new JavaDeleteCharAction("delete-next", true), new JavaGenerateFoldPopupAction(), new JavaGoToDeclarationAction(), new InstantRenameAction(), new InsertSemicolonAction(true), new InsertSemicolonAction(false), new SelectCodeElementAction(selectNextElementAction, true), new SelectCodeElementAction(selectPreviousElementAction, false), new NextCamelCasePosition(JavaKit.findAction(actionArray, "caret-next-word")), new PreviousCamelCasePosition(JavaKit.findAction(actionArray, "caret-previous-word")), new SelectNextCamelCasePosition(JavaKit.findAction(actionArray, "selection-next-word")), new SelectPreviousCamelCasePosition(JavaKit.findAction(actionArray, "selection-previous-word")), new DeleteToNextCamelCasePosition(JavaKit.findAction(actionArray, "remove-word-next")), new DeleteToPreviousCamelCasePosition(JavaKit.findAction(actionArray, "remove-word-previous")), new FastImportAction(), new GoToSuperTypeAction(), new GoToMarkOccurrencesAction(false), new GoToMarkOccurrencesAction(true)};
        return TextAction.augmentList(actionArray, (Action[])baseActionArray);
    }

    private static Action findAction(Action[] actionArray, String string) {
        for (Action action : actionArray) {
            Object object = action.getValue("Name");
            if (!(object instanceof String) || !string.equals(object)) continue;
            return action;
        }
        return null;
    }

    public static class JavaGotoHelpAction
    extends BaseAction {
        public JavaGotoHelpAction() {
            super(142);
            this.putValue("helpID", JavaGotoHelpAction.class.getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                GoToSupport.goToJavadoc(jTextComponent.getDocument(), jTextComponent.getCaretPosition());
            }
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return NbBundle.getBundle(JavaKit.class).getString("show_javadoc");
        }
    }

    public static class JavaFixImports
    extends BaseAction {
        public JavaFixImports() {
            super(14);
            this.putValue("trimmed-text", NbBundle.getBundle(JavaKit.class).getString("fix-imports-trimmed"));
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString("desc-fix-imports"));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-fix-imports"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Document document;
            Object object;
            if (jTextComponent != null && (object = (document = jTextComponent.getDocument()).getProperty("stream")) instanceof DataObject) {
                FileObject fileObject = ((DataObject)object).getPrimaryFile();
                JavaFixAllImports.getDefault().fixAllImports(fileObject);
            }
        }

        public static final class GlobalAction
        extends MainMenuAction {
            public GlobalAction() {
                this.setMenu();
            }

            protected String getMenuItemText() {
                return NbBundle.getBundle(GlobalAction.class).getString("fix-imports-main-menu-source-item");
            }

            protected String getActionName() {
                return JavaKit.fixImportsAction;
            }
        }
    }

    public static class JavaGoToSourceAction
    extends BaseAction {
        static final long serialVersionUID = -6440495023918097760L;

        public JavaGoToSourceAction() {
            super(142);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && jTextComponent.getDocument() instanceof BaseDocument) {
                GoToSupport.goTo((Document)((BaseDocument)jTextComponent.getDocument()), jTextComponent.getCaretPosition(), true);
            }
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted");
        }

        protected Class getShortDescriptionBundleClass() {
            return BaseKit.class;
        }
    }

    public static class JavaGoToDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        public boolean gotoDeclaration(JTextComponent jTextComponent) {
            if (!(jTextComponent.getDocument() instanceof BaseDocument)) {
                return false;
            }
            GoToSupport.goTo((Document)((BaseDocument)jTextComponent.getDocument()), jTextComponent.getCaretPosition(), false);
            return true;
        }
    }

    public static class JavaGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent jTextComponent, JMenu jMenu) {
            this.addAction(jTextComponent, jMenu, JavaKit.collapseAllJavadocFolds);
            this.addAction(jTextComponent, jMenu, JavaKit.expandAllJavadocFolds);
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(jTextComponent, jMenu, JavaKit.collapseAllCodeBlockFolds);
            this.addAction(jTextComponent, jMenu, JavaKit.expandAllCodeBlockFolds);
        }
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            arrayList.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.collapse((FoldHierarchy)foldHierarchy, arrayList);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            arrayList.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, arrayList);
        }
    }

    public static class CollapseAllJavadocFolds
    extends BaseAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.collapse((FoldHierarchy)foldHierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class ExpandAllJavadocFolds
    extends BaseAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class JavaDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public JavaDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            BraceCompletion.charBackspaced(baseDocument, n, caret, c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            jTextComponent.putClientProperty(JavaDeleteCharAction.class, (Object)this);
            try {
                super.actionPerformed(actionEvent, jTextComponent);
            }
            finally {
                jTextComponent.putClientProperty(JavaDeleteCharAction.class, null);
            }
        }

        public boolean getNextChar() {
            return this.nextChar;
        }
    }

    public static class JavaInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;
        private boolean isJavadocTouched = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block13: {
                try {
                    super.actionPerformed(actionEvent, jTextComponent);
                    if (this.isJavadocTouched) {
                        Lookup.Result result = MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/x-javadoc")).lookupResult(TextAction.class);
                        ActionEvent actionEvent2 = new ActionEvent(jTextComponent, 1001, "fix-javadoc");
                        for (TextAction textAction : result.allInstances()) {
                            textAction.actionPerformed(actionEvent2);
                        }
                        break block13;
                    }
                    Document document = jTextComponent.getDocument();
                    int n = ((AbstractDocument)document).getParagraphElement(jTextComponent.getCaretPosition()).getStartOffset();
                    int n2 = ((AbstractDocument)document).getParagraphElement(jTextComponent.getCaretPosition()).getEndOffset();
                    try {
                        if (document.getText(n, n2 - n - 1).matches("\\s+\\*\\s+")) {
                            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                            tokenSequence.move(jTextComponent.getCaretPosition());
                            tokenSequence.moveNext();
                            Token token = tokenSequence.token();
                            if (token.id() == JavaTokenId.BLOCK_COMMENT) {
                                String string;
                                int n3;
                                if (token.partType() == PartType.START) {
                                    String string2 = document.getText(n, n2 - n - 1);
                                    string2 = string2.replaceFirst(" \\* ", " */");
                                    string2 = "\n" + string2;
                                    int n4 = jTextComponent.getCaretPosition();
                                    document.insertString(n2 - 1, string2, null);
                                    jTextComponent.setCaretPosition(n4);
                                } else if (token.partType() == PartType.COMPLETE && (n3 = (string = document.getText(n2, document.getLength() - n2)).indexOf("*/")) != -1) {
                                    string = string.substring(0, n3 + 2);
                                    TokenHierarchy tokenHierarchy2 = TokenHierarchy.create((CharSequence)string, (Language)JavaTokenId.language());
                                    TokenSequence tokenSequence2 = tokenHierarchy2.tokenSequence();
                                    tokenSequence2.moveEnd();
                                    tokenSequence2.movePrevious();
                                    Token token2 = tokenSequence2.token();
                                    if (token2.id() != JavaTokenId.INVALID_COMMENT_END) {
                                        String string3 = document.getText(n, n2 - n - 1);
                                        string3 = string3.replaceFirst(" \\* ", " */");
                                        string3 = "\n" + string3;
                                        int n5 = jTextComponent.getCaretPosition();
                                        document.insertString(n2 - 1, string3, null);
                                        jTextComponent.setCaretPosition(n5);
                                    }
                                }
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.log(Level.WARNING, "Cannot complete block comment", badLocationException);
                    }
                }
                finally {
                    this.isJavadocTouched = false;
                }
            }
        }

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            int n = caret.getDot();
            if (BraceCompletion.posWithinString((Document)baseDocument, n)) {
                try {
                    baseDocument.insertString(n, "\" + \"", null);
                    CodeStyle codeStyle = CodeStyle.getDefault((Document)baseDocument);
                    if (codeStyle.wrapAfterBinaryOps()) {
                        caret.setDot(n += 3);
                        return new Integer(1);
                    }
                    caret.setDot(++n);
                    return new Integer(3);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                try {
                    if (BraceCompletion.isAddRightBrace(baseDocument, n)) {
                        boolean[] blArray = new boolean[]{true};
                        int n2 = BraceCompletion.getRowOrBlockEnd(baseDocument, n, blArray);
                        if (blArray[0]) {
                            baseDocument.insertString(n2, "}", null);
                            baseDocument.getFormatter().indentNewLine((Document)baseDocument, n2);
                        }
                        caret.setDot(n);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.javadocBlockCompletion(jTextComponent, baseDocument, n);
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (object != null && object instanceof Integer) {
                int n = caret.getDot();
                caret.setDot(n + (Integer)object);
            }
        }

        private Object javadocBlockCompletion(JTextComponent jTextComponent, BaseDocument baseDocument, int n) {
            try {
                CharSequence charSequence;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                if (tokenSequence == null) {
                    return null;
                }
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious() || tokenSequence.token().id() != JavaTokenId.JAVADOC_COMMENT) {
                    return null;
                }
                int n2 = n - 3;
                if (n2 >= 0 && JavaInsertBreakAction.isOpenJavadoc(charSequence = DocumentUtilities.getText((Document)baseDocument), n - 1) && !JavaInsertBreakAction.isClosedJavadoc(charSequence, n)) {
                    baseDocument.insertString(n, "*/", null);
                    baseDocument.getFormatter().indentNewLine((Document)baseDocument, n);
                    jTextComponent.setCaretPosition(n);
                    this.isJavadocTouched = true;
                    return Boolean.TRUE;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return null;
        }

        private static boolean isOpenJavadoc(CharSequence charSequence, int n) {
            for (int i = n; i >= 0; --i) {
                char c = charSequence.charAt(i);
                if (c == '*' && i - 2 >= 0 && charSequence.charAt(i - 1) == '*' && charSequence.charAt(i - 2) == '/') {
                    return true;
                }
                if (c == '\n') {
                    return false;
                }
                if (c != '/' || i - 1 < 0 || charSequence.charAt(i - 1) != '*') continue;
                return false;
            }
            return false;
        }

        private static boolean isClosedJavadoc(CharSequence charSequence, int n) {
            int n2 = charSequence.length();
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                char c = charSequence.charAt(i);
                if (c == '*' && i < n2 - 1 && charSequence.charAt(i + 1) == '/') {
                    char c2;
                    if (n3 == 0 || i < n2 - 2) {
                        return true;
                    }
                    boolean bl = true;
                    for (int j = i + 2; j < n2 && (c2 = charSequence.charAt(j)) != '\n'; ++j) {
                        if (c2 != '\"' || j >= n2 - 1 || charSequence.charAt(j + 1) == '\'') continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    return true;
                }
                if (c == '/' && i < n2 - 1 && charSequence.charAt(i + 1) == '*') {
                    return false;
                }
                if (c == '\n') {
                    n3 = 0;
                    continue;
                }
                if (c != '\"' || i >= n2 - 1 || charSequence.charAt(i + 1) == '\'') continue;
                ++n3;
                n3 %= 2;
            }
            return false;
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                StringBuffer stringBuffer = new StringBuffer("System.out.println(\"");
                String string = (String)baseDocument.getProperty((Object)"title");
                if (string != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(':');
                }
                try {
                    stringBuffer.append(Utilities.getLineOffset((BaseDocument)baseDocument, (int)jTextComponent.getCaret().getDot()) + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                stringBuffer.append(' ');
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                if (baseKit == null) {
                    return;
                }
                Action action = baseKit.getActionByName("insert-content");
                if (action != null) {
                    Utilities.performAction((Action)action, (ActionEvent)new ActionEvent(jTextComponent, 1001, stringBuffer.toString()), (JTextComponent)jTextComponent);
                }
            }
        }
    }

    public static class JavaGenerateGoToPopupAction
    extends NbEditorKit.NbGenerateGoToPopupAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }

        private void addAcceleretors(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
            Keymap keymap = jTextComponent.getKeymap();
            if (keymap != null) {
                KeyStroke keyStroke;
                KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
                if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                } else if (action != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                    jMenuItem.setAccelerator(keyStroke);
                }
            }
        }

        private void addAction(JTextComponent jTextComponent, JMenu jMenu, Action action) {
            if (action != null) {
                String string = (String)action.getValue("Name");
                JMenuItem jMenuItem = null;
                if (action instanceof BaseAction) {
                    jMenuItem = ((BaseAction)action).getPopupMenuItem(jTextComponent);
                }
                if (jMenuItem == null) {
                    String string2 = (String)action.getValue("trimmed-text");
                    if (string2 == null) {
                        string2 = this.getItemText(jTextComponent, string, action);
                    }
                    if (string2 != null) {
                        jMenuItem = new JMenuItem(string2);
                        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string2);
                        jMenuItem.addActionListener(action);
                        this.addAcceleretors(action, jMenuItem, jTextComponent);
                        jMenuItem.setEnabled(action.isEnabled());
                        Object object = action.getValue("helpID");
                        if (object != null && object instanceof String) {
                            jMenuItem.putClientProperty("HelpID", object);
                        }
                    } else if ("goto-source".equals(string)) {
                        jMenuItem = new JMenuItem(NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted"));
                        this.addAcceleretors(action, jMenuItem, jTextComponent);
                        jMenuItem.setEnabled(false);
                    }
                }
                if (jMenuItem != null) {
                    jMenu.add(jMenuItem);
                }
            }
        }

        protected void addAction(JTextComponent jTextComponent, JMenu jMenu, String string) {
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            if (baseKit == null) {
                return;
            }
            Action action = baseKit.getActionByName(string);
            if (action != null) {
                this.addAction(jTextComponent, jMenu, action);
            } else {
                jMenu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent jTextComponent, String string, Action action) {
            String string2 = action instanceof BaseAction ? ((BaseAction)action).getPopupMenuText(jTextComponent) : string;
            return string2;
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            String string = NbBundle.getBundle(JavaKit.class).getString("generate-goto-popup");
            JMenu jMenu = new JMenu(string);
            this.addAction(jTextComponent, jMenu, "goto-source");
            this.addAction(jTextComponent, jMenu, "goto-declaration");
            this.addAction(jTextComponent, jMenu, "goto-super-implementation");
            this.addAction(jTextComponent, jMenu, "goto");
            return jMenu;
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            if (c == '\"' || c == '\'') {
                boolean bl2 = BraceCompletion.completeQuote(baseDocument, n, caret, c);
                if (bl2) {
                    caret.setDot(n + 1);
                } else {
                    super.insertString(baseDocument, n, caret, string, bl);
                }
            } else {
                super.insertString(baseDocument, n, caret, string, bl);
                BraceCompletion.charInserted(baseDocument, n, caret, c);
            }
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            Document document = jTextComponent.getDocument();
            if (c == '\"' || c == '\'') {
                if (document != null) {
                    try {
                        boolean bl2 = false;
                        int n2 = Math.min(caret.getDot(), caret.getMark());
                        int n3 = Math.max(caret.getDot(), caret.getMark());
                        if (n2 != n3) {
                            document.remove(n2, n3 - n2);
                        }
                        int n4 = caret.getDot();
                        if (document instanceof BaseDocument) {
                            bl2 = BraceCompletion.completeQuote((BaseDocument)document, n4, caret, c);
                        }
                        if (bl2) {
                            caret.setDot(n4 + 1);
                        } else if (string != null && string.length() > 0) {
                            document.insertString(n2, string, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            } else {
                super.replaceSelection(jTextComponent, n, caret, string, bl);
                if (document instanceof BaseDocument) {
                    BraceCompletion.charInserted((BaseDocument)document, caret.getDot() - 1, caret, c);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkIndentHotChars(JTextComponent jTextComponent, String string) {
            ExtFormatter extFormatter;
            int[] nArray;
            Formatter formatter;
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            if (baseDocument != null && (formatter = baseDocument.getFormatter()) instanceof ExtFormatter && (nArray = (extFormatter = (ExtFormatter)formatter).getReformatBlock(jTextComponent, string)) != null) {
                try {
                    nArray[0] = Utilities.getRowStart((BaseDocument)baseDocument, (int)nArray[0]);
                    nArray[1] = Utilities.getRowEnd((BaseDocument)baseDocument, (int)nArray[1]);
                    Reformat reformat = Reformat.get((Document)baseDocument);
                    reformat.lock();
                    try {
                        baseDocument.atomicLock();
                        try {
                            reformat.reformat(nArray[0], nArray[1]);
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    finally {
                        reformat.unlock();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

