/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Image;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ElementDescription {
    private static final String PKG_COLOR = "<font color=#808080>";
    private ClasspathInfo originalCPInfo;
    private ElementHandle<Element> handle;
    private ElementHandle<TypeElement> outtermostElement;
    private Collection<Modifier> modifiers;
    private String displayName;
    private final boolean overriddenFlag;

    public ElementDescription(CompilationInfo compilationInfo, Element element, boolean bl) {
        this.originalCPInfo = compilationInfo.getClasspathInfo();
        this.handle = ElementHandle.create((Element)element);
        this.outtermostElement = ElementHandle.create((Element)SourceUtils.getOutermostEnclosingTypeElement((Element)element));
        this.modifiers = element.getModifiers();
        this.displayName = bl ? ElementDescription.computeDisplayNameIsOverridden(element) : ElementDescription.computeDisplayNameOverrides(element);
        this.overriddenFlag = bl;
    }

    private static String computeDisplayNameIsOverridden(Element element) throws IllegalStateException {
        TypeElement typeElement;
        if (element.getKind().isClass() || element.getKind().isInterface()) {
            typeElement = (TypeElement)element;
        } else {
            assert (element.getKind() == ElementKind.METHOD) : element.getKind();
            typeElement = (TypeElement)element.getEnclosingElement();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Element element2 = typeElement.getEnclosingElement();
        stringBuilder.append("<html>");
        stringBuilder.append(ElementDescription.computeSimpleName(typeElement));
        while (ElementDescription.isAnonymous(element2) || element2.getKind() == ElementKind.CONSTRUCTOR || element2.getKind() == ElementKind.INSTANCE_INIT || element2.getKind() == ElementKind.METHOD || element2.getKind() == ElementKind.STATIC_INIT) {
            stringBuilder.append(' ');
            stringBuilder.append(NbBundle.getMessage(ElementDescription.class, (String)"NAME_In"));
            stringBuilder.append(' ');
            stringBuilder.append(ElementDescription.computeSimpleName(element2));
            element2 = element2.getEnclosingElement();
        }
        stringBuilder.append(' ');
        stringBuilder.append(PKG_COLOR);
        stringBuilder.append('(');
        stringBuilder.append(ElementDescription.getQualifiedName(element2));
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static boolean isAnonymous(Element element) {
        if (!element.getKind().isClass()) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        return typeElement.getQualifiedName() == null || typeElement.getQualifiedName().length() == 0 || typeElement.getSimpleName() == null || typeElement.getSimpleName().length() == 0;
    }

    private static String computeSimpleName(Element element) {
        if (ElementDescription.isAnonymous(element)) {
            return NbBundle.getMessage(ElementDescription.class, (String)"NAME_AnonynmousInner");
        }
        String string = element.getSimpleName().toString();
        return string;
    }

    private static CharSequence getQualifiedName(Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            return ((PackageElement)element).getQualifiedName();
        }
        if (element.getKind().isClass() || element.getKind().isInterface()) {
            return ((TypeElement)element).getQualifiedName();
        }
        throw new IllegalStateException();
    }

    private static String computeDisplayNameOverrides(Element element) {
        return ((TypeElement)element.getEnclosingElement()).getQualifiedName().toString();
    }

    public FileObject getSourceFile() {
        FileObject fileObject = SourceUtils.getFile(this.outtermostElement, (ClasspathInfo)this.originalCPInfo);
        if (fileObject != null) {
            return SourceUtils.getFile(this.outtermostElement, (ClasspathInfo)ClasspathInfo.create((FileObject)fileObject));
        }
        return null;
    }

    public ElementHandle<Element> getHandle() {
        return this.handle;
    }

    public Icon getIcon() {
        Image image = this.overriddenFlag ? ImageUtilities.loadImage((String)"org/netbeans/modules/java/editor/resources/is-overridden-badge.png") : ImageUtilities.loadImage((String)"org/netbeans/modules/java/editor/resources/overrides-badge.png");
        Image image2 = ImageUtilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)this.handle.getKind(), this.modifiers));
        return ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)image2, (Image)image, (int)16, (int)0));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Collection<Modifier> getModifiers() {
        return this.modifiers;
    }
}

