/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.util.Map;
import javax.swing.text.AttributeSet;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.LexerBasedHighlightLayer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

public class LexerBasedHighlightSequence
implements HighlightsSequence {
    private LexerBasedHighlightLayer layer;
    private Map<Token, ColoringAttributes.Coloring> colorings;
    private TokenSequence ts;
    private boolean started;

    public LexerBasedHighlightSequence(LexerBasedHighlightLayer layer, TokenSequence ts, Map<Token, ColoringAttributes.Coloring> colorings) {
        this.layer = layer;
        this.ts = ts;
        this.colorings = colorings;
    }

    private boolean moveNextImpl() {
        if (this.started) {
            return this.ts.moveNext();
        }
        this.started = true;
        return this.ts.moveNext();
    }

    public boolean moveNext() {
        while (this.moveNextImpl()) {
            Token t = this.ts.token();
            if (t.id() != JavaTokenId.IDENTIFIER || !this.colorings.containsKey(this.ts.token())) continue;
            return true;
        }
        return false;
    }

    public int getStartOffset() {
        return this.ts.offset();
    }

    public int getEndOffset() {
        return this.ts.offset() + this.ts.token().length();
    }

    public AttributeSet getAttributes() {
        return this.layer.getColoring(this.colorings.get(this.ts.token()));
    }
}

