/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.folding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.folding.JspFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class JspFoldManager
implements FoldManager {
    private FoldOperation operation;
    private static final int FOLD_UPDATE_DELAY = 1000;
    private boolean documentDirty = true;
    private BaseDocument doc;
    private final List<Fold> currentFolds = new ArrayList<Fold>(20);
    private Preferences prefs;
    private final RequestProcessor RP = new RequestProcessor(JspFoldManager.class.getSimpleName(), Runtime.getRuntime().availableProcessors());
    private final RequestProcessor.Task FOLDS_UPDATE_TASK = this.RP.create(new Runnable(){

        @Override
        public void run() {
            try {
                JspFoldManager.this.documentDirty = false;
                JspFoldManager.this.updateFolds();
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    });

    public JspFoldManager() {
        this.prefs = (Preferences)MimeLookup.getLookup((String)"text/x-jsp").lookup(Preferences.class);
    }

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void init(FoldOperation operation) {
        this.operation = operation;
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        Document document = this.getOperation().getHierarchy().getComponent().getDocument();
        if (document instanceof BaseDocument) {
            this.doc = (BaseDocument)document;
            this.restartTimer();
        }
    }

    private void restartTimer() {
        this.FOLDS_UPDATE_TASK.schedule(1000);
    }

    public void release() {
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.restartTimer();
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.restartTimer();
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    private List<FoldInfo> generateFolds() {
        try {
            int prevSelOffset;
            BaseDocument bdoc = this.getDocument();
            JspSyntaxSupport jspsup = JspSyntaxSupport.get((Document)bdoc);
            ArrayList<FoldInfo> found = new ArrayList<FoldInfo>(this.getDocument().getLength() / 100);
            SyntaxElement sel = jspsup.getElementChain(1);
            Stack stack = new Stack();
            int n = prevSelOffset = sel != null ? sel.getElementOffset() : 0;
            while (sel != null) {
                TagSE tse;
                if (this.documentDirty) {
                    return null;
                }
                if (sel.getCompletionContext() == 4) {
                    found.add(new FoldInfo((Document)this.doc, sel.getElementOffset(), sel.getElementOffset() + sel.getElementLength(), JspFoldTypes.COMMENT, "<%--...--%>"));
                } else if (sel.getCompletionContext() == 7) {
                    found.add(new FoldInfo((Document)this.doc, sel.getElementOffset(), sel.getElementOffset() + sel.getElementLength(), JspFoldTypes.SCRIPTLET, "<%...%>"));
                } else if (sel.getCompletionContext() == 1) {
                    tse = new TagSE((SyntaxElement.TagLikeElement)sel);
                    this.handleOpenTagElement((Document)this.doc, tse, found, stack);
                } else if (sel.getCompletionContext() == 2) {
                    tse = new TagSE((SyntaxElement.TagLikeElement)sel);
                    this.handleEndTagElement((Document)this.doc, tse, found, stack);
                }
                if ((sel = sel.getNext()) == null) continue;
                if (prevSelOffset >= sel.getElementOffset()) {
                    return Collections.EMPTY_LIST;
                }
                prevSelOffset = sel.getElementOffset();
            }
            return found;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private void handleOpenTagElement(Document doc, TagSE tse, List found, Stack stack) throws BadLocationException {
        if (tse.isSingletonTag()) {
            found.add(new FoldInfo(doc, tse.getElementOffset(), tse.getElementOffset() + tse.getElementLength(), JspFoldTypes.TAG, this.getSingletonTagFoldName(tse.getTagName())));
        } else {
            stack.push(tse);
        }
    }

    private void handleEndTagElement(Document doc, TagSE tse, List found, Stack stack) throws BadLocationException {
        if (!stack.isEmpty()) {
            TagSE top = (TagSE)stack.peek();
            assert (top.isOpenTag());
            if (tse.getTagName().equals(top.getTagName())) {
                found.add(new FoldInfo(doc, top.getElementOffset(), tse.getElementOffset() + tse.getElementLength(), JspFoldTypes.TAG, this.getTagFoldName(top.getTagName())));
                stack.pop();
            } else {
                ArrayList<TagSE> savedElements = new ArrayList<TagSE>();
                boolean foundStartTag = false;
                while (!stack.isEmpty()) {
                    TagSE start = (TagSE)stack.pop();
                    savedElements.add(start);
                    assert (start.isOpenTag());
                    if (!start.getTagName().equals(tse.getTagName())) continue;
                    found.add(new FoldInfo(doc, start.getElementOffset(), tse.getElementOffset() + tse.getElementLength(), JspFoldTypes.TAG, this.getTagFoldName(start.getTagName())));
                    foundStartTag = true;
                    break;
                }
                if (!foundStartTag) {
                    for (int i = savedElements.size() - 1; i >= 0; --i) {
                        stack.push(savedElements.get(i));
                    }
                }
            }
        }
    }

    private String getSingletonTagFoldName(String tagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(tagName);
        sb.append("/>");
        return sb.toString();
    }

    private String getTagFoldName(String tagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(tagName);
        sb.append(">...</");
        sb.append(tagName);
        sb.append(">");
        return sb.toString();
    }

    private void mergeFolds(List<FoldInfo> generated, Set<Fold> zombies, Set<FoldInfo> newborns) throws BadLocationException {
        FoldHierarchy fh = this.getOperation().getHierarchy();
        HashSet<FoldInfo> olfs = new HashSet<FoldInfo>();
        for (FoldInfo elem : generated) {
            if (!this.isOneLineElement(elem)) continue;
            olfs.add(elem);
        }
        generated.removeAll(olfs);
        List existingFolds = FoldUtilities.findRecursive((Fold)fh.getRootFold());
        assert (existingFolds != null) : "Existing folds is null!";
        existingFolds.retainAll(this.currentFolds);
        Hashtable<Integer, FoldInfo> newbornsLinesCache = new Hashtable<Integer, FoldInfo>();
        HashSet<FoldInfo> duplicateNewborns = new HashSet<FoldInfo>();
        for (FoldInfo fi : generated) {
            int fiLineOffset = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.getStartOffset());
            FoldInfo found = (FoldInfo)newbornsLinesCache.get(new Integer(fiLineOffset));
            if (found != null && found.getEndOffset() < fi.getEndOffset()) {
                duplicateNewborns.add(found);
            }
            newbornsLinesCache.put(new Integer(fiLineOffset), fi);
            Fold fs = FoldUtilities.findNearestFold((FoldHierarchy)fh, (int)fi.getStartOffset());
            if (fs != null && fs.getStartOffset() == fi.getStartOffset() && fs.getEndOffset() == fi.getEndOffset() && this.currentFolds.contains(fs)) {
                if (fi.foldType == fs.getType() && fi.description.equals(fs.getDescription())) continue;
                zombies.add(fs);
                newborns.add(fi);
                continue;
            }
            newborns.add(fi);
        }
        newborns.removeAll(duplicateNewborns);
        existingFolds.removeAll(zombies);
        Hashtable<Integer, Fold> linesToFoldsCache = new Hashtable<Integer, Fold>();
        for (Fold f : existingFolds) {
            boolean found = false;
            for (FoldInfo fi : generated) {
                if (f.getStartOffset() != fi.getStartOffset() || f.getEndOffset() != fi.getEndOffset()) continue;
                found = true;
                break;
            }
            if (!found) {
                zombies.add(f);
                continue;
            }
            int lineoffset = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)f.getStartOffset());
            linesToFoldsCache.put(new Integer(lineoffset), f);
        }
        HashSet<FoldInfo> newbornsToRemove = new HashSet<FoldInfo>();
        for (FoldInfo fi : newborns) {
            Fold existing = (Fold)linesToFoldsCache.get(new Integer(Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.getStartOffset())));
            if (existing == null) continue;
            if (existing.getEndOffset() < fi.getEndOffset()) {
                zombies.add(existing);
                continue;
            }
            newbornsToRemove.add(fi);
        }
        newborns.removeAll(newbornsToRemove);
    }

    private synchronized void updateFolds() throws BadLocationException {
        final FoldHierarchy hierarchy = this.getOperation().getHierarchy();
        final HashSet zombies = new HashSet();
        final HashSet newborns = new HashSet();
        final BadLocationException[] ble = new BadLocationException[1];
        this.getDocument().render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    hierarchy.lock();
                    List generated = JspFoldManager.this.generateFolds();
                    if (generated == null) {
                        return;
                    }
                    JspFoldManager.this.mergeFolds(generated, zombies, newborns);
                }
                catch (BadLocationException ex) {
                    ble[0] = ex;
                }
                finally {
                    hierarchy.unlock();
                }
            }
        });
        if (ble[0] != null) {
            throw ble[0];
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JspFoldManager.this.getDocument().readLock();
                try {
                    hierarchy.lock();
                    try {
                        FoldHierarchyTransaction fhTran = JspFoldManager.this.getOperation().openTransaction();
                        try {
                            for (Fold f : zombies) {
                                JspFoldManager.this.getOperation().removeFromHierarchy(f, fhTran);
                                JspFoldManager.this.currentFolds.remove(f);
                            }
                            for (FoldInfo f : newborns) {
                                if (f.getStartOffset() < 0 || f.getEndOffset() < 0 || f.getStartOffset() >= f.getEndOffset() || f.getEndOffset() > JspFoldManager.this.getDocument().getLength()) continue;
                                try {
                                    JspFoldManager.this.currentFolds.add(JspFoldManager.this.getOperation().addToHierarchy(f.foldType, f.description, JspFoldManager.this.isInitiallyCollapsed(f.foldType), f.getStartOffset(), f.getEndOffset(), 0, 0, null, fhTran));
                                }
                                catch (BadLocationException ignore) {}
                            }
                        }
                        finally {
                            fhTran.commit();
                        }
                    }
                    finally {
                        hierarchy.unlock();
                    }
                }
                finally {
                    JspFoldManager.this.getDocument().readUnlock();
                }
            }
        });
    }

    private boolean isInitiallyCollapsed(FoldType foldType) {
        String prefName = null;
        if (foldType == JspFoldTypes.TAG) {
            prefName = "code-folding-collapse-tags";
        } else if (foldType == JspFoldTypes.COMMENT) {
            prefName = "code-folding-collapse-javadoc";
        }
        if (prefName != null) {
            return this.prefs.getBoolean(prefName, false);
        }
        return false;
    }

    private boolean isOneLineElement(FoldInfo fi) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.getStartOffset()) == Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.getEndOffset());
    }

    private BaseDocument getDocument() {
        return this.doc;
    }

    private static class TagSE {
        private SyntaxElement.TagLikeElement jspse = null;

        public TagSE(SyntaxElement.TagLikeElement se) {
            this.jspse = se;
        }

        public int getElementOffset() {
            return this.jspse.getElementOffset();
        }

        public int getElementLength() {
            return this.jspse.getElementLength();
        }

        public int getType() {
            return this.jspse.getCompletionContext();
        }

        public boolean isOpenTag() {
            return this.jspse.getCompletionContext() == 1;
        }

        public String getTagName() {
            return this.jspse.getName();
        }

        public boolean isSingletonTag() {
            if (!this.isOpenTag()) {
                return false;
            }
            return ((SyntaxElement.Tag)this.jspse).isClosed();
        }
    }

    private static class FoldInfo {
        private Position startOffset;
        private Position endOffset;
        private FoldType foldType;
        private String description;

        public FoldInfo(Document doc, int startOffset, int endOffset, FoldType foldType, String description) throws BadLocationException {
            this.startOffset = doc.createPosition(startOffset);
            this.endOffset = doc.createPosition(endOffset);
            this.foldType = foldType;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public int getEndOffset() {
            return this.endOffset.getOffset();
        }

        public FoldType getFoldType() {
            return this.foldType;
        }

        public int getStartOffset() {
            return this.startOffset.getOffset();
        }

        public String toString() {
            return "FoldInfo[start=" + this.startOffset + ", end=" + this.endOffset + ", descr=" + this.description + ", type=" + this.foldType + "]";
        }
    }
}

