/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.entity;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.entity.EntityWizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class EntityWizardPanel
extends JPanel {
    private Project project;
    private ChangeListener listener;
    static final String IS_VALID = "EntityWizardPanel_isValid";
    private boolean createPU;
    private ButtonGroup accessTypeGroup;
    private JCheckBox createPUCheckbox;
    private JLabel createPUWarningLabel;
    private JLabel jLabel1;
    private ButtonGroup persistenceGroup;
    private JTextField primaryKeyTextField;
    private JButton searchButton;

    public EntityWizardPanel(ChangeListener changeListener) {
        this.setProject(this.project);
        this.listener = changeListener;
        this.initComponents();
        this.createPUCheckbox.setSelected(true);
        this.primaryKeyTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }
        });
    }

    public String getPrimaryKeyClassName() {
        return this.primaryKeyTextField.getText();
    }

    void setPersistenceUnitButtonVisibility(boolean bl) {
        this.createPUCheckbox.setVisible(bl);
        this.updateWarning();
    }

    private void updateWarning() {
        String string = null;
        try {
            if (this.createPUCheckbox.isVisible() && !this.createPU && !ProviderUtil.persistenceExists(this.project) && ProviderUtil.isValidServerInstanceOrNone(this.project)) {
                string = NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_NoPersistenceUnit");
            }
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            string = NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)invalidPersistenceXmlException.getPath());
        }
        ImageIcon imageIcon = null;
        if (string != null) {
            imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/persistence/ui/resources/warning.gif", (boolean)false);
        } else {
            string = " ";
        }
        this.createPUWarningLabel.setIcon(imageIcon);
        this.createPUWarningLabel.setText(string);
        this.createPUWarningLabel.setToolTipText(string);
    }

    void setProject(Project project) {
        this.project = project;
    }

    public boolean isCreatePU() {
        return this.createPUCheckbox.isVisible() && this.createPU;
    }

    private void initComponents() {
        this.persistenceGroup = new ButtonGroup();
        this.accessTypeGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.primaryKeyTextField = new JTextField();
        this.searchButton = new JButton();
        this.createPUWarningLabel = new ShyLabel();
        this.createPUCheckbox = new JCheckBox();
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/entity/Bundle").getString("MN_PrimaryKeyType").charAt(0));
        this.jLabel1.setLabelFor(this.primaryKeyTextField);
        this.jLabel1.setText(NbBundle.getBundle(EntityWizardPanel.class).getString("LBL_PrimaryKeyClass"));
        this.primaryKeyTextField.setText("Long");
        this.searchButton.setText("...");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityWizardPanel.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.createPUWarningLabel.setText(" ");
        Mnemonics.setLocalizedText((AbstractButton)this.createPUCheckbox, (String)NbBundle.getMessage(EntityWizardPanel.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EntityWizardPanel.this.createPUCheckboxItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.primaryKeyTextField, -1, 241, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.searchButton)).add((Component)this.createPUWarningLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.createPUCheckbox).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.searchButton).add((Component)this.primaryKeyTextField, -2, -1, -2)).addPreferredGap(0, 39, Short.MAX_VALUE).add((Component)this.createPUWarningLabel).addPreferredGap(0).add((Component)this.createPUCheckbox)));
        this.primaryKeyTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityWizardPanel.class, (String)"LBL_PrimaryKeyClass"));
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle elementHandle = TypeElementFinder.find(null, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
                    }

                    public boolean accept(ElementHandle<TypeElement> elementHandle) {
                        return true;
                    }
                });
                if (elementHandle != null) {
                    EntityWizardPanel.this.primaryKeyTextField.setText(elementHandle.getQualifiedName());
                }
            }
        });
    }

    private void createPUCheckboxItemStateChanged(ItemEvent itemEvent) {
        this.createPU = this.createPUCheckbox.isVisible() && this.createPUCheckbox.isSelected();
        this.updateWarning();
        this.listener.stateChanged(null);
    }

    private static final class ShyLabel
    extends JLabel {
        private ShyLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 0;
            return dimension;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.width = 0;
            return dimension;
        }
    }
}

