/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.util.SourceLevelChecker;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class EntityClassesPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(EntityClassesPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JTextComponent packageComboBoxEditor;
    private PersistenceGenerator persistenceGen;
    private Project project;
    private boolean cmp;
    private String tableSourceName;
    private SelectedTables selectedTables;
    private final boolean puRequired;
    private JLabel classNamesLabel;
    private JScrollPane classNamesScrollPane;
    private JTable classNamesTable;
    private JCheckBox cmpFieldsInInterfaceCheckBox;
    private JCheckBox createPUCheckbox;
    private JLabel createPUWarningLabel;
    private JCheckBox generateFinderMethodsCheckBox;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JPanel spacerPanel;
    private JLabel specifyNamesLabel;

    private EntityClassesPanel(boolean bl) {
        this.puRequired = bl;
        this.initComponents();
        this.classNamesTable.getParent().setBackground(this.classNamesTable.getBackground());
        this.classNamesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.packageComboBoxEditor = (JTextComponent)this.packageComboBox.getEditor().getEditorComponent();
        Document document = this.packageComboBoxEditor.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                EntityClassesPanel.this.packageChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                EntityClassesPanel.this.packageChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                EntityClassesPanel.this.packageChanged();
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void initialize(PersistenceGenerator persistenceGenerator, Project project, boolean bl, FileObject fileObject) {
        SourceGroup sourceGroup;
        this.persistenceGen = persistenceGenerator;
        this.project = project;
        this.cmp = bl;
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroupArray);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updatePackageComboBox();
        if (fileObject != null && (sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroupArray, (FileObject)fileObject)) != null) {
            this.locationComboBox.setSelectedItem(sourceGroup);
            String string = SourceGroups.getPackageForFolder((SourceGroup)sourceGroup, (FileObject)fileObject);
            if (string != null) {
                this.packageComboBoxEditor.setText(string);
            }
        }
        if (!bl) {
            Mnemonics.setLocalizedText((AbstractButton)this.generateFinderMethodsCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_GenerateNamedQueryAnnotations"));
            this.cmpFieldsInInterfaceCheckBox.setVisible(false);
        }
        if (bl) {
            this.classNamesLabel.setVisible(false);
            this.classNamesScrollPane.setVisible(false);
            this.spacerPanel.setVisible(false);
            this.setName(NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_EntityBeansLocation"));
            Mnemonics.setLocalizedText((JLabel)this.specifyNamesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SpecifyBeansLocation"));
        }
        this.updatePersistenceUnitButton(true);
    }

    public void update(TableClosure tableClosure, String string) {
        try {
            if (this.selectedTables == null) {
                this.selectedTables = new SelectedTables(this.persistenceGen, tableClosure, this.getLocationValue(), this.getPackageName());
                this.selectedTables.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        EntityClassesPanel.this.changeSupport.fireChange();
                    }
                });
            } else {
                this.selectedTables.setTableClosureAndTargetFolder(tableClosure, this.getLocationValue(), this.getPackageName());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        TableUISupport.connectClassNames(this.classNamesTable, this.selectedTables);
        this.tableSourceName = string;
    }

    public SelectedTables getSelectedTables() {
        return this.selectedTables;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackageName() {
        return this.packageComboBoxEditor.getText();
    }

    public boolean getCmpFieldsInInterface() {
        return this.cmpFieldsInInterfaceCheckBox.isSelected();
    }

    public boolean getGenerateFinderMethods() {
        return this.generateFinderMethodsCheckBox.isSelected();
    }

    public boolean getCreatePersistenceUnit() {
        return this.createPUCheckbox.isVisible() && this.createPUCheckbox.isSelected();
    }

    private void locationChanged() {
        this.updatePackageComboBox();
        this.updateSelectedTables();
        this.changeSupport.fireChange();
    }

    private void packageChanged() {
        this.updateSelectedTables();
        this.changeSupport.fireChange();
    }

    private void updatePackageComboBox() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel comboBoxModel = PackageView.createListView((SourceGroup)sourceGroup);
            if (comboBoxModel.getSelectedItem() != null && comboBoxModel.getSelectedItem().toString().startsWith("META-INF") && comboBoxModel.getSize() > 1) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(1));
            }
            this.packageComboBox.setModel(comboBoxModel);
        }
    }

    private void updatePersistenceUnitButton(boolean bl) {
        ArrayList<Provider> arrayList;
        String string;
        String string2 = " ";
        try {
            boolean bl2;
            boolean bl3 = bl2 = !this.cmp && !ProviderUtil.persistenceExists(this.project);
            if (bl) {
                this.createPUCheckbox.setVisible(bl2);
                this.createPUCheckbox.setSelected(bl2);
                this.createPUCheckbox.setEnabled(!this.puRequired);
            }
            if (bl2 && !this.createPUCheckbox.isSelected()) {
                string2 = NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_NoPersistenceUnit");
            }
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            this.createPUCheckbox.setVisible(false);
            string2 = NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_InvalidPersistenceUnit", (Object)invalidPersistenceXmlException.getPath());
        }
        if (string2.trim().length() == 0 && this.getCreatePersistenceUnit() && (string = SourceLevelChecker.getSourceLevel(this.project)) != null && !"1.6".equals(string) && !(Double.parseDouble(string) >= 1.6) && (arrayList = Util.getProviders(this.project)) != null && arrayList.size() > 0 && "2.0".equals(ProviderUtil.getVersion(arrayList.get(0)))) {
            string2 = NbBundle.getMessage(RelatedCMPWizard.class, (String)"ERR_WrongSourceLevel", (Object)string);
        }
        if (string2.trim().length() > 0) {
            ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/persistence/ui/resources/warning.gif", (boolean)false);
            this.createPUWarningLabel.setIcon(imageIcon);
            this.createPUWarningLabel.setText(string2);
            this.createPUWarningLabel.setToolTipText(string2);
        } else {
            this.createPUWarningLabel.setIcon(null);
            this.createPUWarningLabel.setText(" ");
            this.createPUWarningLabel.setToolTipText(null);
        }
    }

    private void updateSelectedTables() {
        if (this.selectedTables != null) {
            try {
                this.selectedTables.setTargetFolder(this.getLocationValue(), this.getPackageName());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void initComponents() {
        this.specifyNamesLabel = new JLabel();
        this.classNamesLabel = new JLabel();
        this.classNamesScrollPane = new JScrollPane();
        this.classNamesTable = new TableUISupport.ClassNamesTable();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.generateFinderMethodsCheckBox = new JCheckBox();
        this.cmpFieldsInInterfaceCheckBox = new JCheckBox();
        this.spacerPanel = new JPanel();
        this.createPUWarningLabel = new ShyLabel();
        this.createPUCheckbox = new JCheckBox();
        this.setName(NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_EntityClasses"));
        Mnemonics.setLocalizedText((JLabel)this.specifyNamesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SpecifyEntityClassNames"));
        Mnemonics.setLocalizedText((JLabel)this.classNamesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_ClassNames"));
        this.classNamesScrollPane.setViewportView(this.classNamesTable);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityClassesPanel.this.locationComboBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        this.generateFinderMethodsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateFinderMethodsCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_GenerateFinderMethods"));
        this.generateFinderMethodsCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cmpFieldsInInterfaceCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cmpFieldsInInterfaceCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_AddFieldsToInterface"));
        this.cmpFieldsInInterfaceCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout groupLayout = new GroupLayout((Container)this.spacerPanel);
        this.spacerPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 383, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 9, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.createPUWarningLabel, (String)"  ");
        this.createPUWarningLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUWarningLabel.setMaximumSize(new Dimension(1000, 29));
        this.createPUCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createPUCheckbox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EntityClassesPanel.this.createPUCheckboxItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.specifyNamesLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.classNamesLabel).add((Component)this.projectLabel).add((Component)this.locationLabel).add((Component)this.packageLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.spacerPanel, -1, -1, Short.MAX_VALUE).add((Component)this.packageComboBox, 0, 383, Short.MAX_VALUE).add((Component)this.locationComboBox, 0, 383, Short.MAX_VALUE).add(2, (Component)this.projectTextField, -1, 383, Short.MAX_VALUE).add((Component)this.classNamesScrollPane, -1, 383, Short.MAX_VALUE))).add((Component)this.cmpFieldsInInterfaceCheckBox).add((Component)this.generateFinderMethodsCheckBox).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.createPUCheckbox).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.createPUWarningLabel, -1, 441, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.specifyNamesLabel).add(11, 11, 11).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.classNamesLabel).add((Component)this.classNamesScrollPane, -1, 61, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.spacerPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.projectTextField, -2, -1, -2).add((Component)this.projectLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.locationComboBox, -2, -1, -2).add((Component)this.locationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.packageComboBox, -2, -1, -2).add((Component)this.packageLabel)).add(21, 21, 21).add((Component)this.generateFinderMethodsCheckBox).addPreferredGap(0).add((Component)this.cmpFieldsInInterfaceCheckBox).addPreferredGap(0).add((Component)this.createPUCheckbox).add(11, 11, 11).add((Component)this.createPUWarningLabel, -2, -1, -2).addContainerGap()));
    }

    private void locationComboBoxActionPerformed(ActionEvent actionEvent) {
        this.locationChanged();
    }

    private void createPUCheckboxItemStateChanged(ItemEvent itemEvent) {
        if (!this.createPUCheckbox.isVisible() || this.createPUCheckbox.isSelected()) {
            // empty if block
        }
        this.updatePersistenceUnitButton(false);
    }

    private static final class ShyLabel
    extends JLabel {
        private ShyLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 0;
            return dimension;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.width = 0;
            return dimension;
        }
    }

    public static final class WizardPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishablePanel,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private EntityClassesPanel component;
        private boolean componentInitialized;
        private WizardDescriptor wizardDescriptor;
        private Project project;
        private boolean cmp;
        private boolean puRequired;
        private List<Provider> providers;

        public WizardPanel() {
            this(false);
        }

        public WizardPanel(boolean bl) {
            this.puRequired = bl;
        }

        public EntityClassesPanel getComponent() {
            if (this.component == null) {
                this.component = new EntityClassesPanel(this.puRequired);
                this.component.addChangeListener(this);
            }
            return this.component;
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public HelpCtx getHelp() {
            if (this.cmp) {
                return new HelpCtx("org.netbeans.modules.j2ee.ejbcore.ejb.wizard.cmp." + EntityClassesPanel.class.getSimpleName());
            }
            return new HelpCtx(EntityClassesPanel.class);
        }

        public void readSettings(Object object) {
            TableSource.Type type;
            String string;
            Object object2;
            this.wizardDescriptor = (WizardDescriptor)object;
            RelatedCMPHelper relatedCMPHelper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                object2 = relatedCMPHelper.getPersistenceGenerator();
                this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                this.cmp = RelatedCMPWizard.isCMP(this.wizardDescriptor);
                string = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
                this.getComponent().initialize((PersistenceGenerator)object2, this.project, this.cmp, (FileObject)string);
            }
            object2 = relatedCMPHelper.getTableSource();
            string = null;
            if (object2 != null && ((type = ((TableSource)object2).getType()) == TableSource.Type.DATA_SOURCE || type == TableSource.Type.CONNECTION)) {
                string = ((TableSource)object2).getName();
            }
            this.getComponent().update(relatedCMPHelper.getTableClosure(), string);
        }

        public boolean isValid() {
            String string;
            Object object;
            SourceGroup sourceGroup = this.getComponent().getLocationValue();
            if (sourceGroup == null) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_SelectSourceGroup"));
                return false;
            }
            String string2 = this.getComponent().getPackageName();
            if (string2.trim().equals("")) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_CantUseDefaultPackage"));
                return false;
            }
            if (!JavaIdentifiers.isValidPackageName((String)string2)) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_InvalidPackage"));
                return false;
            }
            if (!SourceGroups.isFolderWritable((SourceGroup)sourceGroup, (String)string2)) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_UnwritablePackage"));
                return false;
            }
            ClassPath classPath = null;
            try {
                object = SourceGroups.getFolderForPackage((SourceGroup)sourceGroup, (String)string2, (boolean)false);
                if (object == null) {
                    object = sourceGroup.getRootFolder();
                }
                classPath = ClassPath.getClassPath((FileObject)object, (String)"classpath/compile");
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
            if (classPath != null) {
                if (classPath.findResource("javax/persistence/EntityManager.class") == null) {
                    if (this.providers == null) {
                        this.providers = PersistenceLibrarySupport.getProvidersFromLibraries();
                    }
                    if (this.providers.size() == 0) {
                        this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_NoJavaPersistenceAPI"));
                        return false;
                    }
                }
            } else {
                LOGGER.warning("Cannot get a classpath for package " + string2 + " in " + sourceGroup);
            }
            if ((object = this.getComponent().getSelectedTables()) != null && (string = ((SelectedTables)object).getFirstProblemDisplayName()) != null) {
                this.setErrorMessage(string);
                return false;
            }
            this.setErrorMessage(" ");
            return true;
        }

        public void storeSettings(Object object) {
            RelatedCMPHelper relatedCMPHelper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
            relatedCMPHelper.setSelectedTables(this.getComponent().getSelectedTables());
            relatedCMPHelper.setLocation(this.getComponent().getLocationValue());
            relatedCMPHelper.setPackageName(this.getComponent().getPackageName());
            relatedCMPHelper.setCmpFieldsInInterface(this.getComponent().getCmpFieldsInInterface());
            relatedCMPHelper.setGenerateFinderMethods(this.getComponent().getGenerateFinderMethods());
            relatedCMPHelper.setCreatePU(this.getComponent().getCreatePersistenceUnit());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.changeSupport.fireChange();
        }

        private void setErrorMessage(String string) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

