/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeDescriptor
extends TypeDescriptor {
    private final PropertyDescriptor propertyDescriptor;
    private Annotation[] cachedAnnotations;

    public PropertyTypeDescriptor(PropertyDescriptor propertyDescriptor, MethodParameter methodParameter) {
        super(methodParameter);
        this.propertyDescriptor = propertyDescriptor;
    }

    public PropertyTypeDescriptor(PropertyDescriptor propertyDescriptor, MethodParameter methodParameter, Class<?> type) {
        super(methodParameter, type);
        this.propertyDescriptor = propertyDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] anns = this.cachedAnnotations;
        if (anns == null) {
            int n;
            Annotation[] annotationArray;
            Field underlyingField = ReflectionUtils.findField(this.getMethodParameter().getMethod().getDeclaringClass(), this.propertyDescriptor.getName());
            LinkedHashMap<Class<? extends Annotation>, Annotation> annMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
            if (underlyingField != null) {
                Annotation[] annotationArray2 = underlyingField.getAnnotations();
                int n2 = annotationArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    Annotation ann = annotationArray2[n3];
                    annMap.put(ann.annotationType(), ann);
                    ++n3;
                }
            }
            Method writeMethod = this.propertyDescriptor.getWriteMethod();
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (writeMethod != null && writeMethod != this.getMethodParameter().getMethod()) {
                annotationArray = writeMethod.getAnnotations();
                n = annotationArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Annotation ann = annotationArray[n4];
                    annMap.put(ann.annotationType(), ann);
                    ++n4;
                }
            }
            if (readMethod != null && readMethod != this.getMethodParameter().getMethod()) {
                annotationArray = readMethod.getAnnotations();
                n = annotationArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Annotation ann = annotationArray[n5];
                    annMap.put(ann.annotationType(), ann);
                    ++n5;
                }
            }
            annotationArray = this.getMethodParameter().getMethodAnnotations();
            n = annotationArray.length;
            int n6 = 0;
            while (n6 < n) {
                Annotation ann = annotationArray[n6];
                annMap.put(ann.annotationType(), ann);
                ++n6;
            }
            annotationArray = this.getMethodParameter().getParameterAnnotations();
            n = annotationArray.length;
            n6 = 0;
            while (n6 < n) {
                Annotation ann = annotationArray[n6];
                annMap.put(ann.annotationType(), ann);
                ++n6;
            }
            anns = annMap.values().toArray(new Annotation[annMap.size()]);
            this.cachedAnnotations = anns;
        }
        return anns;
    }
}

