/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerPropertiesPanel;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerLocationVisual
extends JPanel {
    private transient WLInstantiatingIterator instantiatingIterator;
    private JButton locationBrowseButton;
    private JLabel locationLabel;
    private JTextField locationField;
    private JPanel formattingPanel;
    private JFileChooser fileChooser;
    private Vector listeners = new Vector();

    public ServerLocationVisual(WLInstantiatingIterator wLInstantiatingIterator) {
        this.instantiatingIterator = wLInstantiatingIterator;
        this.setName(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_LOCATION_STEP"));
        this.init();
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
        String string = this.getInstallLocation();
        if (string.trim().length() < 1) {
            String string2 = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_EMPTY_SERVER_ROOT");
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(string2));
            return false;
        }
        File file = new File(string);
        WLPluginProperties.Version version = WLPluginProperties.getVersion(file);
        if (!WLPluginProperties.isSupportedVersion(version)) {
            String string3 = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_SERVER_VERSION");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(string3));
            return false;
        }
        if (!WLPluginProperties.isGoodServerLocation(file)) {
            String string4 = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_SERVER_ROOT");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(string4));
            return false;
        }
        WLPluginProperties.getInstance().setInstallLocation(string);
        WLPluginProperties.getInstance().saveProperties();
        this.instantiatingIterator.setServerRoot(string);
        return true;
    }

    private void init() {
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.locationBrowseButton = new JButton();
        this.formattingPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"LBL_SERVER_LOCATION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.locationLabel.setLabelFor(this.locationField);
        this.add((Component)this.locationLabel, gridBagConstraints);
        this.locationField.setColumns(10);
        this.locationField.addKeyListener(new LocationKeyListener());
        String string = WLPluginProperties.getInstance().getInstallLocation();
        if (string != null) {
            this.locationField.setText(string);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.locationField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocationVisual.class, (String)"ACSD_ServerLocationPanel_locationField"));
        this.add((Component)this.locationField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.locationBrowseButton, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"LBL_BROWSE_BUTTON"));
        this.locationBrowseButton.addActionListener(new BrowseActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.locationBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocationVisual.class, (String)"ACSD_ServerLocationPanel_locationBrowseButton"));
        this.add((Component)this.locationBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.formattingPanel, gridBagConstraints);
    }

    public String getInstallLocation() {
        return this.locationField.getText();
    }

    private void showFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setFileFilter(new DirectoryFileFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(1);
        File file = new File(this.locationField.getText());
        if (file.exists() && file.isDirectory()) {
            this.fileChooser.setCurrentDirectory(file.getParentFile());
            this.fileChooser.setSelectedFile(file);
        }
        if (this.fileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.locationField.setText(this.fileChooser.getSelectedFile().getPath());
            this.fireChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(changeListener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        this.fireChangeEvent(changeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent changeEvent) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)vector.elementAt(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    private static class DirectoryFileFilter
    extends FileFilter {
        private DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.exists() && file.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(ServerLocationVisual.class, (String)"DIRECTORIES_FILTER_NAME");
        }
    }

    private class BrowseActionListener
    implements ActionListener {
        private BrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ServerLocationVisual.this.showFileChooser();
        }
    }

    private class LocationKeyListener
    extends KeyAdapter {
        private LocationKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            ServerLocationVisual.this.fireChangeEvent();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            ServerLocationVisual.this.fireChangeEvent();
        }
    }
}

