/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.collector.stdout.spi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.collector.stdout.CLIODCConfiguration;
import org.netbeans.modules.dlight.collector.stdout.CLIOParser;
import org.netbeans.modules.dlight.collector.stdout.impl.CLIODCConfigurationAccessor;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public final class CLIODataCollector
extends IndicatorDataProvider<CLIODCConfiguration>
implements DataCollector<CLIODCConfiguration>,
DLightTarget.ExecutionEnvVariablesProvider {
    private static final Logger log = DLightLogger.getLogger(CLIODataCollector.class);
    private String command;
    private final Map<String, String> envs;
    private String argsTemplate;
    private DataStorage storage;
    private String displayedName;
    private Future<Integer> collectorTask;
    private CLIOParser parser;
    private List<DataTableMetadata> dataTablesMetadata;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private List<ValidationListener> validationListeners = Collections.synchronizedList(new ArrayList());
    private final DataStorageType dataStorageType;
    private final List<DataCollectorListener> listeners = new ArrayList<DataCollectorListener>();

    CLIODataCollector(CLIODCConfiguration configuration) {
        CLIODCConfigurationAccessor accessor = CLIODCConfigurationAccessor.getDefault();
        this.command = accessor.getCommand(configuration);
        this.argsTemplate = accessor.getArguments(configuration);
        this.parser = accessor.getParser(configuration);
        this.dataTablesMetadata = accessor.getDataTablesMetadata(configuration);
        this.envs = accessor.getDLightTargetExecutionEnv(configuration);
        this.displayedName = accessor.getName(configuration);
        if (this.displayedName == null) {
            int separatorIndex = this.command.lastIndexOf(File.separator);
            this.displayedName = separatorIndex == -1 || separatorIndex == this.command.length() - 1 ? this.command : this.command.substring(separatorIndex + 1);
        }
        this.dataStorageType = accessor.getDataStorageType(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDataCollectorListener(DataCollectorListener listener) {
        if (listener == null) {
            return;
        }
        CLIODataCollector cLIODataCollector = this;
        synchronized (cLIODataCollector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDataCollectorListener(DataCollectorListener listener) {
        CLIODataCollector cLIODataCollector = this;
        synchronized (cLIODataCollector) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(final DataCollector.CollectorState state) {
        DataCollectorListener[] ll;
        CLIODataCollector cLIODataCollector = this;
        synchronized (cLIODataCollector) {
            ll = this.listeners.toArray(new DataCollectorListener[0]);
        }
        final CountDownLatch doneFlag = new CountDownLatch(ll.length);
        for (final DataCollectorListener l : ll) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        l.collectorStateChanged((DataCollector)CLIODataCollector.this, state);
                    }
                    finally {
                        doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + l));
        }
        try {
            doneFlag.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public String getName() {
        return this.displayedName;
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        return Arrays.asList(this.dataStorageType);
    }

    public void init(Map<DataStorageType, DataStorage> storages, DLightTarget target) {
        DataStorageTypeFactory dstf = DataStorageTypeFactory.getInstance();
        this.storage = storages.get(this.dataStorageType);
        log.fine("Do INIT for " + this.storage.toString());
    }

    protected void processLine(String line) {
        DataRow dataRow = this.parser.process(line);
        if (dataRow != null) {
            if (this.dataTablesMetadata != null && !this.dataTablesMetadata.isEmpty() && this.storage != null) {
                this.storage.addData(this.dataTablesMetadata.iterator().next().getName(), Arrays.asList(dataRow));
            }
            this.notifyIndicators(Arrays.asList(dataRow));
        }
    }

    private void targetStarted(DLightTarget target) {
        log.fine("Starting CLIODataCollector: " + this.command);
        this.resetIndicators();
        String cmd = this.command + " ";
        if (target instanceof AttachableTarget) {
            AttachableTarget at = (AttachableTarget)target;
            cmd = cmd + this.argsTemplate.replaceAll("@PID", "" + at.getPID());
        } else {
            cmd = cmd + this.argsTemplate;
        }
        log.log(Level.FINE, "Starting CLIODataCollector cmd: {0}", cmd);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)target.getExecEnv());
        npb.setCommandLine(cmd);
        ExecutionDescriptor descriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new CLIOInputProcessorFactory()).errProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new CLIOInputProcessorFactory());
        ExecutionService execService = ExecutionService.newService((Callable)npb, (ExecutionDescriptor)descriptor, (String)("CLIODataCollector " + cmd));
        this.collectorTask = execService.run();
        DLightExecutorService.submit((Runnable)new Runnable(){

            @Override
            public void run() {
                CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.RUNNING);
                try {
                    CLIODataCollector.this.collectorTask.get();
                }
                catch (InterruptedException ex) {
                    CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.TERMINATED);
                    return;
                }
                catch (ExecutionException ex) {
                    CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.TERMINATED);
                    return;
                }
                catch (CancellationException ex) {
                    CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.TERMINATED);
                    return;
                }
                CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.STOPPED);
            }
        }, (String)"Listen for the CLIO task");
    }

    private void targetFinished(DLightTarget target) {
        if (this.collectorTask != null && !this.collectorTask.isDone()) {
            log.log(Level.FINE, "Stopping CLIODataCollector: {0}", this.collectorTask.toString());
            this.collectorTask.cancel(true);
        }
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        return this.dataTablesMetadata;
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        return this.command;
    }

    public String[] getArgs() {
        return null;
    }

    public void addValidationListener(ValidationListener listener) {
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    public void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    protected void notifyStatusChanged(ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (oldStatus.equals((Object)newStatus)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged((Validateable)this, oldStatus, newStatus);
        }
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(CLIODataCollector.class, (String)key, (Object[])params);
    }

    public ValidationStatus validate(DLightTarget target) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus oldStatus = this.validationStatus;
        ValidationStatus newStatus = this.doValidation(target);
        this.notifyStatusChanged(oldStatus, newStatus);
        this.validationStatus = newStatus;
        return newStatus;
    }

    public void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
    }

    private ValidationStatus doValidation(DLightTarget target) {
        DLightLogger.assertNonUiThread();
        ValidationStatus result = null;
        boolean fileExists = false;
        boolean connected = true;
        ExecutionEnvironment execEnv = target.getExecEnv();
        String error = "";
        try {
            fileExists = HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)this.command);
        }
        catch (InterruptedException ex) {
            error = CLIODataCollector.loc("ValidationStatus.InterruptedWhileValidation", new String[0]);
            return ValidationStatus.invalidStatus((String)error);
        }
        catch (IOException ex) {
            error = ex.getMessage();
            connected = false;
        }
        if (connected) {
            result = fileExists ? ValidationStatus.validStatus() : ValidationStatus.invalidStatus((String)CLIODataCollector.loc("ValidationStatus.CommandNotFound", this.command));
        } else {
            ConnectionManager mgr = ConnectionManager.getInstance();
            Runnable doOnConnect = new Runnable(){

                @Override
                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction connectAction = mgr.getConnectToAction(execEnv, doOnConnect);
            result = ValidationStatus.unknownStatus((String)CLIODataCollector.loc("ValidationStatus.ErrorWhileValidation", error), (AsynchronousAction)connectAction);
        }
        return result;
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.targetStarted(event.target);
                break;
            }
            case FAILED: {
                this.targetFinished(event.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(event.target);
                break;
            }
            case DONE: {
                this.targetFinished(event.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(event.target);
                return;
            }
        }
    }

    public void setupEnvironment(DLightTarget target, MacroMap env) {
        env.putAll(this.envs);
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    private class CLIOInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private CLIOInputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String line) {
                    CLIODataCollector.this.processLine(line);
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }
    }
}

