/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public final class ExecutionEnvironmentImpl
implements ExecutionEnvironment {
    private final String user;
    private final String host;
    private final int sshPort;
    private final String toString;

    ExecutionEnvironmentImpl() {
        this(null, null);
    }

    ExecutionEnvironmentImpl(String user, String host) {
        this(user, host, 0);
    }

    ExecutionEnvironmentImpl(String user, String host, int sshPort) {
        this.user = user == null ? System.getProperty("user.name") : user;
        this.host = host == null ? "localhost" : host;
        this.sshPort = !HostInfoUtils.isLocalhost(host) && sshPort == 0 ? 22 : sshPort;
        this.toString = this.user + "@" + this.host + (this.sshPort == 0 ? "" : ":" + this.sshPort);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getHostAddress() {
        return this.getHost();
    }

    @Override
    public String getDisplayName() {
        if (this.isLocal()) {
            return "localhost";
        }
        String result = this.user + "@" + this.host;
        if (this.sshPort != 22) {
            result = result + ":" + this.sshPort;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public int getSSHPort() {
        return this.sshPort;
    }

    @Override
    public boolean isRemote() {
        return !this.isLocal();
    }

    @Override
    public boolean isLocal() {
        return this.sshPort == 0;
    }

    @Override
    public boolean equals(Object obj) {
        ExecutionEnvironmentImpl ee = null;
        if (obj == null || !(obj instanceof ExecutionEnvironmentImpl)) {
            return false;
        }
        ee = (ExecutionEnvironmentImpl)obj;
        boolean bothLocalhost = ee.isLocal() && this.isLocal();
        boolean result = (bothLocalhost || ee.host.equals(this.host)) && ee.user.equals(this.user) && ee.sshPort == this.sshPort;
        return result;
    }

    public final int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.user != null ? this.user.hashCode() : 0);
        hash = 97 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 97 * hash + this.sshPort;
        return hash;
    }

    @Override
    public void prepareForConnection() throws IOException, CancellationException {
    }
}

