/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupport;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupportEvent;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupportListener;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.WeakSet;

public class ClassPathRootsListener
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ClassPathRootsListener.class.getName());
    private static ClassPathRootsListener INSTANCE;
    final Map<ClassPath, Collection<ClassPathRootsChangedListener>> cp2Listeners = new WeakHashMap<ClassPath, Collection<ClassPathRootsChangedListener>>();
    final Map<ClassPath, Set<File>> classPath2Roots = new WeakHashMap<ClassPath, Set<File>>();
    final Map<ClassPath, Boolean> classPath2Translate = new WeakHashMap<ClassPath, Boolean>();
    final Map<ClassPath.Entry, File> entry2File = new WeakHashMap<ClassPath.Entry, File>();
    final Map<ClassPath.Entry, FileChangeSupportListener> entry2Listener = new WeakHashMap<ClassPath.Entry, FileChangeSupportListener>();
    final Map<File, Reference<FileChangeSupportListener>> file2Listener = new WeakHashMap<File, Reference<FileChangeSupportListener>>();
    final Map<File, Set<ClassPath>> file2ClassPaths = new WeakHashMap<File, Set<ClassPath>>();
    final Map<File, Reference<File>> fileNormalizationFacility = new WeakHashMap<File, Reference<File>>();
    private static final ClassPath EMPTY_CLASSPATH;

    public static synchronized ClassPathRootsListener getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new ClassPathRootsListener();
        }
        return INSTANCE;
    }

    public void addClassPathRootsListener(final ClassPath cp, final boolean translate, final ClassPathRootsChangedListener pcl) {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                ClassPathRootsListener.this.addClassPathRootsListenerImpl(cp, translate, pcl);
                return null;
            }
        });
    }

    private synchronized void addClassPathRootsListenerImpl(ClassPath cp, boolean translate, ClassPathRootsChangedListener pcl) {
        Collection<ClassPathRootsChangedListener> listeners = this.cp2Listeners.get(cp);
        if (listeners == null) {
            listeners = new HashSet<ClassPathRootsChangedListener>();
            this.cp2Listeners.put(cp, listeners);
            cp.addPropertyChangeListener((PropertyChangeListener)this);
        }
        listeners.add(pcl);
        this.classPath2Translate.put(cp, translate);
        this.handleClassPath(cp);
    }

    private synchronized void handleClassPath(ClassPath cp) {
        Set<File> removedRoots = this.classPath2Roots.get(cp);
        removedRoots = removedRoots != null ? new HashSet<File>(removedRoots) : Collections.emptySet();
        HashMap<URL, ClassPath.Entry> url2Entry = new HashMap<URL, ClassPath.Entry>();
        for (ClassPath.Entry e : cp.entries()) {
            url2Entry.put(e.getURL(), e);
        }
        ClassPath translated = this.classPath2Translate.get(cp) == Boolean.TRUE ? ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(ClasspathInfo.create(EMPTY_CLASSPATH, cp, EMPTY_CLASSPATH), ClasspathInfo.PathKind.COMPILE) : cp;
        for (ClassPath.Entry e : translated.entries()) {
            WeakSet cps;
            FileChangeSupportListener l;
            File x;
            URL url = e.getURL();
            if ((e = (ClassPath.Entry)url2Entry.get(url)) == null) continue;
            File f = ClassPathRootsListener.fileForURL(url);
            Reference<File> rf = this.fileNormalizationFacility.get(f);
            File file = x = rf != null ? rf.get() : null;
            if (x == null) {
                this.fileNormalizationFacility.put(f, new WeakReference<File>(f));
            } else {
                f = x;
            }
            if (f == null) continue;
            this.entry2File.put(e, f);
            Reference<FileChangeSupportListener> r = this.file2Listener.get(f);
            FileChangeSupportListener fileChangeSupportListener = l = r != null ? r.get() : null;
            if (l == null) {
                l = new FileChangeSupportListener(){

                    @Override
                    public void fileCreated(FileChangeSupportEvent event) {
                        LOGGER.log(Level.FINE, "file created: {0}", event.getPath());
                        this.fileChanged(event.getPath());
                    }

                    @Override
                    public void fileDeleted(FileChangeSupportEvent event) {
                        LOGGER.log(Level.FINE, "file deleted: {0}", event.getPath());
                        this.fileChanged(event.getPath());
                    }

                    @Override
                    public void fileModified(FileChangeSupportEvent event) {
                        LOGGER.log(Level.FINE, "file modified: {0}", event.getPath());
                        this.fileChanged(event.getPath());
                    }

                    private void fileChanged(File f) {
                        try {
                            CachingArchiveProvider.getDefault().clearArchive(f.toURI().toURL());
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        Collection cps = ClassPathRootsListener.this.file2ClassPaths.get(f);
                        if (cps != null) {
                            ClassPathRootsListener.this.fireRootsChanged(Collections.unmodifiableCollection(new LinkedList(cps)), f);
                        }
                    }
                };
                FileChangeSupport.DEFAULT.addListener(l, f);
                this.file2Listener.put(f, new WeakReference<FileChangeSupportListener>(l));
            }
            if ((cps = this.file2ClassPaths.get(f)) == null) {
                cps = new WeakSet();
                this.file2ClassPaths.put(f, (Set<ClassPath>)cps);
            }
            cps.add((ClassPath)cp);
            WeakSet files = this.classPath2Roots.get(cp);
            if (files == null) {
                files = new WeakSet();
                this.classPath2Roots.put(cp, (Set<File>)files);
            }
            files.add((File)f);
            this.entry2Listener.put(e, l);
            removedRoots.remove(f);
        }
        for (File r : removedRoots) {
            FileChangeSupportListener l;
            Set<ClassPath> cps = this.file2ClassPaths.get(r);
            if (cps == null) continue;
            cps.remove(cp);
            if (!cps.isEmpty()) continue;
            Reference<FileChangeSupportListener> ref = this.file2Listener.remove(r);
            FileChangeSupportListener fileChangeSupportListener = l = ref != null ? ref.get() : null;
            if (l != null) {
                FileChangeSupport.DEFAULT.removeListener(l, r);
            }
            this.file2ClassPaths.remove(r);
        }
    }

    static File fileForURL(URL root) {
        File f = ClassPathRootsListener.fileForURLImpl(root);
        if (f == null) {
            return null;
        }
        f = FileUtil.normalizeFile((File)f);
        return f;
    }

    private static File fileForURLImpl(URL root) {
        URL inner;
        String protocol = root.getProtocol();
        if ("file".equals(protocol)) {
            return new File(URI.create(root.toExternalForm()));
        }
        if ("jar".equals(protocol) && "file".equals(protocol = (inner = FileUtil.getArchiveFile((URL)root)).getProtocol())) {
            return new File(URI.create(inner.toExternalForm()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRootsChanged(Collection<ClassPath> cps, File binary) {
        IdentityHashMap<ClassPathRootsChangedListener, Boolean> listeners = new IdentityHashMap<ClassPathRootsChangedListener, Boolean>();
        ClassPathRootsListener classPathRootsListener = this;
        synchronized (classPathRootsListener) {
            for (ClassPath cp : cps) {
                Collection<ClassPathRootsChangedListener> thisListeners = this.cp2Listeners.get(cp);
                if (listeners == null) continue;
                for (ClassPathRootsChangedListener l : thisListeners) {
                    listeners.put(l, true);
                }
            }
        }
        if (listeners.isEmpty()) {
            return;
        }
        for (ClassPathRootsChangedListener l : listeners.keySet()) {
            l.rootsChanged(cps, binary);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("entries".equals(evt.getPropertyName())) {
            ClassPath cp = (ClassPath)evt.getSource();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "classpath entries changed: cp={0} ({2}), entries={1}", new Object[]{cp, cp.entries(), System.identityHashCode(cp)});
            }
            this.handleClassPath(cp);
            this.fireRootsChanged(Collections.singleton(cp), null);
        }
    }

    static {
        EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    }

    public static interface ClassPathRootsChangedListener {
        public void rootsChanged(Collection<ClassPath> var1, File var2);
    }
}

