/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;

final class RDocAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(RDocAnalyzer.class.getName());
    static final String PARAM_HINT_ARG = "#:arg:";
    static final String PARAM_HINT_RETURN = "#:return:=>";
    private static final List<TypeCommentAnalyzer> RAW_TYPE_COMMENT_ANALYZERS = RDocAnalyzer.initRawTypeCommentAnalyzers();
    private static final List<TypeCommentAnalyzer> TYPE_COMMENT_ANALYZERS = RDocAnalyzer.initTypeCommentAnalyzers();
    private static final Pattern PARAM_HINT_ARG_PATTERN = Pattern.compile("#:arg:\\s*(\\S+)\\s*=>\\s*(.+)\\s*");
    private final RubyType type = new RubyType();

    private RDocAnalyzer() {
    }

    private static List<TypeCommentAnalyzer> initRawTypeCommentAnalyzers() {
        ArrayList<TypeCommentAnalyzer> result = new ArrayList<TypeCommentAnalyzer>();
        result.add(new HashAnalyzer());
        result.add(new ArrayAnalyzer());
        return result;
    }

    private static List<TypeCommentAnalyzer> initTypeCommentAnalyzers() {
        ArrayList<TypeCommentAnalyzer> result = new ArrayList<TypeCommentAnalyzer>();
        result.add(new ClassNameAnalyzer());
        result.add(new CustomClassNameAnalyzer());
        result.add(new NumericAnalyzer());
        result.add(new TrueFalseAnalyzer());
        result.add(new StringAnalyzer());
        return result;
    }

    static RubyType collectTypesFromComment(List<? extends String> comment) {
        String string;
        String string2;
        RDocAnalyzer rda = new RDocAnalyzer();
        Iterator<? extends String> i$ = comment.iterator();
        while (i$.hasNext() && RDocAnalyzer.inspect(string2 = (string = i$.next()).trim())) {
            rda.parseTypeFromLine(string2);
        }
        return rda.type;
    }

    private static boolean inspect(String line) {
        return line.startsWith("#  ") || line.startsWith(PARAM_HINT_ARG) || line.startsWith(PARAM_HINT_RETURN);
    }

    private void parseTypeFromLine(String line) {
        if (this.addTypes(RDocAnalyzer.returnTypeFromTypeAssertion(line))) {
            return;
        }
        int typeIndex = line.indexOf(" #=> ");
        if (typeIndex == -1) {
            typeIndex = line.indexOf(" -> ");
        }
        if (typeIndex == -1) {
            typeIndex = line.indexOf(" => ");
        }
        if (typeIndex == -1) {
            return;
        }
        String rawCommentTypes = line.substring(typeIndex + 4).trim();
        if (rawCommentTypes.length() == 0) {
            return;
        }
        this.addTypes(RDocAnalyzer.analyzeRawCommentType(rawCommentTypes));
        if (this.type.isKnown()) {
            LOGGER.log(Level.FINE, "Could not resolve type for {0}", line);
        }
    }

    private boolean addTypes(List<String> types) {
        if (types.isEmpty()) {
            return false;
        }
        for (String each : types) {
            this.type.add(each);
        }
        return true;
    }

    private static List<String> analyzeRawCommentType(String rawCommentTypes) {
        String[] rawCommentTypes2;
        ArrayList<String> result = new ArrayList<String>();
        for (String rawCommentType : rawCommentTypes2 = rawCommentTypes.split(" or ")) {
            String[] commentTypes;
            for (TypeCommentAnalyzer analyzer : RAW_TYPE_COMMENT_ANALYZERS) {
                String realType = analyzer.getType(rawCommentType);
                if (realType == null) continue;
                result.add(realType);
                return result;
            }
            for (String commentType : commentTypes = rawCommentType.split(",")) {
                String type;
                if ((commentType = commentType.trim()).length() <= 0 || (type = RDocAnalyzer.addRealTypeForCommentType(commentType)) == null) continue;
                result.add(type);
            }
        }
        return result;
    }

    private static String addRealTypeForCommentType(String commentType) {
        for (TypeCommentAnalyzer analyzer : TYPE_COMMENT_ANALYZERS) {
            String realType = analyzer.getType(commentType);
            if (realType == null) continue;
            return realType;
        }
        return null;
    }

    static List<String> returnTypeFromTypeAssertion(String line) {
        int start = line.indexOf(PARAM_HINT_RETURN);
        if (start != -1) {
            String rawCommentTypes = line.substring(start + PARAM_HINT_RETURN.length()).trim();
            if (rawCommentTypes.length() == 0) {
                return Collections.emptyList();
            }
            return RDocAnalyzer.analyzeRawCommentType(rawCommentTypes);
        }
        return Collections.emptyList();
    }

    static TypeForSymbol paramTypesFromTypeAssertion(String line) {
        Matcher matcher = PARAM_HINT_ARG_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        return new TypeForSymbol(matcher.group(1), RDocAnalyzer.analyzeRawCommentType(matcher.group(2).trim()));
    }

    static void collectTypeAssertions(ContextKnowledge knowledge) {
        List<String> rdoc;
        Node root = knowledge.getRoot();
        if (root instanceof MethodDefNode && (rdoc = AstUtilities.gatherDocumentation(knowledge.getParserResult().getSnapshot(), root)) != null && rdoc.size() > 0) {
            for (String line : rdoc) {
                List<String> returnTypes = RDocAnalyzer.returnTypeFromTypeAssertion(line);
                if (!returnTypes.isEmpty()) {
                    knowledge.setType(root, new RubyType(returnTypes));
                    continue;
                }
                TypeForSymbol tfs = RDocAnalyzer.paramTypesFromTypeAssertion(line);
                if (tfs == null) continue;
                knowledge.maybePutTypeForSymbol(tfs.getName(), new RubyType(tfs.getTypes()), true);
            }
        }
    }

    static List<String> getStandardNameVariants(String baseName) {
        ArrayList<String> result = new ArrayList<String>(9);
        result.add(baseName);
        result.add("a_" + baseName);
        result.add("an_" + baseName);
        String underlined = RubyUtils.camelToUnderlinedName(baseName);
        result.add(underlined);
        result.add("a_" + underlined);
        result.add("an_" + underlined);
        String camelCase = RubyUtils.underlinedNameToCamel(baseName);
        result.add(camelCase);
        result.add("a" + camelCase);
        result.add("an" + camelCase);
        return result;
    }

    private static String validName(String type) {
        if (RubyUtils.isValidConstantName(type)) {
            return type;
        }
        return null;
    }

    static String resolveType(String typeInComment) {
        if ("".equals(typeInComment.trim()) || !Character.isLetter(typeInComment.charAt(0))) {
            return null;
        }
        if (typeInComment.startsWith("an_")) {
            return RDocAnalyzer.validName(RubyUtils.underlinedNameToCamel(typeInComment.substring(3)));
        }
        if (typeInComment.startsWith("a_")) {
            return RDocAnalyzer.validName(RubyUtils.underlinedNameToCamel(typeInComment.substring(2)));
        }
        if (typeInComment.startsWith("an") && typeInComment.length() > 2 && Character.isUpperCase(typeInComment.charAt(2))) {
            return RDocAnalyzer.validName(typeInComment.substring(2));
        }
        if (typeInComment.startsWith("a") && typeInComment.length() > 1 && Character.isUpperCase(typeInComment.charAt(1))) {
            return RDocAnalyzer.validName(typeInComment.substring(1));
        }
        if (Character.isUpperCase(typeInComment.charAt(0))) {
            return RDocAnalyzer.validName(typeInComment);
        }
        return RDocAnalyzer.validName(RubyUtils.underlinedNameToCamel(typeInComment));
    }

    static class TypeForSymbol {
        private final String name;
        private final List<String> types;

        public TypeForSymbol(String name, List<String> types) {
            this.name = name;
            this.types = types;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getTypes() {
            return this.types;
        }
    }

    private static final class HashAnalyzer
    extends TypeCommentAnalyzer {
        private HashAnalyzer() {
        }

        @Override
        protected String doGetType(String typeInComment) {
            String trimmed = typeInComment.trim();
            if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
                return "Hash";
            }
            return null;
        }
    }

    private static final class ArrayAnalyzer
    extends TypeCommentAnalyzer {
        private ArrayAnalyzer() {
        }

        @Override
        protected String doGetType(String typeInComment) {
            String trimmed = typeInComment.trim();
            if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                return "Array";
            }
            return null;
        }
    }

    private static final class TrueFalseAnalyzer
    extends TypeCommentAnalyzer {
        private static final String[] TRUE_TYPES = new String[]{"true"};
        private static final String[] FALSE_TYPES = new String[]{"false"};

        private TrueFalseAnalyzer() {
        }

        @Override
        protected String doGetType(String typeInComment) {
            for (String type : TRUE_TYPES) {
                if (!type.equalsIgnoreCase(typeInComment)) continue;
                return "TrueClass";
            }
            for (String type : FALSE_TYPES) {
                if (!type.equalsIgnoreCase(typeInComment)) continue;
                return "FalseClass";
            }
            return null;
        }
    }

    private static final class StringAnalyzer
    extends TypeCommentAnalyzer {
        private StringAnalyzer() {
        }

        @Override
        protected String doGetType(String typeInComment) {
            return typeInComment.startsWith("\"") && typeInComment.endsWith("\"") ? "String" : null;
        }
    }

    private static final class NumericAnalyzer
    extends TypeCommentAnalyzer {
        private NumericAnalyzer() {
        }

        @Override
        protected String doGetType(String typeInComment) {
            if (this.isFixnum(typeInComment)) {
                return "Fixnum";
            }
            if (this.isFloat(typeInComment)) {
                return "Float";
            }
            return null;
        }

        private boolean isFixnum(String str) {
            try {
                Integer.parseInt(str);
                return true;
            }
            catch (NumberFormatException nfe) {
                if (str.startsWith("+") && str.length() > 1) {
                    return this.isFixnum(str.substring(1));
                }
                return false;
            }
        }

        private boolean isFloat(String str) {
            try {
                Float.parseFloat(str);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
    }

    private static final class CustomClassNameAnalyzer
    extends TypeCommentAnalyzer {
        private static final String[] EXCEPTIONS = new String[]{"Self", "Key", "Value", "Detail", "Result"};

        private CustomClassNameAnalyzer() {
        }

        @Override
        protected String doGetType(String typeInComment) {
            String result = RDocAnalyzer.resolveType(typeInComment);
            for (String each : EXCEPTIONS) {
                if (!each.equals(result)) continue;
                return null;
            }
            return result;
        }
    }

    private static final class ClassNameAnalyzer
    extends TypeCommentAnalyzer {
        private static final Map<String, String> COMMENT_TYPE_TO_REAL_TYPE = new HashMap<String, String>();

        private ClassNameAnalyzer() {
        }

        private static void putType(String baseName, String type) {
            for (String each : RDocAnalyzer.getStandardNameVariants(baseName)) {
                COMMENT_TYPE_TO_REAL_TYPE.put(each, type);
            }
        }

        @Override
        protected String doGetType(String comment) {
            return COMMENT_TYPE_TO_REAL_TYPE.get(comment);
        }

        static {
            COMMENT_TYPE_TO_REAL_TYPE.put("!obj", "FalseClass");
            ClassNameAnalyzer.putType("abs_file_name", "String");
            ClassNameAnalyzer.putType("class", "Class");
            ClassNameAnalyzer.putType("super_class", "Class");
            ClassNameAnalyzer.putType("klass", "Class");
            ClassNameAnalyzer.putType("dir", "Dir");
            ClassNameAnalyzer.putType("dir_name", "String");
            ClassNameAnalyzer.putType("fixnum", "Fixnum");
            ClassNameAnalyzer.putType("hash", "Hash");
            ClassNameAnalyzer.putType("hsh", "Hash");
            ClassNameAnalyzer.putType("array", "Array");
            ClassNameAnalyzer.putType("sub_array", "Array");
            ClassNameAnalyzer.putType("ary", "Array");
            ClassNameAnalyzer.putType("object", "Object");
            ClassNameAnalyzer.putType("enum", "Enumeration");
            ClassNameAnalyzer.putType("enumerat", "Enumeration");
            ClassNameAnalyzer.putType("enumerator", "Enumeration");
            ClassNameAnalyzer.putType("enumeration", "Enumeration");
            ClassNameAnalyzer.putType("io", "IO");
            ClassNameAnalyzer.putType("ios", "IO");
            ClassNameAnalyzer.putType("proc", "Proc");
            ClassNameAnalyzer.putType("str", "String");
            ClassNameAnalyzer.putType("base_name", "String");
            ClassNameAnalyzer.putType("big", "Bignum");
            ClassNameAnalyzer.putType("bignum", "Bignum");
            ClassNameAnalyzer.putType("boolean", "TrueClass");
            ClassNameAnalyzer.putType("bool", "TrueClass");
            ClassNameAnalyzer.putType("buffer", "String");
            ClassNameAnalyzer.putType("binding", "Binding");
            ClassNameAnalyzer.putType("exception", "Exception");
            ClassNameAnalyzer.putType("no_method_error", "NoMethodError");
            COMMENT_TYPE_TO_REAL_TYPE.put("false", "FalseClass");
            ClassNameAnalyzer.putType("file", "File");
            ClassNameAnalyzer.putType("fixnum", "Fixnum");
            ClassNameAnalyzer.putType("float", "Float");
            ClassNameAnalyzer.putType("flt", "Float");
            COMMENT_TYPE_TO_REAL_TYPE.put(":foo", "Symbol");
            ClassNameAnalyzer.putType("integer", "Integer");
            ClassNameAnalyzer.putType("int", "Integer");
            ClassNameAnalyzer.putType("matchdata", "MatchData");
            ClassNameAnalyzer.putType("method", "Method");
            ClassNameAnalyzer.putType("mod", "Module");
            ClassNameAnalyzer.putType("name_error", "NameError");
            ClassNameAnalyzer.putType("new_method", "UnboundMethod");
            ClassNameAnalyzer.putType("new_regexp", "Regexp");
            ClassNameAnalyzer.putType("new_str", "String");
            ClassNameAnalyzer.putType("new_time", "Time");
            ClassNameAnalyzer.putType("nil", "NilClass");
            ClassNameAnalyzer.putType("number", "Numeric");
            ClassNameAnalyzer.putType("numeric", "Numeric");
            ClassNameAnalyzer.putType("numeric_result", "Numeric");
            ClassNameAnalyzer.putType("num", "Numeric");
            ClassNameAnalyzer.putType("obj", "Object");
            ClassNameAnalyzer.putType("other_big", "Bignum");
            ClassNameAnalyzer.putType("outbuf", "String");
            ClassNameAnalyzer.putType("prc", "Proc");
            ClassNameAnalyzer.putType("range", "Range");
            ClassNameAnalyzer.putType("regexp", "Regexp");
            ClassNameAnalyzer.putType("rng", "Range");
            COMMENT_TYPE_TO_REAL_TYPE.put("stat", "File::Stat");
            ClassNameAnalyzer.putType("string", "String");
            ClassNameAnalyzer.putType("str", "String");
            ClassNameAnalyzer.putType("system_exit", "SystemExit");
            ClassNameAnalyzer.putType("struct", "Struct");
            ClassNameAnalyzer.putType("struct_tms", "Struct::Tms");
            ClassNameAnalyzer.putType("symbol", "Symbol");
            ClassNameAnalyzer.putType("sym", "Symbol");
            ClassNameAnalyzer.putType("thgrp", "ThreadGroup");
            ClassNameAnalyzer.putType("thread", "Thread");
            ClassNameAnalyzer.putType("thr", "Thread");
            ClassNameAnalyzer.putType("time", "Time");
            COMMENT_TYPE_TO_REAL_TYPE.put("class_or_module", "Class");
            COMMENT_TYPE_TO_REAL_TYPE.put("e", "Enumeration");
            COMMENT_TYPE_TO_REAL_TYPE.put("old_seed", "Numeric");
            COMMENT_TYPE_TO_REAL_TYPE.put("old_seed", "Numeric");
            COMMENT_TYPE_TO_REAL_TYPE.put("true", "TrueClass");
            COMMENT_TYPE_TO_REAL_TYPE.put("false", "FalseClass");
            COMMENT_TYPE_TO_REAL_TYPE.put("path", "String");
            COMMENT_TYPE_TO_REAL_TYPE.put("$_", "String");
            ClassNameAnalyzer.putType("unbound_method", "UnboundMethod");
        }
    }

    private static abstract class TypeCommentAnalyzer {
        private TypeCommentAnalyzer() {
        }

        final String getType(String comment) {
            String result = this.doGetType(comment);
            if (result != null && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Resolved type [" + result + "] for comment: [" + comment + "]. " + "Analyzer: [" + this.getClass().getSimpleName() + "].");
            }
            return result;
        }

        protected abstract String doGetType(String var1);
    }
}

