/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class TransferFile {
    public static final String SEPARATOR = "/";
    public static final String CWD = ".";
    private final TransferFile parent;
    private final List<TransferFile> children = new LinkedList<TransferFile>();
    private final String name;
    private final String relativePath;
    private final String parentRelativePath;
    private final long size;
    private final boolean directory;
    private final boolean file;
    private long timestamp;

    private TransferFile(TransferFile parent, String name, String relativePath, String parentRelativePath, long size, boolean directory, boolean file) {
        this(parent, name, relativePath, parentRelativePath, size, directory, file, -1L);
    }

    private TransferFile(TransferFile parent, String name, String relativePath, String parentRelativePath, long size, boolean directory, boolean file, long timestamp) {
        assert (size >= 0L) : "Size cannot be smaller than 0";
        if (directory && size != 0L) {
            throw new IllegalArgumentException("Size of a directory has to be 0 bytes");
        }
        this.parent = parent;
        this.name = name;
        this.relativePath = relativePath;
        this.parentRelativePath = parentRelativePath;
        this.directory = directory;
        this.file = file;
        this.size = size;
        this.timestamp = timestamp;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public static TransferFile fromFile(TransferFile parent, File file, String baseDirectory, boolean isDirectory) {
        assert (file != null);
        assert (baseDirectory != null);
        file = FileUtil.normalizeFile((File)file);
        assert (file.getAbsolutePath().startsWith(baseDirectory)) : "File must be underneath base directory [" + file.getAbsolutePath() + " => " + baseDirectory + "]";
        String name = file.getName();
        String relativePath = TransferFile.getPlatformIndependentPath(TransferFile.getRelativePath(file.getAbsolutePath(), baseDirectory));
        String parentRelativePath = TransferFile.getPlatformIndependentPath(TransferFile.getParentRelativePath(file.getParentFile().getAbsolutePath(), baseDirectory));
        boolean directory = isDirectory;
        boolean f = !isDirectory;
        long size = directory ? 0L : file.length();
        return new TransferFile(parent, name, relativePath, parentRelativePath, size, directory, f, TimeUnit.SECONDS.convert(file.lastModified(), TimeUnit.MILLISECONDS));
    }

    public static TransferFile fromFile(TransferFile parent, File file, String baseDirectory) {
        return TransferFile.fromFile(parent, file, baseDirectory, file.isDirectory());
    }

    public static TransferFile fromFileObject(TransferFile parent, FileObject fo, String baseDirectory) {
        assert (fo != null);
        return TransferFile.fromFile(parent, FileUtil.toFile((FileObject)fo), baseDirectory, fo.isFolder());
    }

    public static TransferFile fromRemoteFile(TransferFile parent, RemoteFile remoteFile, String baseDirectory, String parentDirectory) {
        assert (remoteFile != null);
        assert (baseDirectory.startsWith(SEPARATOR)) : "Base directory must start with '/' [" + baseDirectory + "]";
        assert (parentDirectory.startsWith(SEPARATOR)) : "Parent directory must start with '/' [" + parentDirectory + "]";
        assert (parentDirectory.startsWith(baseDirectory)) : "Parent directory must be underneath base directory [" + parentDirectory + " => " + baseDirectory + "]";
        String name = remoteFile.getName();
        String absolutePath = parentDirectory + SEPARATOR + name;
        String relativePath = TransferFile.getRelativePath(absolutePath, baseDirectory);
        String parentRelativePath = TransferFile.getParentRelativePath(parentDirectory, baseDirectory);
        boolean directory = remoteFile.isDirectory();
        boolean file = remoteFile.isFile();
        long size = directory ? 0L : remoteFile.getSize();
        return new TransferFile(parent, name, relativePath, parentRelativePath, size, directory, file, remoteFile.getTimestamp());
    }

    public static TransferFile fromPath(TransferFile parent, String path) {
        assert (path != null);
        return new TransferFile(parent, path, path, path, 0L, false, false);
    }

    private void addChild(TransferFile child) {
        this.children.add(child);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<TransferFile> getChildren() {
        return new ArrayList<TransferFile>(this.children);
    }

    public TransferFile getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isProjectRoot() {
        return CWD.equals(this.relativePath);
    }

    private static String getRelativePath(String absolutePath, String baseDirectory) {
        if (absolutePath.equals(baseDirectory)) {
            return CWD;
        }
        return absolutePath.substring(baseDirectory.length() + SEPARATOR.length());
    }

    private static String getParentRelativePath(String parentPath, String baseDirectory) {
        if (parentPath.length() < baseDirectory.length()) {
            return null;
        }
        if (parentPath.equals(baseDirectory)) {
            return CWD;
        }
        return parentPath.substring(baseDirectory.length() + SEPARATOR.length());
    }

    private static String getPlatformIndependentPath(String path) {
        if (path == null) {
            return null;
        }
        if (File.separator.equals(SEPARATOR)) {
            return path;
        }
        return path.replace(File.separator, SEPARATOR);
    }

    private static String getPlatformDependentPath(String path) {
        if (path == null) {
            return null;
        }
        if (File.separator.equals(SEPARATOR)) {
            return path;
        }
        return path.replace(SEPARATOR, File.separator);
    }

    public String getName() {
        return this.name;
    }

    public String getRelativePath() {
        return this.getRelativePath(false);
    }

    public String getRelativePath(boolean platformDependent) {
        if (platformDependent) {
            return TransferFile.getPlatformDependentPath(this.relativePath);
        }
        return this.relativePath;
    }

    public String getParentRelativePath() {
        return this.getParentRelativePath(false);
    }

    public String getParentRelativePath(boolean platformDependent) {
        if (platformDependent) {
            return TransferFile.getPlatformDependentPath(this.parentRelativePath);
        }
        return this.parentRelativePath;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isFile() {
        return this.file;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void touch() {
        this.timestamp = TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransferFile other = (TransferFile)obj;
        return this.relativePath.equals(other.relativePath);
    }

    public int hashCode() {
        return this.relativePath.hashCode();
    }

    public String toString() {
        return this.relativePath;
    }
}

