/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer.tree;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChangeSupport;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserPanel;
import org.openide.nodes.Node;

final class TransferSelectorModel {
    private final Set<TransferFile> transferFiles;
    private final Set<TransferFile> selected = new HashSet<TransferFile>();
    private final TransferFilesChangeSupport filesChangeSupport = new TransferFilesChangeSupport(this);

    public TransferSelectorModel(Set<TransferFile> transferFiles, long timestamp) {
        assert (transferFiles != null);
        this.transferFiles = this.copyNoProjectRoot(transferFiles);
        boolean select = timestamp == -1L;
        for (TransferFile file : this.transferFiles) {
            if (timestamp != -1L) {
                boolean bl = select = file.getTimestamp() > timestamp;
            }
            if (!select) continue;
            this.selected.add(file);
        }
    }

    public void addChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
        this.filesChangeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
        this.filesChangeSupport.removeChangeListener(listener);
    }

    public boolean isNodeSelected(Node node) {
        return this.selected.contains(this.getTransferFile(node));
    }

    public boolean isNodePartiallySelected(Node node) {
        TransferFile transferFile = this.getTransferFile(node);
        if (transferFile.isFile() || !this.selected.contains(transferFile)) {
            return false;
        }
        return !this.hasAllChildrenSelected(transferFile);
    }

    public void setNodeSelected(Node node, boolean select) {
        TransferFile transferFile = this.getTransferFile(node);
        if (transferFile == null) {
            return;
        }
        if (select) {
            this.addChildren(transferFile);
            this.addParents(transferFile);
        } else {
            this.removeChildren(transferFile);
        }
        this.filesChangeSupport.fireSelectedFilesChange();
    }

    public void selectAll() {
        this.selected.addAll(this.transferFiles);
        this.filesChangeSupport.fireSelectedFilesChange();
    }

    public void unselectAll() {
        this.selected.clear();
        this.filesChangeSupport.fireSelectedFilesChange();
    }

    public boolean isAllSelected() {
        return this.selected.size() == this.transferFiles.size();
    }

    public Set<TransferFile> getData() {
        return this.transferFiles;
    }

    public Set<TransferFile> getSelected() {
        return new HashSet<TransferFile>(this.selected);
    }

    public int getSelectedSize() {
        return this.selected.size();
    }

    private TransferFile getTransferFile(Node node) {
        return (TransferFile)node.getLookup().lookup(TransferFile.class);
    }

    private void addChildren(TransferFile file) {
        if (file.isProjectRoot()) {
            return;
        }
        this.selected.add(file);
        for (TransferFile child : file.getChildren()) {
            this.addChildren(child);
        }
    }

    private void addParents(TransferFile fromFile) {
        TransferFile parent = fromFile.getParent();
        if (parent != null) {
            if (parent.isProjectRoot()) {
                return;
            }
            this.selected.add(parent);
            this.addParents(parent);
        }
    }

    private void removeChildren(TransferFile file) {
        this.selected.remove(file);
        for (TransferFile child : file.getChildren()) {
            this.removeChildren(child);
        }
    }

    private boolean hasAllChildrenSelected(TransferFile transferFile) {
        if (!this.selected.contains(transferFile)) {
            return false;
        }
        for (TransferFile child : transferFile.getChildren()) {
            if (this.hasAllChildrenSelected(child)) continue;
            return false;
        }
        return true;
    }

    private Set<TransferFile> copyNoProjectRoot(Set<TransferFile> transferFiles) {
        HashSet<TransferFile> files = new HashSet<TransferFile>();
        for (TransferFile file : transferFiles) {
            if (file.isProjectRoot()) continue;
            files.add(file);
        }
        return files;
    }
}

