/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public abstract class RemoteCommand
extends Command {
    private static final char SEP_CHAR = '=';
    private static final int MAX_TYPE_SIZE = RemoteCommand.getFileTypeLabelMaxSize() + 2;
    private static final Color COLOR_SUCCESS = Color.GREEN.darker().darker();
    private static final Color COLOR_IGNORE = Color.ORANGE.darker();
    private static final RequestProcessor RP = new RequestProcessor("Remote connection", 1);
    private static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        @Override
        public void run() {
            Runnable toRun = (Runnable)RUNNABLES.poll();
            while (toRun != null) {
                toRun.run();
                toRun = (Runnable)RUNNABLES.poll();
            }
        }
    }, true);

    public RemoteCommand(PhpProject project) {
        super(project);
    }

    @Override
    public boolean isFileSensitive() {
        return true;
    }

    @Override
    public final void invokeAction(Lookup context) {
        if (!this.getConfigAction().isValid(false)) {
            return;
        }
        RUNNABLES.add(this.getContextRunnable(context));
        TASK.schedule(0);
    }

    @Override
    public final boolean isActionEnabled(Lookup context) {
        return this.isRemoteConfigSelected() && TASK.isFinished();
    }

    protected abstract Runnable getContextRunnable(Lookup var1);

    @Override
    public final boolean asyncCallRequired() {
        return false;
    }

    public static InputOutput getRemoteLog(String displayName) {
        return RemoteCommand.getRemoteLog(displayName, true);
    }

    public static InputOutput getRemoteLog(String displayName, boolean select) {
        InputOutput io = IOProvider.getDefault().getIO(NbBundle.getMessage(Command.class, (String)"LBL_RemoteLog", (Object)displayName), false);
        if (select) {
            io.select();
        }
        try {
            io.getOut().reset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return io;
    }

    protected RemoteClient getRemoteClient(InputOutput io, RemoteClient.OperationMonitor operationMonitor) {
        return new RemoteClient(this.getRemoteConfiguration(), new RemoteClient.AdvancedProperties().setInputOutput(io).setOperationMonitor(operationMonitor).setAdditionalInitialSubdirectory(this.getRemoteDirectory()).setPreservePermissions(ProjectPropertiesSupport.areRemotePermissionsPreserved(this.getProject())).setUploadDirectly(ProjectPropertiesSupport.isRemoteUploadDirectly(this.getProject())).setPhpVisibilityQuery(PhpVisibilityQuery.forProject(this.getProject())));
    }

    protected RemoteConfiguration getRemoteConfiguration() {
        String configName = this.getRemoteConfigurationName();
        assert (configName != null && configName.length() > 0) : "Remote configuration name must be selected";
        return RemoteConnections.get().remoteConfigurationForName(configName);
    }

    protected boolean isRemoteConfigSelected() {
        PhpProjectProperties.RunAsType runAs = ProjectPropertiesSupport.getRunAs(this.getProject());
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)runAs);
    }

    protected String getRemoteConfigurationName() {
        return ProjectPropertiesSupport.getRemoteConnection(this.getProject());
    }

    protected String getRemoteDirectory() {
        return ProjectPropertiesSupport.getRemoteDirectory(this.getProject());
    }

    public static void processRemoteException(RemoteException remoteException) {
        String title = NbBundle.getMessage(Command.class, (String)"LBL_RemoteError");
        StringBuilder message = new StringBuilder(remoteException.getMessage());
        String remoteServerAnswer = remoteException.getRemoteServerAnswer();
        Throwable cause = remoteException.getCause();
        if (remoteServerAnswer != null && remoteServerAnswer.length() > 0) {
            message.append(NbBundle.getMessage(Command.class, (String)"MSG_RemoteErrorReason", (Object)remoteServerAnswer));
        } else if (cause != null) {
            message.append(NbBundle.getMessage(Command.class, (String)"MSG_RemoteErrorReason", (Object)cause.getMessage()));
        }
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)message.toString(), title, 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    protected static void processTransferInfo(TransferInfo transferInfo, InputOutput io) {
        OutputWriter out = io.getOut();
        OutputWriter err = io.getErr();
        out.println();
        out.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSummary"));
        StringBuilder sep = new StringBuilder(20);
        for (int i = 0; i < sep.capacity(); ++i) {
            sep.append('=');
        }
        out.println(sep.toString());
        int maxRelativePath = RemoteCommand.getRelativePathMaxSize(transferInfo);
        long size = 0L;
        int files = 0;
        if (transferInfo.hasAnyTransfered()) {
            RemoteCommand.printSuccess(io, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSucceeded"));
            for (TransferFile transferFile : transferInfo.getTransfered()) {
                RemoteCommand.printSuccess(io, maxRelativePath, transferFile);
                if (!transferFile.isFile()) continue;
                size += transferFile.getSize();
                ++files;
            }
        }
        if (transferInfo.hasAnyFailed()) {
            err.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteFailed"));
            for (Map.Entry entry : transferInfo.getFailed().entrySet()) {
                RemoteCommand.printError(err, maxRelativePath, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyPartiallyFailed()) {
            err.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemotePartiallyFailed"));
            for (Map.Entry entry : transferInfo.getPartiallyFailed().entrySet()) {
                RemoteCommand.printError(err, maxRelativePath, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyIgnored()) {
            RemoteCommand.printIgnore(io, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteIgnored"));
            for (Map.Entry entry : transferInfo.getIgnored().entrySet()) {
                RemoteCommand.printIgnore(io, maxRelativePath, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        long runtime = transferInfo.getRuntime();
        String timeUnit = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitMilisecond");
        if (runtime > 1000L) {
            runtime /= 1000L;
            timeUnit = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitSecond");
        }
        double s = (double)size / 1024.0;
        String sizeUnit = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitKilobyte");
        if (s > 1024.0) {
            s /= 1024.0;
            sizeUnit = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitMegabyte");
        }
        Object[] params = new Object[]{runtime, timeUnit, files, s, sizeUnit};
        out.println(NbBundle.getMessage(RemoteCommand.class, (String)"MSG_RemoteRuntimeAndSize", (Object[])params));
    }

    private static void print(InputOutput io, String message, Color color) {
        try {
            IOColorLines.println((InputOutput)io, (CharSequence)message, (Color)color);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void printSuccess(InputOutput io, String message) {
        RemoteCommand.print(io, message, COLOR_SUCCESS);
    }

    private static void printSuccess(InputOutput io, int maxRelativePath, TransferFile file) {
        String message = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s", RemoteCommand.getFileTypeLabel(file), file.getRelativePath());
        RemoteCommand.printSuccess(io, message);
    }

    private static void printError(OutputWriter writer, int maxRelativePath, TransferFile file, String reason) {
        String msg = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s   %s", RemoteCommand.getFileTypeLabel(file), file.getRelativePath(), reason);
        writer.println(msg);
    }

    private static void printIgnore(InputOutput io, String message) {
        RemoteCommand.print(io, message, COLOR_IGNORE);
    }

    private static void printIgnore(InputOutput io, int maxRelativePath, TransferFile file, String reason) {
        String msg = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s   %s", RemoteCommand.getFileTypeLabel(file), file.getRelativePath(), reason);
        RemoteCommand.printIgnore(io, msg);
    }

    private static String getFileTypeLabel(TransferFile file) {
        String type = null;
        type = file.isDirectory() ? "LBL_TypeDirectory" : (file.isFile() ? "LBL_TypeFile" : "LBL_TypeUnknown");
        return NbBundle.getMessage(RemoteCommand.class, (String)type);
    }

    private static int getFileTypeLabelMaxSize() {
        String str = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeDirectory");
        int max = str.length();
        if (max < (str = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeFile")).length()) {
            max = str.length();
        }
        if (max < (str = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeUnknown")).length()) {
            max = str.length();
        }
        return max;
    }

    private static int getRelativePathMaxSize(TransferInfo transferInfo) {
        int max = RemoteCommand.getRelativePathMaxSize(transferInfo.getTransfered());
        int size = RemoteCommand.getRelativePathMaxSize(transferInfo.getFailed().keySet());
        if (size > max) {
            max = size;
        }
        if ((size = RemoteCommand.getRelativePathMaxSize(transferInfo.getPartiallyFailed().keySet())) > max) {
            max = size;
        }
        if ((size = RemoteCommand.getRelativePathMaxSize(transferInfo.getIgnored().keySet())) > max) {
            max = size;
        }
        return max + 2;
    }

    private static int getRelativePathMaxSize(Collection<TransferFile> files) {
        int max = 0;
        for (TransferFile file : files) {
            int length = file.getRelativePath().length();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    protected final boolean sourcesFilesOnly(FileObject sources, FileObject[] selectedFiles) {
        for (FileObject file : selectedFiles) {
            if (FileUtil.isParentOf((FileObject)sources, (FileObject)file) || sources.equals(file)) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemoteCommand.class, (String)"MSG_TransferSourcesOnly"), 0));
            return false;
        }
        return true;
    }

    protected static int getWorkUnits(Set<TransferFile> files) {
        int totalSize = 0;
        for (TransferFile file : files) {
            totalSize = (int)((long)totalSize + file.getSize());
        }
        return totalSize / 1024;
    }

    public static final class DefaultOperationMonitor
    implements RemoteClient.OperationMonitor {
        private final String processMessageKey;
        int progressSize = 0;
        ProgressHandle progressHandle = null;

        public DefaultOperationMonitor(String processMessageKey) {
            assert (processMessageKey != null);
            this.processMessageKey = processMessageKey;
        }

        @Override
        public void operationStart(RemoteClient.Operation operation, Collection<TransferFile> forFiles) {
        }

        @Override
        public void operationProcess(RemoteClient.Operation operation, TransferFile forFile) {
            long size = forFile.getSize();
            if (size > 0L) {
                assert (this.progressHandle != null);
                this.progressHandle.progress(NbBundle.getMessage(DefaultOperationMonitor.class, (String)this.processMessageKey, (Object)forFile.getName()), this.progressSize);
                this.progressSize = (int)((long)this.progressSize + size / 1024L);
            }
        }

        @Override
        public void operationFinish(RemoteClient.Operation operation, Collection<TransferFile> forFiles) {
        }
    }
}

