/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.support.AskForUrlPanel;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class ConfigActionLocal
extends ConfigAction {
    private final FileObject webRoot;

    protected ConfigActionLocal(PhpProject project) {
        super(project);
        this.webRoot = ProjectPropertiesSupport.getWebRootDirectory(project);
        assert (this.webRoot != null);
    }

    @Override
    public boolean isValid(boolean indexFileNeeded) {
        boolean valid = true;
        if (indexFileNeeded && !this.isIndexFileValid(this.webRoot)) {
            valid = false;
        } else if (RunAsValidator.validateWebFields(ProjectPropertiesSupport.getUrl(this.project), FileUtil.toFile((FileObject)this.webRoot), null, ProjectPropertiesSupport.getArguments(this.project)) != null) {
            valid = false;
        }
        if (!valid) {
            this.showCustomizer();
        }
        return valid;
    }

    @Override
    public boolean isRunFileEnabled(Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context, this.webRoot);
        return file != null;
    }

    @Override
    public boolean isDebugFileEnabled(Lookup context) {
        if (XDebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(context);
    }

    @Override
    public void runProject() {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(CommandUtils.urlForProject(this.project));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void debugProject() {
        boolean keepDebugging;
        final URL[] urlToShow = new URL[2];
        try {
            URL urlForProject = this.getUrlToShow(CommandUtils.urlForProject(this.project));
            if (urlForProject != null) {
                urlToShow[0] = CommandUtils.createDebugUrl(urlForProject, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START);
                urlToShow[1] = CommandUtils.createDebugUrl(urlForProject, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_STOP_NO_EXEC);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (StopDebuggingException exc) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (urlToShow[0] != null) {
                        if (CommandUtils.getDebugInfo((PhpProject)ConfigActionLocal.this.project).debugClient) {
                            try {
                                ConfigActionLocal.this.launchJavaScriptDebugger(urlToShow[0]);
                            }
                            catch (URISyntaxException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        } else {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(urlToShow[0]);
                        }
                    }
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (urlToShow[1] != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(urlToShow[1]);
                }
                return true;
            }
        };
        boolean jsDebuggingAvailable = WebClientToolsSessionStarterService.isAvailable();
        if (jsDebuggingAvailable && !(keepDebugging = WebClientToolsProjectUtils.showDebugDialog((Project)this.project))) {
            return;
        }
        if (!jsDebuggingAvailable || WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project)) {
            XDebugStarter dbgStarter = XDebugStarterFactory.getInstance();
            if (dbgStarter != null) {
                if (dbgStarter.isAlreadyRunning()) {
                    if (CommandUtils.warnNoMoreDebugSession()) {
                        dbgStarter.stop();
                        this.debugProject();
                    }
                } else {
                    FileObject fileForProject = CommandUtils.fileForProject(this.project, this.webRoot);
                    if (fileForProject != null) {
                        this.startDebugger(dbgStarter, runnable, cancellable, fileForProject);
                    } else {
                        String idxFileName = ProjectPropertiesSupport.getIndexFile(this.project);
                        String err = NbBundle.getMessage(ConfigActionLocal.class, (String)"ERR_Missing_IndexFile", (Object)idxFileName);
                        NotifyDescriptor.Message messageDecriptor = new NotifyDescriptor.Message((Object)err, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)messageDecriptor);
                        ((CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Run");
                    }
                }
            }
        } else {
            runnable.run();
        }
    }

    @Override
    public void runFile(Lookup context) {
        try {
            URL url = CommandUtils.urlForContext(this.project, context);
            assert (url != null);
            this.preShowUrl(context);
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void debugFile(Lookup context) {
        URL urlForStartDebugging = null;
        URL urlForStopDebugging = null;
        try {
            URL urlForContext = this.getUrlToShow(CommandUtils.urlForContext(this.project, context));
            if (urlForContext != null) {
                urlForStartDebugging = CommandUtils.createDebugUrl(urlForContext, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START);
                urlForStopDebugging = CommandUtils.createDebugUrl(urlForContext, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_STOP_NO_EXEC);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        catch (StopDebuggingException exc) {
            return;
        }
        this.preShowUrl(context);
        this.debugFile(CommandUtils.fileForContextOrSelectedNodes(context, this.webRoot), urlForStartDebugging, urlForStopDebugging);
    }

    URL getUrlToShow(URL defaultRunUrl) throws MalformedURLException, StopDebuggingException {
        URL urlToShow = null;
        PhpProjectProperties.DebugUrl debugUrl = ProjectPropertiesSupport.getDebugUrl(this.project);
        switch (debugUrl) {
            case DEFAULT_URL: {
                urlToShow = defaultRunUrl;
                assert (urlToShow != null);
                break;
            }
            case ASK_FOR_URL: {
                AskForUrlPanel askForUrlPanel = new AskForUrlPanel(this.project, defaultRunUrl);
                if (!askForUrlPanel.open()) {
                    throw new StopDebuggingException();
                }
                urlToShow = askForUrlPanel.getUrl();
                assert (urlToShow != null);
                break;
            }
            case DO_NOT_OPEN_BROWSER: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state for debug URL: " + (Object)((Object)debugUrl));
            }
        }
        return urlToShow;
    }

    void debugFile(FileObject selectedFile, final URL urlForStartDebugging, final URL urlForStopDebugging) {
        boolean keepDebugging;
        assert (selectedFile != null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (urlForStartDebugging != null) {
                    try {
                        if (CommandUtils.getDebugInfo((PhpProject)ConfigActionLocal.this.project).debugClient) {
                            try {
                                ConfigActionLocal.this.launchJavaScriptDebugger(urlForStartDebugging);
                            }
                            catch (URISyntaxException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        } else {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(urlForStartDebugging);
                        }
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        };
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (urlForStopDebugging != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(urlForStopDebugging);
                }
                return true;
            }
        };
        boolean jsDebuggingAvailable = WebClientToolsSessionStarterService.isAvailable();
        if (jsDebuggingAvailable && !(keepDebugging = WebClientToolsProjectUtils.showDebugDialog((Project)this.project))) {
            return;
        }
        if (!jsDebuggingAvailable || WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project)) {
            XDebugStarter dbgStarter = XDebugStarterFactory.getInstance();
            if (dbgStarter != null) {
                if (dbgStarter.isAlreadyRunning()) {
                    if (CommandUtils.warnNoMoreDebugSession()) {
                        dbgStarter.stop();
                        this.debugFile(selectedFile, urlForStartDebugging, urlForStopDebugging);
                    }
                } else {
                    this.startDebugger(dbgStarter, runnable, cancellable, selectedFile);
                }
            }
        } else {
            runnable.run();
        }
    }

    protected void preShowUrl(Lookup context) {
    }

    private void startDebugger(XDebugStarter dbgStarter, Runnable initDebuggingCode, Cancellable cancellable, FileObject debuggedFile) {
        Callable<Cancellable> initDebuggingCallable = Executors.callable(initDebuggingCode, cancellable);
        XDebugStarter.Properties props = XDebugStarter.Properties.create(debuggedFile, false, ProjectPropertiesSupport.getDebugPathMapping(this.project), ProjectPropertiesSupport.getDebugProxy(this.project));
        dbgStarter.start(this.project, initDebuggingCallable, props);
    }

    private void launchJavaScriptDebugger(URL url) throws MalformedURLException, URISyntaxException {
        LocationMappersFactory mapperFactory = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
        Lookup debuggerLookup = null;
        if (mapperFactory != null) {
            URI appContext = CommandUtils.getBaseURL(this.project).toURI();
            FileObject[] srcRoots = PhpProjectUtils.getSourceObjects(this.project);
            JSToNbJSLocationMapper forwardMapper = mapperFactory.getJSToNbJSLocationMapper(srcRoots, appContext, null);
            NbJSToJSLocationMapper reverseMapper = mapperFactory.getNbJSToJSLocationMapper(srcRoots, appContext, null);
            debuggerLookup = Lookups.fixed((Object[])new Object[]{forwardMapper, reverseMapper, this.project});
        } else {
            debuggerLookup = Lookups.fixed((Object[])new Object[]{this.project});
        }
        URI clientUrl = url.toURI();
        HtmlBrowser.Factory browser = null;
        browser = WebClientToolsProjectUtils.isInternetExplorer((Project)this.project) ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
        if (browser == null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        } else {
            try {
                WebClientToolsSessionStarterService.startSession((URI)clientUrl, (HtmlBrowser.Factory)browser, (Lookup)debuggerLookup);
            }
            catch (WebClientToolsSessionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static final class StopDebuggingException
    extends Exception {
        private static final long serialVersionUID = -22807171434417714L;

        private StopDebuggingException() {
        }
    }
}

