/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiprof.timeline;

import com.mentorgen.tools.profile.Controller;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.jiprof.timeline.Action;
import net.sourceforge.jiprof.timeline.ActionRecord;
import net.sourceforge.jiprof.timeline.TimeLineProfiler;
import net.sourceforge.jiprof.timeline.TimeRecord;

public class TextOutput {
    public static void dump() throws IOException {
        Appendable appendable;
        System.err.println("TimeLine Profiler: generating output");
        String string = null;
        File file = new File(Controller._fileName);
        Date date = new Date();
        if (file.isDirectory()) {
            appendable = new StringBuffer(file.getAbsolutePath());
            ((StringBuffer)appendable).append(File.separator);
            ((StringBuffer)appendable).append(new SimpleDateFormat("yyyyMMdd-HHmmss").format(date));
            ((StringBuffer)appendable).append(".txt");
            string = ((StringBuffer)appendable).toString();
        } else if (Controller._fileName.endsWith(".txt")) {
            string = Controller._fileName;
        } else {
            appendable = new StringBuffer(Controller._fileName);
            ((StringBuffer)appendable).append(".txt");
            string = ((StringBuffer)appendable).toString();
        }
        appendable = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter((Writer)appendable);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        for (TimeRecord timeRecord : TimeLineProfiler._timeLine) {
            printWriter.print("Time: ");
            printWriter.print(timeRecord._pointInTime - TimeLineProfiler._startTime);
            if (Controller._timeResoltion == Controller.TimeResolution.ns) {
                printWriter.println(" ns.");
            } else {
                printWriter.println(" ms.");
            }
            for (ActionRecord actionRecord : timeRecord._actionRecordList) {
                printWriter.print('\t');
                if (actionRecord.getAction() == Action.START) {
                    printWriter.print("START");
                } else if (actionRecord.getAction() == Action.STOP) {
                    printWriter.print("END");
                } else if (actionRecord.getAction() == Action.ALLOC) {
                    printWriter.print("ALLOC");
                } else if (actionRecord.getAction() == Action.BEGIN_WAIT) {
                    printWriter.print("W:START");
                } else if (actionRecord.getAction() == Action.END_WAIT) {
                    printWriter.print("W:END");
                } else if (actionRecord.getAction() == Action.EXCEPTION) {
                    printWriter.print("THROWS");
                } else {
                    printWriter.print("???");
                }
                printWriter.print('\t');
                printWriter.print('[');
                printWriter.print(actionRecord.getThreadId());
                printWriter.print("]\t");
                String string2 = actionRecord.getClassName().replace('/', '.');
                int n = string2.lastIndexOf(46);
                String string3 = null;
                String string4 = "";
                if (n > -1) {
                    string3 = string2.substring(n + 1);
                    string4 = string2.substring(0, n);
                } else {
                    string3 = string2;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3);
                if (actionRecord.getMethodName().length() > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(actionRecord.getMethodName());
                }
                stringBuffer.append("\t(");
                stringBuffer.append(string4);
                stringBuffer.append(")");
                printWriter.println(stringBuffer.toString());
            }
        }
        printWriter.flush();
        printWriter.close();
    }
}

